/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSPotentiallyInvalidConstructorUsageInspection
extends JSInspection {
    public boolean myConsiderUppercaseFunctionsToBeConstructors = true;

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidConstructorUsageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSPotentiallyInvalidConstructorUsageInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSNewExpression(JSNewExpression node) {
                if (this.mayHaveProblem(node)) {
                    String messageKey;
                    String name;
                    JSReferenceExpression methodRefExpr = (JSReferenceExpression)node.getMethodExpression();
                    String string = name = methodRefExpr == null ? null : methodRefExpr.getReferenceName();
                    if (!StringUtil.isEmpty((String)name) && (messageKey = JSPotentiallyInvalidConstructorUsageInspection.this.getConstructorProblemKey(methodRefExpr, name)) != null) {
                        PsiElement element = methodRefExpr.getReferenceNameElement();
                        holder.registerProblem((PsiElement)(element != null ? element : methodRefExpr), JavaScriptBundle.message(messageKey, new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitJSCallExpression(JSCallExpression node) {
                if (this.mayHaveProblem(node)) {
                    if (!JSInheritedLanguagesHelper.constructorCallWithoutNewActual((PsiElement)node)) {
                        return;
                    }
                    JSReferenceExpression methodRefExpr = (JSReferenceExpression)node.getMethodExpression();
                    if (methodRefExpr == null || methodRefExpr.getQualifier() != null) {
                        return;
                    }
                    String name = methodRefExpr.getReferenceName();
                    if (!(StringUtil.isEmpty((String)name) || "Object".equals(name) || "Boolean".equals(name))) {
                        boolean constructorProblem;
                        JSFunction resolve = JSPsiImplUtils.getPossibleFunction(methodRefExpr.resolve());
                        if (resolve == null) {
                            return;
                        }
                        boolean bl = constructorProblem = JSSymbolUtil.isConstructorName(name) && JSPotentiallyInvalidConstructorUsageInspection.this.myConsiderUppercaseFunctionsToBeConstructors && resolve.isReferencesThis() || JSSymbolUtil.isDefinitelyConstructor((PsiElement)resolve);
                        if (constructorProblem && resolve.constructorCanBeInvokedWithoutNew()) {
                            constructorProblem = false;
                        }
                        if (constructorProblem && resolve.hasExplicitlyDeclaredReturnType()) {
                            constructorProblem = false;
                        }
                        if (constructorProblem) {
                            InsertNewFix insertNewFix = new InsertNewFix(node);
                            PsiElement element = methodRefExpr.getReferenceNameElement();
                            holder.registerProblem((PsiElement)(element != null ? element : methodRefExpr), JavaScriptBundle.message("javascript.constructor.call.without.new.message", new Object[0]), new LocalQuickFix[]{insertNewFix});
                        }
                    }
                }
            }

            @Override
            public void visitJSReferenceExpression(JSReferenceExpression node) {
                String messageKey;
                JSReferenceExpression referenceExpression;
                String name;
                JSExpression qualifier;
                if ("prototype".equals(node.getReferenceName()) && (qualifier = node.getQualifier()) instanceof JSReferenceExpression && !StringUtil.isEmpty((String)(name = (referenceExpression = (JSReferenceExpression)qualifier).getReferenceName())) && this.mayHaveProblem(referenceExpression) && (messageKey = JSPotentiallyInvalidConstructorUsageInspection.this.getConstructorProblemKey(referenceExpression, name)) != null) {
                    PsiElement element = referenceExpression.getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element != null ? element : referenceExpression), JavaScriptBundle.message(messageKey, new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean mayHaveProblem(JSCallExpression node) {
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    return this.mayHaveProblem((JSReferenceExpression)methodExpression);
                }
                return false;
            }

            private boolean mayHaveProblem(JSReferenceExpression methodRefExpr) {
                JSExpression newQualifier;
                ResolveResult[] name;
                boolean isJustCallContext;
                PsiElement parent = methodRefExpr.getParent();
                boolean bl = isJustCallContext = parent instanceof JSCallExpression && !(parent instanceof JSNewExpression);
                if (isJustCallContext && ("Number".equalsIgnoreCase((String)(name = methodRefExpr.getReferenceName())) || "String".equalsIgnoreCase((String)name) || "Error".equals(name))) {
                    return false;
                }
                for (ResolveResult r : methodRefExpr.multiResolve(false)) {
                    Object elt = r.getElement();
                    if (elt == null) continue;
                    JSType type = null;
                    JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(elt, (PsiElement)methodRefExpr, true);
                    if (functionItem != null) {
                        elt = functionItem;
                    }
                    if (elt instanceof JSVariable) {
                        if (elt instanceof JSParameter) {
                            return false;
                        }
                        if (!elt.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
                            return false;
                        }
                        type = ((JSVariable)elt).getJSType();
                    } else {
                        if (elt instanceof JSFunctionExpression) {
                            return false;
                        }
                        if (elt instanceof JSFunction) {
                            PsiElement eltParent = elt.getContext();
                            if ((eltParent instanceof JSClass || eltParent instanceof JSPackageStatement || eltParent instanceof JSFile && eltParent.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) && isJustCallContext) {
                                return false;
                            }
                            if (((JSFunction)elt).hasExplicitlyDeclaredReturnType()) {
                                return false;
                            }
                        } else if (elt instanceof JSClass) {
                            return false;
                        }
                    }
                    if (type == null || !(type instanceof JSPrimitiveFunctionType) && !"Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) continue;
                    return false;
                }
                JSExpression qualifier = methodRefExpr;
                while (qualifier instanceof JSReferenceExpression && (newQualifier = qualifier.getQualifier()) != null) {
                    qualifier = newQualifier;
                }
                if (qualifier instanceof JSReferenceExpression && qualifier != methodRefExpr) {
                    PsiElement resolve = qualifier.resolve();
                    return !(resolve instanceof JSVariable);
                }
                return !(qualifier instanceof JSThisExpression);
            }
        };
    }

    private @PropertyKey(resourceBundle="messages.JavaScriptBundle") @Nullable String getConstructorProblemKey(JSReferenceExpression methodRefExpr, String name) {
        boolean constructorProblem;
        boolean lowerCasedConstructorProblem;
        ResolveResult[] results = methodRefExpr.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        boolean bl = lowerCasedConstructorProblem = Character.isLowerCase(name.charAt(0)) && this.myConsiderUppercaseFunctionsToBeConstructors && !JSPotentiallyInvalidConstructorUsageInspection.definitelyHasConstructor(results);
        if (lowerCasedConstructorProblem) {
            return "javascript.constructor.with.lower.case.name.used.message";
        }
        boolean bl2 = constructorProblem = !this.myConsiderUppercaseFunctionsToBeConstructors && !JSPotentiallyInvalidConstructorUsageInspection.definitelyHasConstructor(results);
        if (constructorProblem) {
            return "javascript.not.a.constructor.call.message";
        }
        return null;
    }

    private static boolean definitelyHasConstructor(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSPotentiallyInvalidConstructorUsageInspection.$$$reportNull$$$0(2);
        }
        return Arrays.stream(results).anyMatch(it -> it.isValidResult() && JSSymbolUtil.isDefinitelyConstructor(it.getElement()));
    }

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(JavaScriptBundle.message("javascript.assume.uppercase.functions.to.be.constructors", new Object[0]), (InspectionProfileEntry)this, "myConsiderUppercaseFunctionsToBeConstructors");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "definitelyHasConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InsertNewFix
    extends FixAndIntentionAction {
        InsertNewFix(JSCallExpression node) {
            this.registerElementRefForFix((PsiElement)node, null);
        }

        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("insert.new.keyword.fix.name", new Object[0]);
            if (string == null) {
                InsertNewFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return true;
        }

        @Override
        protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
            if (file2 == null) {
                InsertNewFix.$$$reportNull$$$0(1);
            }
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> psiElement.replace((PsiElement)JSPsiElementFactory.createJSExpression("new " + psiElement.getText(), psiElement, JSNewExpression.class)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection$InsertNewFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection$InsertNewFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

