/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEditObjectLiteralPropertiesIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(1);
        }
        JSObjectLiteralExpression literal = JSEditObjectLiteralPropertiesIntention.findLiteral(element);
        assert (literal != null);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)literal);
        JSEditObjectLiteralPropertiesIntention.addVarsFromExpression(literal, builder);
        editor.getCaretModel().moveToOffset(literal.getTextOffset());
        templateManager.startTemplate(editor, builder.buildInlineTemplate());
    }

    private static void addVarsFromExpression(JSExpression expression, TemplateBuilderImpl builder) {
        JSArrayLiteralExpression array;
        JSObjectLiteralExpression literal;
        if (JSEditObjectLiteralPropertiesIntention.isLiteralOrUndefined(expression)) {
            builder.replaceElement((PsiElement)expression, (Expression)new ConstantNode(expression.getText()), true);
        }
        if ((literal = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)expression, JSObjectLiteralExpression.class)) != null) {
            JSProperty[] properties2;
            for (JSProperty property : properties2 = literal.getProperties()) {
                JSEditObjectLiteralPropertiesIntention.addVarsFromExpression(property.getValue(), builder);
            }
        }
        if ((array = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)expression, JSArrayLiteralExpression.class)) != null) {
            JSExpression[] expressions = array.getExpressions();
            if (expressions.length == 0) {
                builder.replaceElement((PsiElement)expression, (Expression)new ConstantNode(expression.getText()), true);
            } else {
                for (JSExpression jsExpression : expressions) {
                    JSEditObjectLiteralPropertiesIntention.addVarsFromExpression(jsExpression, builder);
                }
            }
        }
    }

    private static boolean isLiteralOrUndefined(@Nullable JSExpression expression) {
        return expression instanceof JSLiteralExpression || expression instanceof JSReferenceExpression && "undefined".equals(expression.getText());
    }

    @Nullable
    private static JSObjectLiteralExpression findLiteral(@NotNull PsiElement element) {
        PsiElement original;
        JSObjectLiteralExpression parentLiteral;
        PsiElement parent;
        if (element == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(2);
        }
        if ((parent = element.getParent()) instanceof JSExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSProperty && (parentLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSObjectLiteralExpression.class)) != null) {
            return parentLiteral;
        }
        if (!(element instanceof LeafPsiElement || (element = (original = element).getPrevSibling()) instanceof LeafPsiElement || (element = original.getNextSibling()) instanceof LeafPsiElement)) {
            return null;
        }
        IElementType elementType = ((LeafPsiElement)element).getElementType();
        return !JSEditObjectLiteralPropertiesIntention.isBrace(elementType) ? null : (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)parent, JSObjectLiteralExpression.class);
    }

    private static boolean isBrace(IElementType elementType) {
        return elementType == JSTokenTypes.LBRACE || elementType == JSTokenTypes.RBRACE;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSObjectLiteralExpression literal;
        if (project == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(4);
        }
        return (literal = JSEditObjectLiteralPropertiesIntention.findLiteral(element)) != null && JSEditObjectLiteralPropertiesIntention.hasPropertiesToEdit(literal);
    }

    private static boolean hasPropertiesToEdit(@NotNull JSObjectLiteralExpression literal) {
        JSProperty[] properties2;
        if (literal == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(5);
        }
        for (JSProperty property : properties2 = literal.getProperties()) {
            JSExpression value = property.getValue();
            if (!JSEditObjectLiteralPropertiesIntention.isEditableExpression(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEditableExpression(@Nullable JSExpression value) {
        if (JSEditObjectLiteralPropertiesIntention.isLiteralOrUndefined(value)) {
            return true;
        }
        if (value instanceof JSObjectLiteralExpression && JSEditObjectLiteralPropertiesIntention.hasPropertiesToEdit((JSObjectLiteralExpression)value)) {
            return true;
        }
        if (value instanceof JSArrayLiteralExpression) {
            for (JSExpression expression : ((JSArrayLiteralExpression)value).getExpressions()) {
                if (!JSEditObjectLiteralPropertiesIntention.isEditableExpression(expression)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.edit.object.literal", new Object[0]);
        if (string == null) {
            JSEditObjectLiteralPropertiesIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSEditObjectLiteralPropertiesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSEditObjectLiteralPropertiesIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLiteral";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasPropertiesToEdit";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

