/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json.adapters;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.json.adapters.JSJsonArrayAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonForeignValueAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonGenericValueAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonObjectAdapter;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final JSProperty myProperty;

    public JSJsonPropertyAdapter(@NotNull JSProperty property) {
        if (property == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @Nullable
    public String getName() {
        return this.myProperty.getName();
    }

    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        return this.myProperty.getValue() == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(this.myProperty.getValue());
    }

    @Nullable
    public JsonValueAdapter getNameValueAdapter() {
        return null;
    }

    @NotNull
    public PsiElement getDelegate() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(1);
        }
        return jSProperty;
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        return this.myProperty.getParent() instanceof JSObjectLiteralExpression ? new JSJsonObjectAdapter((JSObjectLiteralExpression)this.myProperty.getParent()) : null;
    }

    @NotNull
    public static List<JsonValueAdapter> createValueAdaptersByType(@NotNull JSExpression value) {
        JSExpression innerExpression;
        IElementType sign;
        if (value == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(2);
        }
        if (value instanceof JSObjectLiteralExpression) {
            List<JSJsonObjectAdapter> list2 = Collections.singletonList(new JSJsonObjectAdapter((JSObjectLiteralExpression)value));
            if (list2 == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (value instanceof JSArrayLiteralExpression) {
            List<JSJsonArrayAdapter> list3 = Collections.singletonList(new JSJsonArrayAdapter((JSArrayLiteralExpression)value));
            if (list3 == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(4);
            }
            return list3;
        }
        if (value instanceof JSLiteralExpression) {
            List<JsonValueAdapter> list4 = Collections.singletonList(new JSJsonGenericValueAdapter(value));
            if (list4 == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(5);
            }
            return list4;
        }
        if (value instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)value).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS) && ((JSPrefixExpression)value).getExpression() instanceof JSLiteralExpression) {
            List<JsonValueAdapter> list5 = Collections.singletonList(new JSJsonGenericValueAdapter(value));
            if (list5 == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(6);
            }
            return list5;
        }
        if (value instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)value).getInnerExpression()) != null) {
            return JSJsonPropertyAdapter.createValueAdaptersByType(innerExpression);
        }
        if (value instanceof JSConditionalExpression) {
            JSExpression then = ((JSConditionalExpression)value).getThen();
            JSExpression anElse = ((JSConditionalExpression)value).getElse();
            List<JsonValueAdapter> thenValues = then == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(then);
            List<JsonValueAdapter> elseValues = anElse == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(anElse);
            List list6 = ContainerUtil.concat(thenValues, elseValues);
            if (list6 == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(7);
            }
            return list6;
        }
        List<JsonValueAdapter> list7 = Collections.singletonList(new JSJsonForeignValueAdapter(value));
        if (list7 == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(8);
        }
        return list7;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueAdaptersByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdaptersByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

