/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0006H\u0000\u001a \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a8\u0006\u0016"}, d2={"getMatchedVersion", "Lcom/intellij/util/text/SemVer;", "toMatch", "availableVersions", "", "version", "", "getSourcePackageName", "typingsName", "getTypingsPackageName", "name", "hasTypingsSpecified", "", "packageName", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAnyGlobalLibAssociatedWithProject", "project", "Lcom/intellij/openapi/project/Project;", "isTypeDefinitionsInstallAvailable", "isTypingsPackage", "parseVersionFromPackageJson", "intellij.javascript.impl"})
@JvmName(name="TypeScriptDefinitionsUtils")
public final class TypeScriptDefinitionsUtils {
    public static final boolean isTypeDefinitionsInstallAvailable(@NotNull String packageName, @NotNull VirtualFile packageJson, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TypeScriptDefinitionsUtils.isTypingsPackage(packageName)) {
            return false;
        }
        if (TypeScriptDefinitionsUtils.hasTypingsSpecified(packageName, packageJson)) {
            return false;
        }
        if (NodeModuleUtil.findNodeModulesByPackageJson(packageJson) == null) {
            return false;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        InstalledPackageVersion installedPackageVersion = finder.findInstalledPackage(packageName);
        if (installedPackageVersion == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)installedPackageVersion, (String)"finder.findInstalledPack\u2026kageName) ?: return false");
        InstalledPackageVersion moduleInfo = installedPackageVersion;
        VirtualFile virtualFile = moduleInfo.getPackageJson();
        if (virtualFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"moduleInfo.packageJson ?: return false");
        VirtualFile modulePackageJson = virtualFile;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(modulePackageJson);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"PackageJsonData.getOrCreate(modulePackageJson)");
        PackageJsonData moduleData = packageJsonData;
        return !moduleData.hasTypings();
    }

    private static final boolean hasTypingsSpecified(String packageName, VirtualFile packageJson) {
        return PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(TypeScriptDefinitionsUtils.getTypingsPackageName(packageName));
    }

    @Nullable
    public static final SemVer parseVersionFromPackageJson(@Nullable String version) {
        String string;
        CharSequence charSequence = version;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (!StringUtil.isDecimalDigit((char)version.charAt(0))) {
            String string2 = version;
            n = 1;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = version;
        }
        String versionStr = string;
        return SemVer.parseFromText((String)versionStr);
    }

    @Nullable
    public static final SemVer getMatchedVersion(@NotNull String version, @NotNull Collection<SemVer> availableVersions) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
        SemVer semVer = TypeScriptDefinitionsUtils.parseVersionFromPackageJson(version);
        if (semVer != null) {
            return TypeScriptDefinitionsUtils.getMatchedVersion(semVer, availableVersions);
        }
        return (SemVer)CollectionsKt.firstOrNull((Iterable)availableVersions);
    }

    @Nullable
    public static final SemVer getMatchedVersion(@Nullable SemVer toMatch, @NotNull Collection<SemVer> availableVersions) {
        Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
        if (toMatch == null) {
            return (SemVer)CollectionsKt.firstOrNull((Iterable)availableVersions);
        }
        SemVer minorMatch = null;
        SemVer majorMatch = null;
        int toMatchMinor = toMatch.getMinor();
        int toMatchMajor = toMatch.getMajor();
        for (SemVer version : availableVersions) {
            if (Intrinsics.areEqual((Object)version, (Object)toMatch)) {
                return version;
            }
            if (toMatchMajor != version.getMajor()) continue;
            if (majorMatch == null) {
                majorMatch = version;
            }
            if (minorMatch != null || toMatchMinor != version.getMinor()) continue;
            minorMatch = version;
        }
        SemVer semVer = minorMatch;
        if (semVer == null) {
            semVer = majorMatch;
        }
        return semVer;
    }

    public static final boolean isAnyGlobalLibAssociatedWithProject(@NotNull Project project, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        JSLibraryManager jSLibraryManager = JSLibraryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryManager), (String)"JSLibraryManager.getInstance(project)");
        JSLibraryManager libraryManager = jSLibraryManager;
        LibraryTable libraryTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryManager.getLibrar\u2026odel.LibraryLevel.GLOBAL)");
        LibraryTable table = libraryTable;
        ScriptingLibraryMappings scriptingLibraryMappings = libraryManager.getLibraryMappings();
        Intrinsics.checkNotNullExpressionValue((Object)scriptingLibraryMappings, (String)"libraryManager.libraryMappings");
        ScriptingLibraryMappings mappings = scriptingLibraryMappings;
        Library library = table.getLibraryByName(packageName);
        return library != null && mappings.isAssociatedWithProject(packageName);
    }

    public static final boolean isTypingsPackage(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)"@types/", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String getTypingsPackageName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TypeScriptDefinitionsUtils.isTypingsPackage(name) ? name : "@types/" + name;
    }

    @NotNull
    public static final String getSourcePackageName(@NotNull String typingsName) {
        Intrinsics.checkNotNullParameter((Object)typingsName, (String)"typingsName");
        return StringsKt.removePrefix((String)typingsName, (CharSequence)"@types/");
    }
}

