/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLinterGuesser
implements DirectoryProjectConfigurator {
    public static final Logger LOG = Logger.getInstance(JSLinterGuesser.class);
    public static final NotificationGroup NOTIFICATION_GROUP = JSLinterUtil.NOTIFICATION_GROUP;

    public boolean isEdtRequired() {
        return false;
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            JSLinterGuesser.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            JSLinterGuesser.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> JSLinterGuesser.guessLinters(project, true)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresReadLock
    public static void guessLinters(@NotNull Project project, boolean bl) {
        Project project2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(3);
        }
        if (project2.isDefault()) {
            return;
        }
        if (Registry.is((String)"javascript.linters.prevent.detection")) {
            LOG.info("Linters detection disabled");
            return;
        }
        LOG.debug("Detecting linters for project");
        List packageJsonFiles = ContainerUtil.map((Collection)FilenameIndex.getVirtualFilesByName((String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project2)), PackageJsonData::getOrCreate);
        for (JSLinterDescriptor descriptor2 : JSLinterDescriptor.EP_NAME.getExtensionList()) {
            void importSettings;
            EnumSet<EnableCase> enableCases = EnumSet.noneOf(EnableCase.class);
            String packageName = descriptor2.packageName();
            if (descriptor2.supportsMultipleRoots() || packageJsonFiles.size() == 1) {
                for (PackageJsonData packageJsonFile : packageJsonFiles) {
                    if (packageJsonFile.getTopLevelProperties().contains(descriptor2.packageJsonSectionName())) {
                        enableCases.add(EnableCase.configSection);
                    }
                    if (packageName == null || !packageJsonFile.isDependencyOfAnyType(packageName)) continue;
                    enableCases.add(EnableCase.dependency);
                }
            }
            if (enableCases.isEmpty() && descriptor2.hasConfigFiles(project2)) {
                enableCases.add(EnableCase.configFile);
            }
            LOG.debug(String.format("For %s linter found %s", descriptor2.getDisplayName(), enableCases.isEmpty() ? "<not found>" : StringUtil.join(enableCases, Enum::name, (String)",")));
            if (enableCases.isEmpty() || !JSLinterGuesser.checkInstalled(project2, project2.getBaseDir(), enableCases, descriptor2) || !descriptor2.enable(project2, packageJsonFiles)) continue;
            EnableCase selectedCase = EnableCase.select(enableCases);
            JSLinterGuesser.doLog(project2, selectedCase, descriptor2);
            if (importSettings == false) continue;
            ApplicationManager.getApplication().invokeLater(() -> descriptor2.importSettings(project2, selectedCase));
        }
    }

    private static boolean checkInstalled(@NotNull Project project, @Nullable VirtualFile contextFile, @NotNull Set<EnableCase> enableCases, @NotNull JSLinterDescriptor descriptor2) {
        String packageName;
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(4);
        }
        if (enableCases == null) {
            JSLinterGuesser.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(6);
        }
        if ((packageName = descriptor2.packageName()) == null) {
            return true;
        }
        if (enableCases.contains((Object)EnableCase.dependency)) {
            return true;
        }
        NodeJsInterpreter interpreter = ApplicationManager.getApplication().isUnitTestMode() ? NodeJsInterpreterManager.getInstance(project).getInterpreter() : NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
        List<NodePackage> available = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, contextFile);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        Iterator<NodePackage> iterator = available.iterator();
        while (iterator.hasNext()) {
            NodePackage nodePackage = iterator.next();
            if (lfs.refreshAndFindFileByPath(nodePackage.getSystemIndependentPath()) != null) continue;
            iterator.remove();
        }
        if (!available.isEmpty()) {
            LOG.info(String.format("For %s %s found, and linter in %s.", descriptor2.getDisplayName(), enableCases.stream().map(Enum::name).collect(Collectors.joining(",\n")), available.get(0).getSystemDependentPath()));
        }
        return !available.isEmpty();
    }

    private static void doLog(final @NotNull Project project, @NotNull EnableCase enableCase, final @NotNull JSLinterDescriptor descriptor2) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(7);
        }
        if (enableCase == null) {
            JSLinterGuesser.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(9);
        }
        String message = enableCase.getMessage(descriptor2);
        JSLinterUtil.NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).addAction((AnAction)new NotificationAction(JavaScriptBundle.message("action.name.disable.category", descriptor2.getDisplayName())){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.info(descriptor2.getDisplayName() + " disabled by user");
                descriptor2.disable(project);
                JSLinterUtil.NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("js.linter.guesser.linter.disabled", descriptor2.getDisplayName()), MessageType.INFO).notify(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
        LOG.info(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCases";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "guessLinters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstalled";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class EnableCase
    extends Enum<EnableCase> {
        public static final /* enum */ EnableCase dependency = new EnableCase("js.linter.guesser.linter.enabled.because.of.dependency", JSLinterDescriptor::packageName);
        public static final /* enum */ EnableCase configSection = new EnableCase("js.linter.guesser.linter.enabled.because.of.package.json.section", JSLinterDescriptor::packageJsonSectionName);
        public static final /* enum */ EnableCase configFile = new EnableCase("js.linter.guesser.linter.enabled.because.of.config.file", null);
        private final String myMessageKey;
        @Nullable
        private final Function<? super JSLinterDescriptor, String> mySecondArgument;
        private static final EnableCase[] ORDER;
        private static final /* synthetic */ EnableCase[] $VALUES;

        public static EnableCase[] values() {
            return (EnableCase[])$VALUES.clone();
        }

        public static EnableCase valueOf(String name) {
            return Enum.valueOf(EnableCase.class, name);
        }

        private EnableCase(String key, Function<? super JSLinterDescriptor, String> argument) {
            if (key == null) {
                EnableCase.$$$reportNull$$$0(0);
            }
            this.myMessageKey = key;
            this.mySecondArgument = argument;
        }

        @NlsContexts.NotificationContent
        public String getMessage(@NotNull JSLinterDescriptor descriptor2) {
            if (descriptor2 == null) {
                EnableCase.$$$reportNull$$$0(1);
            }
            if (this.mySecondArgument == null) {
                return JavaScriptBundle.message(this.myMessageKey, descriptor2.getDisplayName());
            }
            return JavaScriptBundle.message(this.myMessageKey, descriptor2.getDisplayName(), this.mySecondArgument.apply(descriptor2));
        }

        @NotNull
        public static EnableCase select(Set<EnableCase> cases2) {
            assert (!cases2.isEmpty());
            if (cases2.size() == 1) {
                EnableCase enableCase = cases2.iterator().next();
                if (enableCase == null) {
                    EnableCase.$$$reportNull$$$0(2);
                }
                return enableCase;
            }
            for (EnableCase aCase : ORDER) {
                if (!cases2.contains((Object)aCase)) continue;
                EnableCase enableCase = aCase;
                if (enableCase == null) {
                    EnableCase.$$$reportNull$$$0(3);
                }
                return enableCase;
            }
            assert (false);
            EnableCase enableCase = dependency;
            if (enableCase == null) {
                EnableCase.$$$reportNull$$$0(4);
            }
            return enableCase;
        }

        static {
            $VALUES = new EnableCase[]{dependency, configSection, configFile};
            ORDER = new EnableCase[]{configSection, configFile, dependency};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "select";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

