/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintConfigWrapper;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintImportCodeStyleEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"Eslint.Import.Code.Style.Notification");
    private static final String NOTIFICATION_DISMISSED_PROPERTY = "eslint.code.style.apply.dismiss";
    private final Project myProject;

    public EslintImportCodeStyleEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private boolean isNotificationDismissed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(NOTIFICATION_DISMISSED_PROPERTY) || !FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)JsonFileType.INSTANCE) || !EslintUtil.isEslintConfigFile(file2) && !PackageJsonUtil.isPackageJsonFile(file2);
    }

    private void dismissNotification() {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NOTIFICATION_DISMISSED_PROPERTY, true);
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        if (this.isNotificationDismissed(file2)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        if (!psiFile.isWritable() || JSProjectUtil.isInLibrary(psiFile) || JSLibraryUtil.isProbableLibraryFile(file2)) {
            return null;
        }
        EslintConfigWrapper rulesWrapper = EslintConfigWrapper.getForFile(psiFile);
        if (rulesWrapper != null && rulesWrapper.hasDataToImport(project)) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel(EditorColors.GUTTER_BACKGROUND);
            panel2.setText(JavaScriptBundle.message("eslint.code.style.apply.message", new Object[0]));
            panel2.createActionLabel(JavaScriptBundle.message("eslint.code.style.apply.text", new Object[0]), "EslintImportCodeStyle", false);
            panel2.createActionLabel(JavaScriptBundle.message("eslint.code.style.dismiss.text", new Object[0]), () -> this.dismissNotification(), false);
            return panel2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationDismissed";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

