/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagram.JSDiagramColorManager;
import com.intellij.lang.javascript.modules.diagram.JSModuleDependencyData;
import com.intellij.lang.javascript.modules.diagram.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramModel;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModulesDiagramProvider
extends BaseDiagramProvider<JSStructuralDiagramItem> {
    private static final String FIRST_SHOW_KEY = "js.modules.notification.shown";
    public static final String JAVASCRIPT_MODULES_DIAGRAM = "JavaScript-modules-diagram";
    private final VisibilityLevel myOverview = new VisibilityLevel("Overview", JavaScriptBundle.message("visibility.level.overview", new Object[0]));
    private final VisibilityLevel myDetails = new VisibilityLevel("Details", JavaScriptBundle.message("visibility.level.details", new Object[0]));
    private final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        return this.myOverview.equals(o1) ? -1 : 1;
    };
    private final DiagramCategory myAll = new DiagramCategory(DiagramBundle.messagePointer((String)"category.name.all", (Object[])new Object[0]), null);
    private volatile boolean myGotItMessageActive;
    private final DiagramVfsResolver<JSStructuralDiagramItem> myResolver;
    private final DiagramElementManager<JSStructuralDiagramItem> myElementManager;
    private final AbstractUmlVisibilityManager myVisibilityManager;
    private final DiagramNodeContentManager myNodeContentManager = this.createNodeContentManager();

    public JSModulesDiagramProvider() {
        this.myResolver = new DiagramVfsResolver<JSStructuralDiagramItem>(){

            public String getQualifiedName(@Nullable JSStructuralDiagramItem element) {
                if (element == null) {
                    return null;
                }
                if (!element.getUsedExported().isEmpty()) {
                    return StringUtil.join((Collection)ContainerUtil.map(element.getUsedExported(), i2 -> JSModulesDiagramProvider.serializeOneItem(i2)), (String)";") + ";";
                }
                return JSModulesDiagramProvider.serializeOneItem(element);
            }

            @Nullable
            public JSStructuralDiagramItem resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
                if (fqn == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fqn.contains(";")) {
                    String[] strings = fqn.split(";");
                    JSStructuralDiagramItem item = JSModulesDiagramProvider.createProjectItem(project, SmartPointerManager.getInstance((Project)project));
                    if (item == null) {
                        return null;
                    }
                    for (String string : strings) {
                        JSStructuralDiagramItem child = JSModulesDiagramProvider.deserializeOneItem(string, project);
                        if (child == null) {
                            return null;
                        }
                        item.addImportedOrExported(child, true);
                    }
                    return item;
                }
                return JSModulesDiagramProvider.deserializeOneItem(fqn, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fqn";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$1";
                objectArray[2] = "resolveElementByFQN";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myElementManager = new AbstractDiagramElementManager<JSStructuralDiagramItem>(){

            public Object @NotNull [] getNodeItems(JSStructuralDiagramItem parent) {
                Object[] objectArray = ArrayUtil.toObjectArray(parent.getUsedExported());
                if (objectArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Nullable
            public JSStructuralDiagramItem findInDataContext(@NotNull DataContext context) {
                Project project;
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
                    return null;
                }
                VirtualFile[] data = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
                SmartPointerManager spm = SmartPointerManager.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                if (data != null) {
                    List<VirtualFile> files = this.checkFilesTypesAndFilterExcluded(project, data);
                    if (files.isEmpty()) {
                        return null;
                    }
                    if (files.size() == 1) {
                        PsiDirectory psiFile;
                        VirtualFile file2 = files.get(0);
                        Object object = psiFile = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
                        if (psiFile == null) {
                            return null;
                        }
                        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file2.getName(), true);
                    }
                    JSStructuralDiagramItem item = JSModulesDiagramProvider.createProjectItem(project, spm);
                    if (item == null) {
                        return null;
                    }
                    for (VirtualFile file3 : files) {
                        PsiDirectory psiFile;
                        Object object = psiFile = file3.isDirectory() ? psiManager.findDirectory(file3) : psiManager.findFile(file3);
                        if (psiFile == null) continue;
                        item.addImportedOrExported(new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file3.getName(), true), true);
                    }
                    return item;
                }
                PsiElement element = (PsiElement)CommonDataKeys.PSI_FILE.getData(context);
                return element == null ? null : new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)element.getContainingFile()), JSModulesDiagramUtils.getFileNamePart(element.getContainingFile()), true);
            }

            private List<VirtualFile> checkFilesTypesAndFilterExcluded(Project project, VirtualFile @NotNull [] files) {
                if (files == null) {
                    2.$$$reportNull$$$0(2);
                }
                ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project).getFileIndex();
                return ContainerUtil.filter((Object[])files, file2 -> {
                    if (fi.isExcluded(file2)) {
                        return false;
                    }
                    if (file2.isDirectory()) {
                        return true;
                    }
                    FileType type = file2.getFileType();
                    if (type instanceof LanguageFileType) {
                        Language language = ((LanguageFileType)type).getLanguage();
                        return language.isKindOf((Language)HTMLLanguage.INSTANCE) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
                    }
                    return false;
                });
            }

            public boolean isAcceptableAsNode(@Nullable Object element) {
                return element instanceof JSStructuralDiagramItem;
            }

            @Nullable
            public String getElementTitle(JSStructuralDiagramItem element) {
                return JSModulesDiagramProvider.getElementTitleStatic(element);
            }

            @Nullable
            public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
                if (presentation == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (element instanceof JSStructuralDiagramItem) {
                    SimpleTextAttributes attributes = StartupUiUtil.isUnderDarcula() ? new SimpleTextAttributes(0, (Color)JBColor.black) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    return new SimpleColoredText(JSModulesDiagramProvider.getElementTitleStatic((JSStructuralDiagramItem)element), attributes);
                }
                return null;
            }

            @Nullable
            public SimpleColoredText getItemType(@Nullable Object element) {
                if (element instanceof JSStructuralDiagramItem && ((JSStructuralDiagramItem)element).getParent() != null) {
                    boolean isExported = ((JSStructuralDiagramItem)element).getParent().isExported((JSStructuralDiagramItem)element);
                    SimpleColoredText text = new SimpleColoredText(){
                        private Icon myIcon;

                        public void setIcon(@Nullable Icon icon2) {
                            this.myIcon = icon2;
                        }

                        public void appendToComponent(@NotNull ColoredTextContainer component) {
                            if (component == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.appendToComponent(component);
                            if (this.myIcon != null) {
                                component.setIcon(this.myIcon);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$2$1", "appendToComponent"));
                        }
                    };
                    if (isExported) {
                        text.setIcon(AllIcons.ToolbarDecorator.Export);
                    } else {
                        text.setIcon(AllIcons.ToolbarDecorator.Import);
                    }
                    return text;
                }
                return super.getItemType(element);
            }

            @Nullable
            public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
                if (presentation == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (element instanceof JSStructuralDiagramItem) {
                    JSStructuralDiagramItem item = (JSStructuralDiagramItem)element;
                    if (item.getIcon() != null) {
                        return item.getIcon();
                    }
                    return JSStructuralUiNode.calculateIcon(item);
                }
                return super.getItemIcon(element, presentation);
            }

            @Nullable
            @Nls
            public String getNodeTooltip(JSStructuralDiagramItem element) {
                return JSModulesDiagramUtils.getJSStructuralItemTooltip(element);
            }

            @Nullable
            public String getEditorTitle(JSStructuralDiagramItem element, @NotNull DiagramState presentation, @NotNull Collection<JSStructuralDiagramItem> additionalElements) {
                if (presentation == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (additionalElements == null) {
                    2.$$$reportNull$$$0(6);
                }
                return this.getElementTitle(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodeItems";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "findInDataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "checkFilesTypesAndFilterExcluded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemIcon";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getEditorTitle";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myVisibilityManager = new AbstractUmlVisibilityManager(){

            public VisibilityLevel @NotNull [] getVisibilityLevels() {
                VisibilityLevel[] visibilityLevelArray = new VisibilityLevel[]{JSModulesDiagramProvider.this.myOverview, JSModulesDiagramProvider.this.myDetails};
                if (visibilityLevelArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return visibilityLevelArray;
            }

            @Nullable
            public VisibilityLevel getVisibilityLevel(@Nullable Object element) {
                if (element instanceof JSStructuralDiagramItem && !((JSStructuralDiagramItem)element).isFile()) {
                    return JSModulesDiagramProvider.this.myDetails;
                }
                return JSModulesDiagramProvider.this.myOverview;
            }

            @NotNull
            public Comparator<VisibilityLevel> getComparator() {
                Comparator<VisibilityLevel> comparator = JSModulesDiagramProvider.this.COMPARATOR;
                if (comparator == null) {
                    3.$$$reportNull$$$0(1);
                }
                return comparator;
            }

            public boolean isRelayoutNeeded() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibilityLevels";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComparator";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    private static JSStructuralDiagramItem createProjectItem(Project project, SmartPointerManager spm) {
        VirtualFile baseDir = project.getBaseDir();
        PsiDirectory projectPsiFile = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (projectPsiFile == null) {
            return null;
        }
        SmartPsiElementPointer pointer = spm.createSmartPsiElementPointer((PsiElement)projectPsiFile);
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)pointer, JavaScriptBundle.message("modules.selected", new Object[0]), false);
    }

    @Nullable
    private static JSStructuralDiagramItem deserializeOneItem(@NlsSafe String fqn, Project project) {
        int offset;
        PsiDirectory psiFile;
        if (StringUtil.isEmptyOrSpaces((String)fqn)) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (!fqn.contains("#")) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(fqn);
            if (file2 != null) {
                PsiDirectory psiFile2;
                Object object = psiFile2 = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
                if (psiFile2 == null) {
                    return null;
                }
                String name = psiFile2 instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile2) : file2.getName();
                return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile2), name, true);
            }
            return new JSStructuralDiagramItem(null, fqn, true);
        }
        String[] strings = fqn.split("#");
        if (strings.length != 1 && strings.length != 3) {
            return null;
        }
        VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(strings[0]);
        if (file3 == null) {
            return null;
        }
        Object object = psiFile = file3.isDirectory() ? psiManager.findDirectory(file3) : psiManager.findFile(file3);
        if (psiFile == null) {
            return null;
        }
        if (strings.length == 1) {
            String name = psiFile instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile) : file3.getName();
            return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile), name, true);
        }
        String name = strings[1];
        try {
            offset = Integer.parseInt(strings[2]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null || !element.isValid()) {
            return null;
        }
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element), name, false);
    }

    @NotNull
    private static String serializeOneItem(JSStructuralDiagramItem element) {
        if (element.getElementPointer() == null) {
            String string = element.getName();
            if (string == null) {
                JSModulesDiagramProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement == null) {
            return "";
        }
        String path2 = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getVirtualFile().getPath() : psiElement.getContainingFile().getVirtualFile().getPath();
        StringBuilder sb = new StringBuilder(path2);
        if (!(psiElement instanceof PsiFileSystemItem) && !element.isFile()) {
            if (psiElement.getTextRange() == null) {
                String string = path2;
                if (string == null) {
                    JSModulesDiagramProvider.$$$reportNull$$$0(1);
                }
                return string;
            }
            sb.append("#").append(element.getName()).append("#").append(String.format("%d", psiElement.getTextRange().getStartOffset()));
        }
        String string = sb.toString();
        if (string == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return JAVASCRIPT_MODULES_DIAGRAM;
    }

    @NotNull
    public DiagramVisibilityManager createVisibilityManager() {
        AbstractUmlVisibilityManager abstractUmlVisibilityManager = this.myVisibilityManager;
        if (abstractUmlVisibilityManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(3);
        }
        return abstractUmlVisibilityManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = this.myNodeContentManager;
        if (diagramNodeContentManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramNodeContentManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new AbstractDiagramNodeContentManager(){
            {
                this.setCategoryEnabled(JSModulesDiagramProvider.this.myAll, true);
            }

            public boolean isInCategory(@Nullable Object element, @NotNull DiagramCategory category) {
                if (category == null) {
                    4.$$$reportNull$$$0(0);
                }
                return true;
            }

            public DiagramCategory @NotNull [] getContentCategories() {
                DiagramCategory[] diagramCategoryArray = new DiagramCategory[]{JSModulesDiagramProvider.this.myAll};
                if (diagramCategoryArray == null) {
                    4.$$$reportNull$$$0(1);
                }
                return diagramCategoryArray;
            }

            public boolean isEditCategoriesSettings() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentCategories";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isInCategory";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(5);
        }
        if (graph == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(6);
        }
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){

            public boolean allowChangeVisibleCategories() {
                return false;
            }

            public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
                if (view == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (editMode == null) {
                    5.$$$reportNull$$$0(1);
                }
                super.customizeSettings(view, editMode);
                DiagramBuilder builder = this.getBuilder();
                Objects.requireNonNull(builder.getDataModel().getNodeContentManager()).setCategoryEnabled(JSModulesDiagramProvider.this.myAll, true);
                JComponent component = builder.getView().getJComponent();
                if (!PropertiesComponent.getInstance().isTrueValue(JSModulesDiagramProvider.FIRST_SHOW_KEY)) {
                    this.showGotItMessage(component, JavaScriptBundle.message("javascript.module.dependencies.got.it.text", new Object[0]));
                } else if (this.getBuilder().getDataModel().getNodes().size() == 0) {
                    this.showGotItMessage(component, JavaScriptBundle.message("javascript.module.dependencies.empty.got.it.text", new Object[0]));
                }
            }

            private void showGotItMessage(JComponent component, @NlsContexts.PopupContent String message) {
                UiNotifyConnector.doWhenFirstShown((JComponent)component, () -> {
                    if (JSModulesDiagramProvider.this.myGotItMessageActive) {
                        return;
                    }
                    JSModulesDiagramProvider.this.myGotItMessageActive = true;
                    GotItMessage.createMessage((String)JavaScriptBundle.message("javascript.module.dependencies.got.it.title", new Object[0]), (String)message).setCallback(() -> {
                        JSModulesDiagramProvider.this.myGotItMessageActive = false;
                        PropertiesComponent.getInstance().setValue(JSModulesDiagramProvider.FIRST_SHOW_KEY, true);
                    }).setDisposable((Disposable)this.getBuilder()).show(RelativePoint.getSouthEastOf((JComponent)component), Balloon.Position.below);
                });
            }

            @NotNull
            protected DefaultUmlRenderer createRenderer() {
                return new DefaultUmlRenderer(this.getBuilder(), this.getModificationTrackerOfViewUpdates()){

                    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                        Border border = JBUI.Borders.customLine((Color)Gray._190);
                        DiagramNode object = this.getBuilder().getNodeObject(realizer.getNode());
                        if (object instanceof JSStructuralUiNode) {
                            JSStructuralDiagramItem element = ((JSStructuralUiNode)object).getIdentifyingElement();
                            if (element.isInScope()) {
                                PsiFile file2;
                                PsiFile psiFile = file2 = element.getElementPointer() != null ? element.getElementPointer().getContainingFile() : null;
                                if (file2 != null && !JSLibraryUtil.isProbableLibraryFile(file2.getVirtualFile())) {
                                    border = JBUI.Borders.customLine((Color)JBColor.black);
                                }
                            } else if (element.getElementPointer() == null && !JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                                border = JBUI.Borders.customLine((Color)JBColor.red);
                            }
                        }
                        wrapper.setBorder(border);
                        if (wrapper.getParent() instanceof JComponent) {
                            ((JComponent)wrapper.getParent()).setBorder((Border)JBUI.Borders.empty());
                        }
                        super.tuneNode(realizer, wrapper);
                    }
                };
            }

            @Nullable
            public String getNodeTooltip(@Nullable DiagramNode node) {
                return node.getTooltip();
            }

            @Nullable
            public String getEdgeTooltip(DiagramEdge edge) {
                if (edge instanceof JSStructuralUiEdge) {
                    return ((JSStructuralUiEdge)edge).getTooltip();
                }
                return super.getEdgeTooltip(edge);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "view";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editMode";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$5";
                objectArray[2] = "customizeSettings";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public DiagramColorManager getColorManager() {
        JSDiagramColorManager jSDiagramColorManager = JSDiagramColorManager.INSTANCE;
        if (jSDiagramColorManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(7);
        }
        return jSDiagramColorManager;
    }

    @NotNull
    public DiagramElementManager<JSStructuralDiagramItem> getElementManager() {
        DiagramElementManager<JSStructuralDiagramItem> diagramElementManager = this.myElementManager;
        if (diagramElementManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(8);
        }
        return diagramElementManager;
    }

    @NotNull
    public DiagramVfsResolver<JSStructuralDiagramItem> getVfsResolver() {
        DiagramVfsResolver<JSStructuralDiagramItem> diagramVfsResolver = this.myResolver;
        if (diagramVfsResolver == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(9);
        }
        return diagramVfsResolver;
    }

    @NotNull
    public String getPresentableName() {
        String string = JavaScriptBundle.message("js.module.uml.presentable.name", new Object[0]);
        if (string == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public DiagramExtras<JSStructuralDiagramItem> getExtras() {
        return new DiagramExtras<JSStructuralDiagramItem>(){

            @NotNull
            public List<AnAction> getExtraActions() {
                List<AnAction> list2 = Collections.singletonList(new MyEditSourceAction());
                if (list2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Nullable
            public Object getData(@NotNull String dataId, List<DiagramNode<JSStructuralDiagramItem>> list2, DiagramBuilder builder) {
                if (dataId == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && list2.size() == 1) {
                    SmartPsiElementPointer<PsiElement> target = ((JSStructuralDiagramItem)list2.get(0).getIdentifyingElement()).getElementPointer();
                    if (target != null) {
                        return target.getElement();
                    }
                } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && list2.size() == 1) {
                    final JSStructuralDiagramItem element = (JSStructuralDiagramItem)list2.get(0).getIdentifyingElement();
                    if (element.getElementPointer() == null && JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                        return new Navigatable[]{new Navigatable(){

                            public void navigate(boolean requestFocus) {
                                BrowserUtil.open((String)element.getName());
                            }

                            public boolean canNavigate() {
                                return true;
                            }

                            public boolean canNavigateToSource() {
                                return true;
                            }
                        }};
                    }
                } else if (JSModulesDiagramUtils.DIAGRAM_BUILDER.is(dataId)) {
                    return builder;
                }
                return super.getData(dataId, list2, builder);
            }

            @NotNull
            public JComponent createNodeComponent(@NotNull DiagramNode<JSStructuralDiagramItem> node, @NotNull DiagramBuilder builder, @NotNull Point basePoint, @NotNull JPanel wrapper) {
                if (node == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (builder == null) {
                    6.$$$reportNull$$$0(3);
                }
                if (basePoint == null) {
                    6.$$$reportNull$$$0(4);
                }
                if (wrapper == null) {
                    6.$$$reportNull$$$0(5);
                }
                DiagramNodeContainer container = new DiagramNodeContainer(node, builder, basePoint);
                if (!((JSStructuralDiagramItem)node.getIdentifyingElement()).getUsedExported().isEmpty()) {
                    container.getHeader().setBorder(JBUI.Borders.customLine((Color)Gray._190, (int)0, (int)0, (int)1, (int)0));
                }
                container.setForcedBackground((Color)JBColor.WHITE);
                DiagramNodeContainer diagramNodeContainer = container;
                if (diagramNodeContainer == null) {
                    6.$$$reportNull$$$0(6);
                }
                return diagramNodeContainer;
            }

            @NotNull
            public Layouter getCustomLayouter(GraphSettings settings, Project project) {
                SmartOrganicLayouter layouter = GraphLayoutService.getInstance().getOrganicLayouter();
                layouter.setNodeEdgeOverlapAvoided(true);
                layouter.setDeterministic(true);
                SmartOrganicLayouter smartOrganicLayouter = layouter;
                if (smartOrganicLayouter == null) {
                    6.$$$reportNull$$$0(7);
                }
                return smartOrganicLayouter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$6";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "basePoint";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExtraActions";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$6";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNodeComponent";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomLayouter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createNodeComponent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public DiagramDataModel<JSStructuralDiagramItem> createDataModel(@NotNull Project project, @Nullable JSStructuralDiagramItem element, @Nullable VirtualFile file2, @NotNull DiagramPresentationModel presentationModel) {
        GlobalSearchScope scope;
        if (project == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(11);
        }
        if (presentationModel == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(12);
        }
        if (element != null && !element.getUsedExported().isEmpty()) {
            GlobalSearchScope current = GlobalSearchScope.EMPTY_SCOPE;
            for (JSStructuralDiagramItem item : element.getUsedExported()) {
                PsiElement child;
                if (item.getElementPointer() == null || !((child = item.getElementPointer().getElement()) instanceof PsiFileSystemItem)) continue;
                if (child instanceof PsiDirectory) {
                    current = current.union((SearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)((PsiDirectory)child), (boolean)true));
                    continue;
                }
                if (!(child instanceof PsiFile)) continue;
                current = current.union((SearchScope)GlobalSearchScope.fileScope((PsiFile)((PsiFile)child)));
            }
            scope = current;
        } else if (element != null && element.getElementPointer() != null) {
            PsiElement psiElement = element.getElementPointer().getElement();
            if (psiElement instanceof PsiFileSystemItem) {
                scope = psiElement instanceof PsiDirectory ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)((PsiDirectory)psiElement).getVirtualFile(), (boolean)true) : (psiElement instanceof PsiFile ? GlobalSearchScope.fileScope((PsiFile)((PsiFile)psiElement)) : GlobalSearchScope.projectScope((Project)project));
            } else {
                PsiFile psiFile = element.getElementPointer().getContainingFile();
                if (psiFile == null) {
                    if (null == null) {
                        JSModulesDiagramProvider.$$$reportNull$$$0(13);
                    }
                    return null;
                }
                scope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)psiFile.getVirtualFile());
            }
        } else {
            scope = GlobalSearchScope.projectScope((Project)project);
        }
        JSModuleDependencyData data = new JSModuleDependencyData(project, scope);
        data.calculate();
        Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> nodesAndEdges = data.getNodesAndEdges(this);
        return new JSStructuralDiagramModel(project, this, (List)nodesAndEdges.getFirst(), (List)nodesAndEdges.getSecond());
    }

    @NlsContexts.Label
    public static String getElementTitleStatic(JSStructuralDiagramItem element) {
        if (element != null) {
            return JSModulesDiagramProvider.getElementNamePart(element);
        }
        return "";
    }

    @NlsContexts.Label
    private static String getElementNamePart(JSStructuralDiagramItem element) {
        if (element.getElementPointer() != null) {
            if (element.getElementPointer().getElement() instanceof PsiFile) {
                if (JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                    return JSModulesDiagramProvider.onlyName(element);
                }
                return JSModulesDiagramUtils.getFileNamePart((PsiFile)element.getElementPointer().getElement());
            }
            if (element.getElementPointer().getElement() instanceof PsiDirectory) {
                return element.getName();
            }
            if (element.getElementPointer() == null) {
                return JSModulesDiagramProvider.onlyName(element);
            }
        } else if (element.getElementPointer() == null) {
            return JSModulesDiagramProvider.onlyName(element);
        }
        return element.getName();
    }

    @Nls
    private static String onlyName(JSStructuralDiagramItem element) {
        String[] split = element.getName().replace("\\", "/").split("/");
        return split.length == 0 ? element.getName() : split[split.length - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeOneItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibilityManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditSourceAction
    extends AnAction {
        MyEditSourceAction() {
            super(JavaScriptBundle.message("action.jump.to.text", new Object[0]), JavaScriptBundle.message("action.jump.to.text", new Object[0]), AllIcons.Actions.EditSource);
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                MyEditSourceAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            List<DiagramNode<?>> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            e.getPresentation().setEnabled(nodes != null && nodes.size() == 1 && nodes.get(0) instanceof JSStructuralUiNode);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditSourceAction.$$$reportNull$$$0(1);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            List<DiagramNode<?>> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            if (project == null || nodes == null || nodes.size() != 1 || !(nodes.get(0) instanceof JSStructuralUiNode)) {
                return;
            }
            JSStructuralDiagramItem main = (JSStructuralDiagramItem)nodes.get(0).getIdentifyingElement();
            List<JSStructuralDiagramItem> exported = main.getUsedExported();
            if (exported.isEmpty()) {
                return;
            }
            JSModulesDiagramUtils.showMembersSelectionPopup(StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(main)), main.getElementPointer(), JSStructuralUiNode.calculateIcon(main), ContainerUtil.map(exported, el -> Trinity.create((Object)StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(el)), el.getElementPointer(), (Object)JSStructuralUiNode.calculateIcon(el))), e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$MyEditSourceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

