/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAddRequireExecutor
implements JSAddImportExecutor {
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myPlaceFile;

    public JSAddRequireExecutor(@Nullable Editor editor, @NotNull PsiElement place) {
        if (place == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class});
        this.myPlaceFile = scope != null ? scope : place;
    }

    @Override
    public void createImports(@NotNull JSImportCandidate importCandidate) {
        JSImportDescriptor descriptor2;
        if (importCandidate == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(1);
        }
        if ((descriptor2 = importCandidate.getSingleDescriptorOrNull()) == null) {
            return;
        }
        this.createImportOrUseExisting(descriptor2);
    }

    @Override
    public boolean createImportOrUseExisting(@NotNull JSImportDescriptor descriptor2) {
        if (descriptor2 == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(2);
        }
        if (descriptor2.getImportType().isSpecifier() && JSCodeStyleSettings.isMergeImports(this.myPlaceFile) && this.addToExistingRequire(descriptor2)) {
            return true;
        }
        String text = this.getImportStatementText(descriptor2);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myPlaceFile.getProject()).createFileFromText("dummy.js", (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
        PsiElement created = dummyFile.getFirstChild();
        if (created == null) {
            return false;
        }
        PsiElement last = new LastImportRequireInScope(false).findAndSelect(this.myPlaceFile);
        Pair anchor = last != null ? Pair.create((Object)true, (Object)last) : ES6ImportPsiUtil.findPlaceForImport(this.myPlaceFile);
        ES6CreateImportUtil.insertPsiElementToScope(created, this.myPlaceFile, (Pair<Boolean, PsiElement>)anchor, this.myEditor);
        if (last instanceof PsiComment) {
            this.myPlaceFile.addAfter(JSChangeUtil.createNewLine(last), last);
        }
        return true;
    }

    private boolean addToExistingRequire(JSImportDescriptor descriptor2) {
        PsiElement[] topChildren;
        for (PsiElement topChild : topChildren = this.myPlaceFile.getChildren()) {
            JSInitializerOwner[] declarations;
            if (!(topChild instanceof JSVarStatement)) continue;
            for (JSInitializerOwner declaration : declarations = ((JSVarStatement)topChild).getDeclarations()) {
                String modulePath;
                if (!(declaration instanceof JSDestructuringElement)) continue;
                JSDestructuringContainer target = ((JSDestructuringElement)declaration).getTarget();
                JSExpression initializer = declaration.getInitializer();
                if (!(target instanceof JSDestructuringObject) || !(initializer instanceof JSCallExpression) || (modulePath = CommonJSUtil.getRequireCallModulePath((JSCallExpression)initializer)) == null || !modulePath.equals(descriptor2.getModuleName())) continue;
                WriteCommandAction.writeCommandAction((Project)this.myPlaceFile.getProject(), (PsiFile[])new PsiFile[]{this.myPlaceFile.getContainingFile()}).withName(JavaScriptBundle.message("add.variable.to.require", new Object[0])).run(() -> ES6ChangeUtil.addDestructuringProperty((JSDestructuringObject)target, descriptor2.getEffectiveName()));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<JSImportDescriptor> createDescriptors(@NotNull String importedName, @NotNull JSElement elementToImport, @NotNull JSImportPlaceInfo.ImportContext importContext) {
        if (importedName == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(3);
        }
        if (elementToImport == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(4);
        }
        if (importContext == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(5);
        }
        return new ES6AddImportExecutor(this.getEditor(), this.getPlace()).createDescriptors(importedName, elementToImport, importContext);
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.myPlaceFile;
        if (psiElement == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @Nullable
    public JSImportExportType getImportType(@NotNull PsiElement candidate) {
        if (candidate == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(7);
        }
        return ES6AddImportExecutor.getImportType(candidate, this.getPlace());
    }

    @Override
    @NotNull
    public String getImportStatementText(@NotNull JSImportDescriptor descriptor2) {
        if (descriptor2 == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(8);
        }
        return JSAddRequireExecutor.getRequireCallText(this.myPlaceFile, descriptor2);
    }

    @NotNull
    public static String getRequireCallText(@Nullable PsiElement place, @NotNull JSImportDescriptor descriptor2) {
        String semicolon;
        if (descriptor2 == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(9);
        }
        String varName = descriptor2.getImportedName();
        boolean isConst = DialectDetector.hasFeature(place, JSLanguageFeature.CONST_DEFINITIONS);
        JSImportExportType importType = descriptor2.getImportType();
        boolean isFileImport = !importType.isSpecifier();
        boolean isDestructuring = isConst && !isFileImport;
        String prefix = isConst ? "const " : "var ";
        String quote = place == null ? "\"" : JSCodeStyleSettings.getQuote(place);
        String call = "require(" + quote + descriptor2.getModuleName() + quote + ")";
        String string = semicolon = place == null ? "" : JSCodeStyleSettings.getSemicolon(place);
        if (isDestructuring) {
            String spaces = JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_OBJECT_LITERAL_BRACES ? " " : "";
            String propertyName = descriptor2.getExportedName() != null && !descriptor2.getExportedName().equals(varName) ? descriptor2.getExportedName() + " : " : "";
            String string2 = prefix + "{" + spaces + propertyName + varName + spaces + "} = " + call + semicolon;
            if (string2 == null) {
                JSAddRequireExecutor.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String postfix = isFileImport ? "" : "." + descriptor2.getExportedName();
        String string3 = prefix + varName + " = " + call + postfix + semicolon;
        if (string3 == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(11);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCandidate";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSAddRequireExecutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSAddRequireExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createImports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrUseExisting";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatementText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

