/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.imports.CommonJSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSFullImportRenderer;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportElementFilter;
import com.intellij.lang.javascript.modules.imports.JSImportPopup;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSImportAction
implements QuestionAction {
    public static final Key<Boolean> NO_HINT_KEY = Key.create((String)"ES6.auto.import.no.hint");
    @TestOnly
    public static final Key<String> NAME_TO_IMPORT = Key.create((String)"name.for.import");
    @TestOnly
    public static final Key<Set<String>> EXPECTED_NAMES_TO_IMPORT = Key.create((String)"expected.names.for.import");
    private static final String[] EXCLUDED_DIRS = new String[]{"/cjs", "/src", "/esm", "/umd"};
    private static final Comparator<JSImportCandidate> COMPARE_CANDIDATES = Comparator.comparing(el -> -el.getPriority()).thenComparing(el -> {
        JSImportDescriptor descriptor2 = el.getSingleDescriptorOrNull();
        return descriptor2 == null ? 0 : descriptor2.getModuleName().length();
    });
    @Nullable
    protected final Editor myEditor;
    @NotNull
    protected final String myName;
    @NotNull
    protected final JSImportPlaceInfo myPlaceInfo;
    protected final JSImportElementFilter myFilter;

    public JSImportAction(@Nullable Editor editor, @NotNull String name, @NotNull JSImportPlaceInfo placeInfo, @NotNull JSImportElementFilter filter) {
        if (name == null) {
            JSImportAction.$$$reportNull$$$0(0);
        }
        if (placeInfo == null) {
            JSImportAction.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            JSImportAction.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.myName = name;
        this.myPlaceInfo = placeInfo;
        this.myFilter = filter;
    }

    public JSImportAction(@Nullable Editor editor, @NotNull PsiElement context, @NonNls @NotNull String name, @NotNull JSImportElementFilter filter) {
        if (context == null) {
            JSImportAction.$$$reportNull$$$0(3);
        }
        if (name == null) {
            JSImportAction.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            JSImportAction.$$$reportNull$$$0(5);
        }
        this(editor, name, new JSImportPlaceInfo(context), filter);
    }

    @NotNull
    protected PsiElement getContext() {
        PsiElement psiElement = this.myPlaceInfo.getPlace();
        if (psiElement == null) {
            JSImportAction.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public boolean execute() {
        this.executeForAllVariants();
        return true;
    }

    public void executeForAllVariants() {
        this.executeForAllVariants(null);
    }

    public void executeForAllVariants(@Nullable Consumer<? super JSImportCandidate> postProcess) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement context = this.getContext();
        if (!context.isValid()) {
            return;
        }
        Project project = context.getProject();
        Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
            List newCandidates = (List)ReadAction.compute(() -> {
                if (project.isDisposed() || !project.isOpen() || !context.isValid()) {
                    return ContainerUtil.emptyList();
                }
                if (!this.isValidPlace()) {
                    return Collections.emptyList();
                }
                List<? extends JSImportCandidate> candidates = this.getRawCandidates();
                return this.filterAndSort(candidates);
            });
            if (newCandidates.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.executeForSingleOrShowPopup(project, postProcess, newCandidates);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.executeForSingleOrShowPopup(project, postProcess, newCandidates), ModalityState.NON_MODAL, project.getDisposed());
            }
        };
        this.setNoHintFlag(true);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            calcModuleNamesAndShowPopupIfNecessary.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
        }
    }

    public void executeForSingleOrShowPopup(Project project, @Nullable Consumer<? super JSImportCandidate> postProcess, List<? extends JSImportCandidate> newCandidates) {
        this.setNoHintFlag(false);
        PsiElement context = this.getContext();
        if (newCandidates.isEmpty() || !context.isValid()) {
            return;
        }
        if (!this.shouldShowPopup(newCandidates)) {
            JSImportCandidate item = (JSImportCandidate)ContainerUtil.getFirstItem(newCandidates);
            assert (item != null);
            Runnable runnable = () -> this.executeFor(item, postProcess);
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getName(), (Object)this);
            return;
        }
        this.chooseElement(newCandidates, postProcess);
    }

    protected boolean shouldShowPopup(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(7);
        }
        return candidates.size() > 1;
    }

    private void setNoHintFlag(boolean value) {
        PsiElement context = this.getContext();
        if (!context.isValid()) {
            return;
        }
        PsiElement toSet = context;
        if (context.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            context.putUserData(NO_HINT_KEY, (Object)value);
            PsiElement parent = context.getParent();
            toSet = parent == null ? toSet : parent;
        }
        toSet.putUserData(NO_HINT_KEY, (Object)value);
    }

    public final void executeWithoutPrepare(@NotNull JSImportCandidate candidate) {
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(8);
        }
        this.runAction(this.myEditor, candidate, this.getContext());
    }

    public final void executeFor(@NotNull JSImportCandidate candidate, @Nullable Consumer<? super JSImportCandidate> postProcess) {
        PsiElement context;
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(9);
        }
        if (!(context = this.getContext()).isValid()) {
            return;
        }
        Project project = context.getProject();
        FileHeaderKeeper keeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(this.getContext()));
        this.executeWithoutPrepare(candidate);
        if (postProcess != null || keeper.canMove()) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
                if (postProcess != null) {
                    postProcess.consume((Object)candidate);
                }
                if (keeper.canMove()) {
                    if (this.myEditor != null && !this.myEditor.isDisposed()) {
                        Document document2 = this.myEditor.getDocument();
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                    }
                    keeper.moveHeader();
                }
            }));
        }
    }

    @NotNull
    public List<? extends JSImportCandidate> getFilteredCandidates() {
        List<? extends JSImportCandidate> list2 = this.filterAndSort(this.getRawCandidates());
        if (list2 == null) {
            JSImportAction.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<? extends JSImportCandidate> getRawCandidates() {
        List<? extends JSImportCandidate> list2 = this.myFilter.filterCandidates(this.getContext(), JSImportCandidatesProvider.getCandidatesFromProviders(this.myPlaceInfo, this.myName));
        if (list2 == null) {
            JSImportAction.$$$reportNull$$$0(11);
        }
        return list2;
    }

    protected void runAction(@Nullable Editor editor, @NotNull JSImportCandidate candidate, @NotNull PsiElement place) {
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(12);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(13);
        }
        JSImportAction.createImports(editor, candidate, place);
    }

    public static void createImports(@Nullable Editor editor, @NotNull JSImportCandidate candidate, @NotNull PsiElement place) {
        PsiFile containingFile;
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(14);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(15);
        }
        if ((containingFile = place.getContainingFile()) instanceof JSExpressionCodeFragment) {
            JSElement element = candidate.getElement();
            if (element != null) {
                ((JSExpressionCodeFragment)containingFile).importElement(element);
            }
        } else {
            candidate.createExecutor(editor, place).createImports(candidate);
        }
    }

    @NotNull
    protected List<? extends JSImportCandidate> filterAndSort(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(16);
        }
        if (candidates.isEmpty()) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(17);
            }
            return list2;
        }
        HashMap<JSImportCandidate, JSModuleNameInfo> renderedTexts = new HashMap<JSImportCandidate, JSModuleNameInfo>();
        candidates = this.fillModuleNamesAndFilterByBlacklist(renderedTexts, candidates);
        if ((candidates = this.removeForPredefinedLibraries(candidates)).size() <= 1) {
            List<? extends JSImportCandidate> list3 = candidates;
            if (list3 == null) {
                JSImportAction.$$$reportNull$$$0(18);
            }
            return list3;
        }
        Collection<? extends JSImportCandidate> elementsFromLibraries = this.getElementsFromLibraries(candidates);
        candidates = JSImportAction.removeMergedElements(candidates, elementsFromLibraries);
        candidates = this.deduplicateByImportText(candidates);
        Map<JSImportCandidate, JSModuleNameInfo> libraryExternalModules = JSImportAction.createLibraryModulesInfos(candidates, renderedTexts);
        candidates = JSImportAction.removeSimilarModules(candidates, renderedTexts);
        candidates = JSImportAction.removeNestedLibraryModules(candidates, libraryExternalModules);
        candidates = JSImportAction.deduplicateByElements(candidates);
        ArrayList<? extends JSImportCandidate> toSort = new ArrayList<JSImportCandidate>(JSImportAction.removeSrcAndMinifiedLibraryFiles(candidates, libraryExternalModules));
        ContainerUtil.sort(toSort, Comparator.comparing(el -> {
            JSModuleNameInfo info = (JSModuleNameInfo)renderedTexts.get(el);
            return info == null ? Integer.MAX_VALUE : info.getModuleName().length();
        }));
        ArrayList<? extends JSImportCandidate> arrayList = toSort;
        if (arrayList == null) {
            JSImportAction.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private List<? extends JSImportCandidate> removeForPredefinedLibraries(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(20);
        }
        Set<VirtualFile> predefinedLibraries = JsModulesSuggester.getPredefinedLibraries(this.getContext());
        List list2 = ((StreamEx)StreamEx.of(candidates).filter(el -> {
            VirtualFile file2 = el.getElementFile();
            return file2 == null || !predefinedLibraries.contains(file2);
        })).toList();
        if (list2 == null) {
            JSImportAction.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private List<? extends JSImportCandidate> deduplicateByImportText(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(22);
        }
        if (candidates.size() <= 1) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(23);
            }
            return list2;
        }
        HashSet visited = new HashSet();
        List list3 = ContainerUtil.filter(candidates, el -> {
            JSImportDescriptor single = el.getSingleDescriptorOrNull();
            if (single == null) {
                return true;
            }
            String text = JSImportAction.getImportStatementText(el, single, this.getContext());
            return visited.add(text);
        });
        if (list3 == null) {
            JSImportAction.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NlsSafe
    @NotNull
    public static String getImportStatementText(@NotNull JSImportCandidate importCandidate, @NotNull JSImportDescriptor importDescriptor, @NotNull PsiElement place) {
        if (importCandidate == null) {
            JSImportAction.$$$reportNull$$$0(25);
        }
        if (importDescriptor == null) {
            JSImportAction.$$$reportNull$$$0(26);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(27);
        }
        String string = importCandidate.createExecutor(null, place).getImportStatementText(importDescriptor);
        if (string == null) {
            JSImportAction.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static List<? extends JSImportCandidate> deduplicateByElements(List<? extends JSImportCandidate> candidates) {
        if (candidates.size() <= 1) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(29);
            }
            return list2;
        }
        HashMap<Pair, JSImportCandidate> map = new HashMap<Pair, JSImportCandidate>();
        HashSet<JSImportCandidate> toRemove = new HashSet<JSImportCandidate>();
        for (JSImportCandidate jSImportCandidate : candidates) {
            JSImportDescriptor descriptor2;
            JSElement element = jSImportCandidate.getElement();
            if (element == null || (descriptor2 = jSImportCandidate.getSingleDescriptorOrNull()) == null) continue;
            String newModuleName = descriptor2.getModuleName();
            boolean isRelative = newModuleName.startsWith(".");
            Pair key = Pair.create((Object)element, (Object)Trinity.create((Object)descriptor2.getImportType(), (Object)isRelative, (Object)(jSImportCandidate instanceof CommonJSImportCandidate)));
            JSImportCandidate oldCandidate = (JSImportCandidate)map.get(key);
            if (oldCandidate == null) {
                map.put(key, jSImportCandidate);
                continue;
            }
            if (COMPARE_CANDIDATES.compare(oldCandidate, jSImportCandidate) <= 0) {
                toRemove.add(jSImportCandidate);
                continue;
            }
            map.put(key, jSImportCandidate);
            toRemove.add(oldCandidate);
        }
        List list3 = ContainerUtil.filter(candidates, el -> !toRemove.contains(el));
        if (list3 == null) {
            JSImportAction.$$$reportNull$$$0(30);
        }
        return list3;
    }

    @NotNull
    protected static Map<JSImportCandidate, JSModuleNameInfo> createLibraryModulesInfos(@NotNull Collection<? extends JSImportCandidate> elementsFromLibraries, @NotNull Map<JSImportCandidate, JSModuleNameInfo> renderedTexts) {
        if (elementsFromLibraries == null) {
            JSImportAction.$$$reportNull$$$0(31);
        }
        if (renderedTexts == null) {
            JSImportAction.$$$reportNull$$$0(32);
        }
        HashMap<JSImportCandidate, JSModuleNameInfo> result2 = new HashMap<JSImportCandidate, JSModuleNameInfo>();
        elementsFromLibraries.forEach(el -> {
            JSModuleNameInfo info = (JSModuleNameInfo)renderedTexts.get(el);
            if (info != null) {
                result2.put((JSImportCandidate)el, info);
            }
        });
        HashMap<JSImportCandidate, JSModuleNameInfo> hashMap = result2;
        if (hashMap == null) {
            JSImportAction.$$$reportNull$$$0(33);
        }
        return hashMap;
    }

    private void chooseElement(@NotNull List<? extends JSImportCandidate> candidates, @Nullable Consumer<? super JSImportCandidate> postProcess) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(34);
        }
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final PsiElement place = this.getContext();
        Project project = place.getProject();
        Processor<JSImportCandidate> processor = this.createModuleProcessor(project, postProcess);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Set actualNames;
            Set expectedNamesToImport = (Set)this.myEditor.getUserData(EXPECTED_NAMES_TO_IMPORT);
            if (expectedNamesToImport != null && !(actualNames = ContainerUtil.map2Set(candidates, this::getDebugNameForElement)).equals(expectedNamesToImport)) {
                String expected = expectedNamesToImport.stream().sorted().collect(Collectors.joining(","));
                String actual = actualNames.stream().sorted().collect(Collectors.joining(","));
                throw new AssertionError((Object)("Unexpected import candidates. \nExpected: " + expected + "\nActual: " + actual));
            }
            String nameToImport = (String)this.myEditor.getUserData(NAME_TO_IMPORT);
            processor.process((Object)Optional.ofNullable(nameToImport).map(name -> (JSImportCandidate)ContainerUtil.find((Iterable)candidates, candidate -> this.getDebugNameForElement((JSImportCandidate)candidate).equals(name))).orElseThrow(() -> new AssertionError((Object)("Import name must be specified for multiple candidates.\nName to import: " + nameToImport + "\nAvailable names: " + StreamEx.of((Collection)candidates).map(candidate -> this.getDebugNameForElement((JSImportCandidate)candidate)).joining((CharSequence)",")))));
            return;
        }
        JSImportPopup.createPopup(project, new JSImportPopup.RendererFactory(){
            final Map<JSImportCandidate, ListCellRenderer<Object>> renderers = new HashMap<JSImportCandidate, ListCellRenderer<Object>>();

            @Override
            @NotNull
            public ListCellRenderer<Object> create(@NotNull JSImportCandidate candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                ListCellRenderer listCellRenderer = this.renderers.computeIfAbsent(candidate, el -> JSImportAction.this.createRenderer(candidate, place));
                if (listCellRenderer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return listCellRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "candidate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, candidates, this.getModuleSelectionPopupTitle(), processor).showInBestPositionFor(this.myEditor);
    }

    @NotNull
    protected String getDebugNameForElement(@NotNull JSImportCandidate element) {
        if (element == null) {
            JSImportAction.$$$reportNull$$$0(35);
        }
        ES6QualifiedNamedElementRenderer<JSElement> renderer = this.createRenderer(element, this.getContext());
        JSElement psiElement = element.getElement();
        String string = psiElement == null ? element.getName() : (renderer instanceof JSFullImportRenderer ? renderer.getElementText(psiElement) : StringUtil.notNullize((String)renderer.getContainerText(psiElement, renderer.getElementText(psiElement))));
        if (string == null) {
            JSImportAction.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NlsContexts.PopupTitle
    protected String getModuleSelectionPopupTitle() {
        return JavaScriptBundle.message("choose.class.to.import.title", new Object[0]);
    }

    @NotNull
    @NlsContexts.Command
    public String getName() {
        String string = JavaScriptBundle.message("command.name.import", this.myName);
        if (string == null) {
            JSImportAction.$$$reportNull$$$0(37);
        }
        return string;
    }

    protected boolean isValidPlace() {
        return JSImportAction.isValidImportPlace(this.getContext());
    }

    @NotNull
    private Processor<JSImportCandidate> createModuleProcessor(final @NotNull Project project, final @Nullable Consumer<? super JSImportCandidate> postProcess) {
        if (project == null) {
            JSImportAction.$$$reportNull$$$0(38);
        }
        return new Processor<JSImportCandidate>(){

            public boolean process(@NotNull JSImportCandidate element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().executeCommand(project, () -> JSImportAction.this.executeFor(element, (Consumer<? super JSImportCandidate>)postProcess), JSImportAction.this.getName(), (Object)this);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/imports/JSImportAction$2", "process"));
            }
        };
    }

    @NotNull
    public ES6QualifiedNamedElementRenderer<JSElement> createRenderer(final @NotNull JSImportCandidate candidate, @NotNull PsiElement place) {
        JSImportDescriptor descriptor2;
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(39);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(40);
        }
        if ((descriptor2 = candidate.getSingleDescriptorOrNull()) != null) {
            return new JSFullImportRenderer(candidate, descriptor2, place);
        }
        return new ES6QualifiedNamedElementRenderer<JSElement>(){

            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                renderer.setIcon(PlatformIcons.IMPORT_ICON);
                renderer.append(candidate.getName(), new SimpleTextAttributes(0, list2.getForeground()));
                return true;
            }

            @Override
            public String getContainerText(JSElement element, String name) {
                return "(" + candidate.getContainerText() + ")";
            }
        };
    }

    protected List<? extends JSImportCandidate> fillModuleNamesAndFilterByBlacklist(@NotNull Map<JSImportCandidate, JSModuleNameInfo> renderedText, @NotNull Collection<? extends JSImportCandidate> candidates) {
        if (renderedText == null) {
            JSImportAction.$$$reportNull$$$0(41);
        }
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String[] excludedNames = JSCodeStyleSettings.getSettings(this.myPlaceInfo.getPlace()).getBlacklistImports();
        Ref ref = Ref.create();
        JSImportDescriptorProcessor processor = JSImportPathBuilder.createSearchProcessor((Ref<? super JSImportDescriptor>)ref, excludedNames);
        ArrayList<JSImportCandidate> filtered = new ArrayList<JSImportCandidate>();
        for (JSImportCandidate jSImportCandidate : candidates) {
            ref.set(null);
            List<JSImportDescriptor> descriptors = jSImportCandidate.getDescriptors();
            JSImportDescriptor descriptor2 = (JSImportDescriptor)ContainerUtil.getFirstItem(descriptors);
            if (descriptor2 == null) continue;
            JSModuleDescriptor moduleDescriptor = descriptor2.getModuleDescriptor();
            if (processor.processDescriptor(descriptor2)) continue;
            filtered.add(jSImportCandidate);
            if (!(moduleDescriptor instanceof JSModuleNameInfo)) continue;
            renderedText.put(jSImportCandidate, (JSModuleNameInfo)moduleDescriptor);
        }
        return filtered;
    }

    @NotNull
    protected Collection<? extends JSImportCandidate> getElementsFromLibraries(@NotNull Collection<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(43);
        }
        List list2 = ContainerUtil.filter(candidates, el -> {
            JSElement element = el.getElement();
            if (element == null) {
                return false;
            }
            PsiFile file2 = element.getContainingFile();
            if (!(file2 instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)file2).isCommonJSModule()) {
                return false;
            }
            VirtualFile fileToSearch = file2.getVirtualFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
            if (virtualFile == null) {
                return false;
            }
            Pair<VirtualFile, VirtualFile> parentLibraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(this.myPlaceInfo.getProject(), fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
            return parentLibraryDirectory != null;
        });
        if (list2 == null) {
            JSImportAction.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @NotNull
    protected static List<? extends JSImportCandidate> removeMergedElements(@NotNull List<? extends JSImportCandidate> candidates, @NotNull Collection<? extends JSImportCandidate> elementsFromLibraries) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(45);
        }
        if (elementsFromLibraries == null) {
            JSImportAction.$$$reportNull$$$0(46);
        }
        HashSet<String> qNames = new HashSet<String>();
        HashSet<JSImportCandidate> toRemove = new HashSet<JSImportCandidate>();
        for (JSImportCandidate jSImportCandidate : candidates) {
            PsiElement module;
            String qName;
            JSElement element;
            if (elementsFromLibraries.contains(jSImportCandidate) || (element = jSImportCandidate.getElement()) == null || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(element))) || (module = ES6PsiUtil.findExternalModule((PsiElement)element)) != null || qNames.add(qName)) continue;
            toRemove.add(jSImportCandidate);
        }
        if (toRemove.isEmpty()) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(47);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter(candidates, el -> !toRemove.contains(el));
        if (list3 == null) {
            JSImportAction.$$$reportNull$$$0(48);
        }
        return list3;
    }

    @NotNull
    private static List<? extends JSImportCandidate> removeSimilarModules(@NotNull List<? extends JSImportCandidate> candidates, @NotNull Map<JSImportCandidate, ? extends JSModuleDescriptor> externalModules) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(49);
        }
        if (externalModules == null) {
            JSImportAction.$$$reportNull$$$0(50);
        }
        if (externalModules.isEmpty() || candidates.size() <= 1) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(51);
            }
            return list2;
        }
        HashSet<JSImportCandidate> toRemove = new HashSet<JSImportCandidate>(JSImportAction.getDtsDuplicates(candidates));
        HashSet uniqueModuleNamesForSymbols = new HashSet();
        HashSet uniqueModuleNamesForCommonJS = new HashSet();
        HashSet uniqueModuleNamesForModules = new HashSet();
        candidates.forEach(candidate -> {
            JSModuleDescriptor moduleInfo = (JSModuleDescriptor)externalModules.get(candidate);
            if (moduleInfo == null) {
                return;
            }
            JSElement elementToImport = candidate.getElement();
            if (elementToImport == null) {
                return;
            }
            if (toRemove.contains(elementToImport)) {
                return;
            }
            String pathText = moduleInfo.getModuleName();
            if (!StringUtil.isEmpty((String)pathText)) {
                if (elementToImport instanceof TypeScriptModule) {
                    if (!uniqueModuleNamesForModules.add(pathText)) {
                        toRemove.add((JSImportCandidate)candidate);
                    }
                } else {
                    if (JSImportAction.isFromInternalModule((PsiElement)elementToImport)) {
                        return;
                    }
                    if (!(candidate instanceof CommonJSImportCandidate ? uniqueModuleNamesForCommonJS : uniqueModuleNamesForSymbols).add(pathText)) {
                        toRemove.add((JSImportCandidate)candidate);
                    }
                }
            }
        });
        List list3 = ((StreamEx)StreamEx.of(candidates).filter(el -> !toRemove.contains(el))).toList();
        if (list3 == null) {
            JSImportAction.$$$reportNull$$$0(52);
        }
        return list3;
    }

    @NotNull
    private static Set<JSImportCandidate> getDtsDuplicates(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(53);
        }
        HashSet<String> uniqueTsFiles = new HashSet<String>();
        MultiMap elementsFromDts = MultiMap.create();
        for (JSImportCandidate jSImportCandidate : candidates) {
            String path2;
            String extension;
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)jSImportCandidate.getElement());
            if (file2 == null || (extension = JSFileReference.findImplicitExtension(path2 = file2.getPath())) == null) continue;
            String pathWithoutExtension = path2.substring(0, path2.length() - extension.length());
            if (ArrayUtil.contains((String)extension, (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS)) {
                uniqueTsFiles.add(pathWithoutExtension);
                continue;
            }
            if (!".d.ts".equals(extension)) continue;
            elementsFromDts.putValue((Object)pathWithoutExtension, (Object)jSImportCandidate);
        }
        if (elementsFromDts.isEmpty() || uniqueTsFiles.isEmpty()) {
            Set<JSImportCandidate> set = Collections.emptySet();
            if (set == null) {
                JSImportAction.$$$reportNull$$$0(54);
            }
            return set;
        }
        HashSet<JSImportCandidate> toRemove = new HashSet<JSImportCandidate>();
        for (Map.Entry entry : elementsFromDts.entrySet()) {
            if (!uniqueTsFiles.contains(entry.getKey())) continue;
            toRemove.addAll((Collection)entry.getValue());
        }
        HashSet<JSImportCandidate> hashSet = toRemove;
        if (hashSet == null) {
            JSImportAction.$$$reportNull$$$0(55);
        }
        return hashSet;
    }

    public static boolean isFromInternalModule(PsiElement elementToImport) {
        JSElement scope = ES6PsiUtil.getExportScope(elementToImport);
        return scope instanceof TypeScriptModule && ((TypeScriptModule)scope).isInternal();
    }

    @NotNull
    private static List<? extends JSImportCandidate> removeNestedLibraryModules(@NotNull List<? extends JSImportCandidate> candidates, @NotNull Map<JSImportCandidate, JSModuleNameInfo> libraryExternalModules) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(56);
        }
        if (libraryExternalModules == null) {
            JSImportAction.$$$reportNull$$$0(57);
        }
        if (candidates.size() <= 1) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(58);
            }
            return list2;
        }
        List rootPackages = ((StreamEx)StreamEx.of(libraryExternalModules.values()).map(el -> el.getModuleFileOrDirectory()).filter(el -> el.findChild("package.json") != null)).toList();
        if (rootPackages.isEmpty()) {
            List<? extends JSImportCandidate> list3 = candidates;
            if (list3 == null) {
                JSImportAction.$$$reportNull$$$0(59);
            }
            return list3;
        }
        List list4 = ((StreamEx)StreamEx.of(candidates).filter(el -> {
            JSModuleNameInfo moduleInfo = (JSModuleNameInfo)libraryExternalModules.get(el);
            if (moduleInfo == null) {
                return true;
            }
            VirtualFile moduleFileOrDirectory = moduleInfo.getModuleFileOrDirectory();
            if (!moduleFileOrDirectory.isDirectory()) {
                return true;
            }
            return rootPackages.stream().noneMatch(root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)moduleFileOrDirectory, (boolean)true));
        })).toList();
        if (list4 == null) {
            JSImportAction.$$$reportNull$$$0(60);
        }
        return list4;
    }

    @NotNull
    protected static List<? extends JSImportCandidate> removeSrcAndMinifiedLibraryFiles(@NotNull List<? extends JSImportCandidate> candidates, @NotNull Map<JSImportCandidate, ? extends JSModuleDescriptor> libraryExternalModules) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(61);
        }
        if (libraryExternalModules == null) {
            JSImportAction.$$$reportNull$$$0(62);
        }
        if (candidates.size() <= 1) {
            List<? extends JSImportCandidate> list2 = candidates;
            if (list2 == null) {
                JSImportAction.$$$reportNull$$$0(63);
            }
            return list2;
        }
        List<? extends JSImportCandidate> newCandidates = ContainerUtil.filter(candidates, el -> {
            JSModuleDescriptor info = (JSModuleDescriptor)libraryExternalModules.get(el);
            if (info == null) {
                return true;
            }
            String path2 = info.getModuleName();
            if (path2.endsWith(".min")) {
                return false;
            }
            for (String dir : EXCLUDED_DIRS) {
                if (!path2.endsWith(dir) && !path2.contains(dir + "/")) continue;
                return false;
            }
            return true;
        });
        List<? extends JSImportCandidate> list3 = newCandidates.size() > 0 ? newCandidates : candidates;
        if (list3 == null) {
            JSImportAction.$$$reportNull$$$0(64);
        }
        return list3;
    }

    public static boolean isValidImportPlace(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        if (JSImportAction.isJSXContextPlace(context)) {
            JSXmlLiteralExpression expression = (JSXmlLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSXmlLiteralExpression.class, (boolean)false);
            if (expression != null) {
                PsiPolyVariantReference topLevelReference = JSXResolveUtil.getTopLevelReference(expression);
                if (topLevelReference == null) {
                    return false;
                }
                return JSStubBasedPsiTreeUtil.resolveReferenceLocally(topLevelReference, topLevelReference.getCanonicalText()) == null;
            }
            return true;
        }
        return !(context instanceof JSReferenceExpression) || JSImportAction.checkReferenceExpressionAcceptable((JSReferenceExpression)context);
    }

    public static boolean isJSXContextPlace(@NotNull PsiElement context) {
        if (context == null) {
            JSImportAction.$$$reportNull$$$0(65);
        }
        return context instanceof JSXmlLiteralExpression || ObjectUtils.doIfNotNull((Object)context.getNode(), ASTNode::getElementType) == JSTokenTypes.XML_TAG_NAME;
    }

    private static boolean checkReferenceExpressionAcceptable(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSImportAction.$$$reportNull$$$0(66);
        }
        if (!referenceExpression.isValid() || referenceExpression.getQualifier() != null) {
            return false;
        }
        String name = referenceExpression.getReferenceName();
        return JSStubBasedPsiTreeUtil.resolveReferenceLocally(referenceExpression, name) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportAction";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 53: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 13: 
            case 15: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCandidate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDescriptor";
                break;
            }
            case 31: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsFromLibraries";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedTexts";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedText";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModules";
                break;
            }
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryExternalModules";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCandidates";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndSort";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removeForPredefinedLibraries";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateByImportText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatementText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateByElements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryModulesInfos";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugNameForElement";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromLibraries";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMergedElements";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSimilarModules";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getDtsDuplicates";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNestedLibraryModules";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSrcAndMinifiedLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutPrepare";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeFor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createImports";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterAndSort";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeForPredefinedLibraries";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateByImportText";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatementText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryModulesInfos";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDebugNameForElement";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createModuleProcessor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fillModuleNamesAndFilterByBlacklist";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getElementsFromLibraries";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeMergedElements";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "removeSimilarModules";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDtsDuplicates";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedLibraryModules";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeSrcAndMinifiedLibraryFiles";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isJSXContextPlace";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

