/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;

public final class JSParsingContextUtil {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    static final boolean IS_TOP_LEVEL_ASYNC = SystemProperties.getBooleanProperty((String)"idea.js.top.level.async", (boolean)true);

    static void fillBuilderData(@NotNull PsiElement context, PsiBuilder builder, DialectOptionHolder dialect, FunctionParser functionParser) {
        if (context == null) {
            JSParsingContextUtil.$$$reportNull$$$0(0);
        }
        builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)dialect);
        JSFunction parent = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSFunction.class});
        builder.putUserData(ASYNC_METHOD_KEY, (Object)(parent != null ? parent.isAsync() : IS_TOP_LEVEL_ASYNC));
        functionParser.setIsGenerator(parent != null && parent.isGenerator());
    }

    static boolean isAsyncContext(PsiBuilder builder) {
        Boolean asyncValue = (Boolean)builder.getUserData(ASYNC_METHOD_KEY);
        if (asyncValue == null) {
            return IS_TOP_LEVEL_ASYNC;
        }
        return asyncValue;
    }

    static boolean isGeneratorContext(PsiBuilder builder, DialectOptionHolder dialect) {
        if (Boolean.TRUE.equals(builder.getUserData(IS_GENERATOR_FUNCTION_KEY))) {
            return true;
        }
        return dialect != null && dialect.hasFeature(JSLanguageFeature.ALWAYS_GENERATOR_CONTEXT);
    }

    public static void setIsGenerator(boolean isGenerator, PsiBuilder builder) {
        builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/parsing/JSParsingContextUtil", "fillBuilderData"));
    }
}

