/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSTagEmbeddedContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSControlFlowService
implements Disposable {
    public static final JSControlFlow EMPTY = new JSControlFlow((ControlFlow)new ControlFlowImpl(Instruction.EMPTY_ARRAY));
    private static final Logger LOGGER = Logger.getInstance(JSControlFlowService.class);
    @NotNull
    private final AtomicReference<ConcurrentMap<JSElement, JSControlFlow>> myControlFlows = new AtomicReference<ConcurrentMap>(ContainerUtil.createConcurrentWeakKeySoftValueMap());

    @NotNull
    public static JSControlFlowService getService(@NotNull Project project) {
        JSControlFlowService service;
        if (project == null) {
            JSControlFlowService.$$$reportNull$$$0(0);
        }
        JSControlFlowService jSControlFlowService = (service = (JSControlFlowService)project.getService(JSControlFlowService.class)) == null ? new JSControlFlowService(true) : service;
        if (jSControlFlowService == null) {
            JSControlFlowService.$$$reportNull$$$0(1);
        }
        return jSControlFlowService;
    }

    public JSControlFlowService() {
        this(false);
    }

    private JSControlFlowService(boolean isDummy) {
        if (!isDummy) {
            LowMemoryWatcher.register(this::dispose, (Disposable)this);
        }
    }

    @NotNull
    public JSControlFlow getControlFlow(@NotNull JSElement scope) {
        if (scope == null) {
            JSControlFlowService.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (scope instanceof JSEmbeddedContent && !(scope instanceof JSTagEmbeddedContent)) {
            JSControlFlow jSControlFlow = EMPTY;
            if (jSControlFlow == null) {
                JSControlFlowService.$$$reportNull$$$0(3);
            }
            return jSControlFlow;
        }
        ConcurrentMap<JSElement, JSControlFlow> map = this.myControlFlows.get();
        JSControlFlow flow = (JSControlFlow)map.get(scope);
        if (flow != null) {
            JSControlFlow jSControlFlow = flow;
            if (jSControlFlow == null) {
                JSControlFlowService.$$$reportNull$$$0(4);
            }
            return jSControlFlow;
        }
        try {
            flow = new JSControlFlow(JSDialectSpecificHandlersFactory.forElement((PsiElement)scope).getControlFlow(scope));
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOGGER.error(e.getMessage(), (Throwable)e, new String[]{scope.getText()});
            flow = EMPTY;
        }
        map.putIfAbsent(scope, flow);
        JSControlFlow jSControlFlow = flow;
        if (jSControlFlow == null) {
            JSControlFlowService.$$$reportNull$$$0(5);
        }
        return jSControlFlow;
    }

    public void resetFlow(@NotNull JSElement scope) {
        if (scope == null) {
            JSControlFlowService.$$$reportNull$$$0(6);
        }
        ConcurrentMap<JSElement, JSControlFlow> map = this.myControlFlows.get();
        map.remove(scope);
    }

    public void dispose() {
        ConcurrentMap<JSElement, JSControlFlow> flowMap = this.myControlFlows.get();
        this.myControlFlows.compareAndSet(flowMap, ContainerUtil.createConcurrentWeakKeySoftValueMap());
    }

    public static boolean isControlFlowScope(@NotNull PsiElement currentElement) {
        if (currentElement == null) {
            JSControlFlowService.$$$reportNull$$$0(7);
        }
        return currentElement instanceof JSExecutionScope;
    }

    @NotNull
    private static IntSet getCFUnreachableInstructions(@NotNull ControlFlow flow) {
        Instruction[] instructions;
        if (flow == null) {
            JSControlFlowService.$$$reportNull$$$0(8);
        }
        if ((instructions = flow.getInstructions()).length <= 2) {
            return new IntOpenHashSet();
        }
        IntOpenHashSet reachable = new IntOpenHashSet();
        ControlFlowUtil.iterate((int)0, (Instruction[])instructions, arg_0 -> JSControlFlowService.lambda$getCFUnreachableInstructions$0((IntSet)reachable, arg_0), (boolean)false);
        if (reachable.size() == instructions.length) {
            return new IntOpenHashSet();
        }
        IntOpenHashSet unreachable = new IntOpenHashSet();
        for (int i2 = 0; i2 < instructions.length; ++i2) {
            if (reachable.contains(i2)) continue;
            unreachable.add(i2);
        }
        IntOpenHashSet intOpenHashSet = unreachable;
        if (intOpenHashSet == null) {
            JSControlFlowService.$$$reportNull$$$0(9);
        }
        return intOpenHashSet;
    }

    @Nullable
    public static Instruction getInstruction(@NotNull JSElement element) {
        JSExecutionScope scope;
        if (element == null) {
            JSControlFlowService.$$$reportNull$$$0(10);
        }
        if ((scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class)) == null) {
            return null;
        }
        JSControlFlow controlFlow = JSControlFlowService.getService(scope.getProject()).getControlFlow(scope);
        for (Instruction instruction : controlFlow.getInstructions()) {
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    private static /* synthetic */ ControlFlowUtil.Operation lambda$getCFUnreachableInstructions$0(IntSet reachable, Instruction instruction) {
        reachable.add(instruction.num());
        return ControlFlowUtil.Operation.NEXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCFUnreachableInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetFlow";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isControlFlowScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCFUnreachableInstructions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSControlFlow
    implements ControlFlow {
        @NotNull
        private final ControlFlow myFlow;
        private final NotNullLazyValue<IntSet> myUnreachable;

        public JSControlFlow(@NotNull ControlFlow flow) {
            if (flow == null) {
                JSControlFlow.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.myUnreachable = NotNullLazyValue.atomicLazy(() -> JSControlFlowService.getCFUnreachableInstructions(this.myFlow));
        }

        public Instruction @NotNull [] getInstructions() {
            Instruction[] instructionArray = this.myFlow.getInstructions();
            if (instructionArray == null) {
                JSControlFlow.$$$reportNull$$$0(1);
            }
            return instructionArray;
        }

        public boolean isCFUnreachable(@NotNull Instruction instruction) {
            if (instruction == null) {
                JSControlFlow.$$$reportNull$$$0(2);
            }
            return ((IntSet)this.myUnreachable.getValue()).contains(instruction.num());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService$JSControlFlow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService$JSControlFlow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCFUnreachable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

