/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSIncludeDirectiveStub;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class JSIncludeDirectiveImpl
extends JSStubbedStatementImpl<JSIncludeDirectiveStub>
implements JSIncludeDirective {
    public JSIncludeDirectiveImpl(ASTNode node) {
        super(node);
    }

    public JSIncludeDirectiveImpl(JSIncludeDirectiveStub stub) {
        super(stub, ActionScriptElementTypes.INCLUDE_DIRECTIVE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSIncludeDirectiveImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSIncludeDirective(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiReference @NotNull [] getReferences() {
        ASTNode node = this.getIncludedFileNode();
        if (node != null) {
            PsiElement psi = node.getPsi();
            FileReference[] fileReferenceArray = new FileReferenceSet(StringUtil.stripQuotesAroundValue((String)node.getText()), (PsiElement)this, psi.getStartOffsetInParent() + 1, null, this.isCaseSensitive()).getAllReferences();
            if (fileReferenceArray == null) {
                JSIncludeDirectiveImpl.$$$reportNull$$$0(1);
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JSIncludeDirectiveImpl.$$$reportNull$$$0(2);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private boolean isCaseSensitive() {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this);
        return virtualFile == null ? SystemInfo.isFileSystemCaseSensitive : virtualFile.isCaseSensitive();
    }

    private ASTNode getIncludedFileNode() {
        ASTNode node = this.getNode().findChildByType(JSTokenTypes.STRING_LITERAL);
        if (node == null) {
            this.getNode().findChildByType(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL);
        }
        return node;
    }

    @Override
    public String getIncludeText() {
        JSIncludeDirectiveStub stub = (JSIncludeDirectiveStub)this.getGreenStub();
        if (stub != null) {
            return stub.getIncludeText();
        }
        ASTNode astNode = this.getIncludedFileNode();
        return astNode != null ? StringUtil.stripQuotesAroundValue((String)astNode.getText()) : null;
    }

    @Override
    public PsiFile resolveFile() {
        PsiFileSystemItem element;
        String includeText = this.getIncludeText();
        if (includeText == null) {
            return null;
        }
        FileReference[] references = new FileReferenceSet(includeText, (PsiElement)this, 0, null, this.isCaseSensitive()).getAllReferences();
        if (references != null && references.length > 0 && (element = references[references.length - 1].resolve()) instanceof PsiFile) {
            return (PsiFile)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSIncludeDirectiveImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSIncludeDirectiveImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

