/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSEvaluableTypeResolver {
    @NotNull
    public static final JSEvaluableTypeResolver FOR_CACHING = new JSEvaluableTypeResolver(false, false);
    @NotNull
    private static final JSEvaluableTypeResolver PASS_PROPERTY_OWNER_TYPES = new JSEvaluableTypeResolver(true, true);
    @NotNull
    private static final JSEvaluableTypeResolver SKIP_PROPERTY_OWNER_TYPES = new JSEvaluableTypeResolver(true, false);
    private final boolean myUnwrapPropertyOwnerTypes;
    private final boolean myPassUnwrappedPropertyOwnerTypes;

    private JSEvaluableTypeResolver(boolean unwrapPropertyOwnerTypes, boolean passUnwrappedPropertyOwnerTypes) {
        this.myUnwrapPropertyOwnerTypes = unwrapPropertyOwnerTypes;
        this.myPassUnwrappedPropertyOwnerTypes = passUnwrappedPropertyOwnerTypes;
    }

    @NotNull
    public static JSEvaluableTypeResolver complete(boolean passPropertiesOwnerTypes) {
        JSEvaluableTypeResolver jSEvaluableTypeResolver = passPropertiesOwnerTypes ? PASS_PROPERTY_OWNER_TYPES : SKIP_PROPERTY_OWNER_TYPES;
        if (jSEvaluableTypeResolver == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(0);
        }
        return jSEvaluableTypeResolver;
    }

    @NotNull
    public JSTypeEvaluationResult unwrapRecursively(@NotNull JSEvaluableOnlyType type, boolean isAdditionalType, @NotNull JSEvaluateContext context) {
        Object element;
        if (type == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(2);
        }
        if (type instanceof JSTypeOfPsiElementBase && context.isAstAccessAllowed((PsiElement)(element = ((JSTypeOfPsiElementBase)type).getElement())) && ((JSTypeOfPsiElementBase)type).matchesSourceElement() && !DialectDetector.isActionScript(element)) {
            JSTypeEvaluationResult cachedResult;
            boolean evaluatedAsExpression = element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element);
            JSEvaluateContext contextForCached = context.withCombinedStrictness(type.isSourceStrict());
            if (!evaluatedAsExpression) {
                contextForCached = contextForCached.withSource((PsiElement)element);
            }
            if ((cachedResult = JSEvaluationCache.getElementType(element, contextForCached)) == null) {
                cachedResult = new JSTypeEvaluationResult();
            }
            JSTypeEvaluationResult result2 = new JSTypeEvaluationResult();
            for (JSEvaluationResultElement resultElement : cachedResult.getResults()) {
                JSType resultElementType = resultElement.getTypeOrAdditionalType();
                if (resultElementType instanceof JSEvaluableOnlyType) {
                    JSTypeEvaluationResult newResult = this.doUnwrapRecursively((JSEvaluableOnlyType)resultElementType, resultElement.isAdditionalType() || isAdditionalType, resultElement.getEvaluateContext());
                    for (JSEvaluationResultElement newResultElement : newResult.getResults()) {
                        result2.addResultElement(newResultElement);
                    }
                    continue;
                }
                if (isAdditionalType && !resultElement.isAdditionalType()) {
                    resultElement = new JSEvaluationResultElement(resultElementType, true, resultElement.getEvaluateContext());
                }
                result2.addResultElement(resultElement);
            }
            JSTypeEvaluationResult jSTypeEvaluationResult = result2;
            if (jSTypeEvaluationResult == null) {
                JSEvaluableTypeResolver.$$$reportNull$$$0(3);
            }
            return jSTypeEvaluationResult;
        }
        JSTypeEvaluationResult jSTypeEvaluationResult = this.doUnwrapRecursively(type, isAdditionalType, context);
        if (jSTypeEvaluationResult == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(4);
        }
        return jSTypeEvaluationResult;
    }

    @NotNull
    public JSTypeEvaluationResult doUnwrapRecursively(@NotNull JSEvaluableOnlyType type, boolean isAdditionalType, @NotNull JSEvaluateContext context) {
        JSTypeEvaluationResultProcessor processor;
        if (type == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(6);
        }
        if (type instanceof JSPropertiesOwnerType && !this.myUnwrapPropertyOwnerTypes) {
            JSTypeEvaluationResult result2 = new JSTypeEvaluationResult();
            result2.addResultElement(new JSEvaluationResultElement(type, isAdditionalType, context));
            JSTypeEvaluationResult jSTypeEvaluationResult = result2;
            if (jSTypeEvaluationResult == null) {
                JSEvaluableTypeResolver.$$$reportNull$$$0(7);
            }
            return jSTypeEvaluationResult;
        }
        JSEvaluationTask evaluatedOnce = (JSEvaluationTask)JSEvaluationRecursionGuard.compute(type, context, () -> type.evaluate(context));
        if (evaluatedOnce == null) {
            evaluatedOnce = JSEvaluationTasks.EMPTY;
        }
        JSEvaluationTask evaluatedCompletely = evaluatedOnce.transform(element -> {
            JSType typeOrAdditionalType = element.getTypeOrAdditionalType();
            if (typeOrAdditionalType instanceof JSEvaluableOnlyType) {
                JSEvaluateContext elementContext = element.getEvaluateContext();
                JSTypeEvaluationResult unwrapped = (JSTypeEvaluationResult)JSEvaluationRecursionGuard.compute(typeOrAdditionalType, elementContext, () -> this.unwrapRecursively((JSEvaluableOnlyType)typeOrAdditionalType, element.isAdditionalType(), elementContext));
                return JSEvaluationTasks.fromList(unwrapped != null ? Collections.unmodifiableList(unwrapped.getResults()) : Collections.emptyList());
            }
            return element;
        });
        JSTypeEvaluationResultProcessor jSTypeEvaluationResultProcessor = processor = isAdditionalType ? new JSAdditionalTypeEvaluationResultProcessor() : new JSTypeEvaluationResultProcessor();
        if (type instanceof JSPropertiesOwnerType && this.myPassUnwrappedPropertyOwnerTypes) {
            processor.process(type, context);
        }
        evaluatedCompletely.applyWithContext(processor, context);
        JSTypeEvaluationResult jSTypeEvaluationResult = processor.getResult();
        if (jSTypeEvaluationResult == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(8);
        }
        return jSTypeEvaluationResult;
    }

    public boolean willPassPropertiesOwnerTypes() {
        return !this.myUnwrapPropertyOwnerTypes || this.myPassUnwrappedPropertyOwnerTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "complete";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapRecursively";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnwrapRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapRecursively";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrapRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSAdditionalTypeEvaluationResultProcessor
    extends JSTypeEvaluationResultProcessor {
        private JSAdditionalTypeEvaluationResultProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
            if (type == null) {
                JSAdditionalTypeEvaluationResultProcessor.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                JSAdditionalTypeEvaluationResultProcessor.$$$reportNull$$$0(1);
            }
            this.processAdditionalType(type, evaluateContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluateContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver$JSAdditionalTypeEvaluationResultProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

