/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSinkResolveStatus;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveResultSink
extends ResultSink {
    private static final Logger LOG = Logger.getInstance(ResolveResultSink.class);
    private final String myName;
    private List<JSSinkResolveStatus> myResolveStatus;
    private final boolean myAcceptAllResults;
    private final boolean myIncomplete;
    @Nullable
    private Set<PsiElement> myCandidateResults;

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(0);
        }
        this(place, name, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(1);
        }
        this(place, name, acceptAllResults, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults, boolean incomplete) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(2);
        }
        super(place);
        this.myName = name;
        this.myAcceptAllResults = acceptAllResults;
        this.myIncomplete = incomplete;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiElement getResult() {
        PsiElement completeResult = this.getCompleteResult();
        if (completeResult != null) {
            return completeResult;
        }
        return (PsiElement)ContainerUtil.getFirstItem((List)this.myResults);
    }

    @Nullable
    public PsiElement getCompleteResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i2 = 0; i2 < this.myResults.size(); ++i2) {
            if (!this.myResolveStatus.get((int)i2).myIsComplete) continue;
            return (PsiElement)this.myResults.get(i2);
        }
        return null;
    }

    @Nullable
    public JSResolveResult getCandidateResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i2 = 0; i2 < this.myResults.size(); ++i2) {
            if (this.myResolveStatus.get((int)i2).myIsComplete) continue;
            return new JSResolveResult((PsiElement)this.myResults.get(i2), null, this.myResolveStatus.get(i2).getResolveProblem());
        }
        return null;
    }

    @Override
    public List<PsiElement> getResults() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        boolean hasCandidateResult = false;
        boolean hasCompleteResult = false;
        for (int i2 = 0; i2 < this.myResults.size(); ++i2) {
            if (this.myResolveStatus.get((int)i2).myIsComplete) {
                hasCompleteResult = true;
                continue;
            }
            hasCandidateResult = true;
        }
        List results = this.myResults;
        if (hasCompleteResult && hasCandidateResult) {
            results = new SmartList();
            for (int i3 = 0; i3 < this.myResults.size(); ++i3) {
                if (!this.myResolveStatus.get((int)i3).myIsComplete) continue;
                results.add((PsiElement)this.myResults.get(i3));
            }
        }
        return results;
    }

    @Override
    public boolean accepts(PsiElement element) {
        String name;
        if (!(!(element instanceof PsiNamedElement) || this.myName.equals(name = ResolveProcessor.getName(element)) || name == null && ResolveResultSink.isAcceptableForComputedPropertyName(element))) {
            return false;
        }
        if (element instanceof ES6ImportExportSpecifier && !this.myName.equals(((ES6ImportExportSpecifier)element).getReferenceName())) {
            return false;
        }
        if (element instanceof ES6ExportDefaultAssignment && !this.myName.equals("default")) {
            return false;
        }
        return super.accepts(element);
    }

    @Contract(value="null -> false")
    public static boolean isAcceptableForComputedPropertyName(@Nullable PsiElement element) {
        if (!(element instanceof JSComputedPropertyNameOwner)) {
            return false;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element).getComputedPropertyName();
        return computedPropertyName != null && computedPropertyName.getExpressionAsPropertyName() == null;
    }

    private ThreeState isAccurateComputedNameMatch(@Nullable PsiElement element) {
        if (!(element instanceof JSComputedPropertyNameOwner)) {
            return ThreeState.UNSURE;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element).getComputedPropertyName();
        if (computedPropertyName == null) {
            return ThreeState.UNSURE;
        }
        JSType type = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (type instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (this.myName.equals(literal)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSNumberLiteralTypeImpl)type).getValueAsString();
            if (this.myName.equals(string)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @Override
    public boolean addResult(@Nullable PsiElement element, @Nullable ResolveState state2, @Nullable PsiElement placeTopParent) {
        ReadWriteAccessDetector.Access expressionAccess;
        JSFunction fun;
        if (this.myAcceptAllResults) {
            this.doAddResult(element, state2, placeTopParent);
            return true;
        }
        List<PsiElement> results = super.getResults();
        int previousResultsSize = results != null ? results.size() : 0;
        boolean stopProcessing = true;
        Object elementForPropertyProcessing = element;
        if (element instanceof JSProperty) {
            elementForPropertyProcessing = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (this.place != null && elementForPropertyProcessing instanceof JSFunction && ((fun = (JSFunction)elementForPropertyProcessing).isGetProperty() || fun.isSetProperty()) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(this.place)) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement psiElement;
            if (previousResultsSize == 0) {
                stopProcessing = false;
            }
            if (previousResultsSize == 1 && (psiElement = results.get(0)) instanceof JSFunction) {
                JSFunction prevFun = (JSFunction)psiElement;
                if (prevFun.isGetProperty() && fun.isGetProperty()) {
                    return true;
                }
                if (prevFun.isSetProperty() && fun.isSetProperty()) {
                    return true;
                }
            }
            if (previousResultsSize == 2) {
                return true;
            }
        }
        if (ResolveResultSink.isAcceptableForComputedPropertyName(element)) {
            ThreeState match2 = this.isAccurateComputedNameMatch(element);
            if (match2 == ThreeState.UNSURE) {
                if (DialectDetector.isTypeScript(element)) {
                    this.doAddResult((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(this.myName, null, element, true), state2, placeTopParent);
                    return true;
                }
                stopProcessing = false;
            } else {
                if (match2 == ThreeState.NO) {
                    return true;
                }
                if (this.myResults != null) {
                    List toRemove = ContainerUtil.filter((Collection)this.myResults, r -> ResolveResultSink.isAcceptableForComputedPropertyName(r));
                    for (PsiElement item : toRemove) {
                        int index = this.myResults.indexOf(item);
                        this.myResults.remove(index);
                        this.myResolveStatus.remove(index);
                    }
                }
            }
        }
        this.doAddResult(element, state2, placeTopParent);
        return !stopProcessing;
    }

    private void doAddResult(@Nullable PsiElement element, @Nullable ResolveState state2, @Nullable PsiElement placeTopParent) {
        super.addResult(element, state2, placeTopParent);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(this.getResolveStatus(element, state2, placeTopParent));
    }

    @NotNull
    private JSSinkResolveStatus getResolveStatus(@Nullable PsiElement element, @Nullable ResolveState state2, PsiElement placeTopParent) {
        JSElement importElement;
        JSElement jSElement = importElement = state2 != null ? (JSElement)state2.get(JSResolveResult.IMPORT_KEY) : null;
        if (this.isActionScript()) {
            return this.checkActionScriptQualifiedNameHasNecessaryImport(element, importElement, placeTopParent);
        }
        return new JSSinkResolveStatus(importElement, true, null, state2 == null ? null : (JSTypeSubstitutor)state2.get(JSResolveResult.GENERICS));
    }

    @NotNull
    private JSSinkResolveStatus checkActionScriptQualifiedNameHasNecessaryImport(PsiElement element, @Nullable JSElement importElement, @Nullable PsiElement placeTopParent) {
        String resolveProblem = null;
        if (importElement == null && this.isActionScript() && (element instanceof JSClass || element instanceof JSFunction || element instanceof JSVariable || element instanceof JSNamespaceDeclaration) && placeTopParent instanceof JSReferenceExpression && !(placeTopParent.getParent() instanceof JSImportStatement)) {
            String qName;
            if (placeTopParent.getParent() instanceof JSNewExpression && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                element = element.getParent();
            }
            String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
            if (qName != null && qName.indexOf(46) != -1 && !JSResolveUtil.getPackageName(element).equals(JSResolveUtil.getPackageNameFromPlace(this.place)) && !UnusedImportsUtil.isSomeNodeThatShouldNotHaveImportsWhenQualified((JSReferenceExpression)placeTopParent, element)) {
                boolean noImportNoResolve;
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(this.myName, new ResolveResultSink(null, this.myName)){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element instanceof JSQualifiedNamedElement) {
                            if (!qName.equals(((JSQualifiedNamedElement)element).getQualifiedName())) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        return super.execute(element, state2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.putUserData(ResolveProcessor.ASKING_FOR_QUALIFIED_IMPORT, qName);
                PsiNamedElement importOwner = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)placeTopParent, (Class[])new Class[]{JSFunction.class, JSFile.class, JSPackageStatement.class, JSClass.class});
                if (importOwner != null) {
                    PsiElement elt = PsiTreeUtil.getChildOfAnyType((PsiElement)importOwner, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (elt == null) {
                        elt = importOwner.getFirstChild();
                    }
                    JSResolveUtil.treeWalkUp(processor, (PsiElement)importOwner, elt, this.place);
                }
                boolean bl = noImportNoResolve = processor.getResult() == null;
                if (noImportNoResolve) {
                    resolveProblem = "javascript.qualified.name.is.not.imported.message";
                } else {
                    ResolveResult[] resultsAsResolveResults = ((ResolveResultSink)processor.getResultSink()).getResultsAsResolveResults();
                    if (resultsAsResolveResults.length != 0) {
                        importElement = ((JSResolveResult)resultsAsResolveResults[0]).getActionScriptImport();
                    }
                }
            }
        }
        return new JSSinkResolveStatus(importElement, true, resolveProblem, null);
    }

    public ResolveResult @NotNull [] getResultsAsResolveResults() {
        if (this.myResults == null || this.myResults.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ResolveResultSink.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<JSResolveResultForSymbolProcessor> results = this.getFilteredResults();
        ResolveResult[] array = new ResolveResult[results.size()];
        for (int i2 = 0; i2 < results.size(); ++i2) {
            array[i2] = results.get(i2).getResolveResult();
        }
        if (array == null) {
            ResolveResultSink.$$$reportNull$$$0(4);
        }
        return array;
    }

    public static ResolveResult @Nullable [] resolveImportExportSpecifiers(@Nullable PsiElement element) {
        ResolveResult[] newResults;
        if (element instanceof ES6ImportExportSpecifier) {
            ResolveResult[] results = ((ES6ImportExportSpecifier)element).multiResolve(false);
            return results.length == 0 ? null : results;
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ResolveResult[] newResults2 = ResolveResultSink.getResultsForSpecifierAlias((ES6ImportExportSpecifierAlias)element);
            if (newResults2 != null) {
                return newResults2;
            }
        } else if (element instanceof ES6ImportedBinding && (newResults = ResolveResultSink.getResultsForImportedBinding((ES6ImportedBinding)element)) != null) {
            return newResults;
        }
        return null;
    }

    private static ResolveResult @Nullable [] getResultsForImportedBinding(@NotNull ES6ImportedBinding element) {
        Collection<PsiElement> referencedElements;
        int size;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(5);
        }
        if ((size = (referencedElements = element.findReferencedElements()).size()) == 0) {
            return null;
        }
        if (size == 1) {
            List<PsiElement> elements;
            String initializerReference;
            PsiElement psiElement = referencedElements.iterator().next();
            if (psiElement instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)psiElement).getInitializerReference()) != null && (elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(initializerReference, psiElement)).size() > 0) {
                return ResolveResultSink.convertBindingElements(element, elements);
            }
        } else {
            List mappedElements = (List)StreamEx.of(referencedElements).map(el -> el instanceof ES6ExportDefaultAssignment ? ((ES6ExportDefaultAssignment)el).getStubSafeElement() : null).nonNull().collect(Collectors.toList());
            return mappedElements.size() == size ? ResolveResultSink.convertBindingElements(element, mappedElements) : null;
        }
        return null;
    }

    private static ResolveResult @Nullable [] convertBindingElements(@NotNull ES6ImportedBinding element, Collection<PsiElement> elements) {
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(6);
        }
        if (elements.size() > 1 && elements.stream().allMatch(e -> e instanceof TypeScriptFunction)) {
            elements = ContainerUtil.filter(elements, e -> !((TypeScriptFunction)e).isOverloadImplementation());
        }
        return ResolveResultSink.createAliasElementsFromResult(element, (ResolveResult[])elements.stream().map(e -> new JSResolveResult((PsiElement)e)).toArray(ResolveResult[]::new));
    }

    private static ResolveResult @Nullable [] getResultsForSpecifierAlias(@NotNull ES6ImportExportSpecifierAlias element) {
        ResolveResult[] newResults;
        ES6ImportExportSpecifier specifier;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(7);
        }
        if ((specifier = element.findSpecifierElement()) != null && (newResults = ResolveResultSink.createAliasElementsFromResult(element, specifier.multiResolve(false))) != null) {
            return newResults;
        }
        return null;
    }

    private static ResolveResult @Nullable [] createAliasElementsFromResult(@NotNull JSNamedElement element, ResolveResult @NotNull [] results) {
        String name;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(8);
        }
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(9);
        }
        if ((name = element.getName()) != null && results.length > 1) {
            return TypeScriptImplicitOverloadedAliasElement.wrapElements(results, name, element);
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static List<PsiElement> mergeElementsIfNeeded(@Nullable List<PsiElement> elements) {
        JSRecordType.IndexSignature indexer;
        if (elements == null || elements.isEmpty() || elements.size() == 1 && (!(elements.get(0) instanceof TypeScriptImplicitMemberForComputedProperty) || !((TypeScriptImplicitMemberForComputedProperty)elements.get(0)).isTemporary())) {
            return elements;
        }
        if (ContainerUtil.exists(elements, e -> !(e instanceof TypeScriptImplicitMemberForComputedProperty) || !((TypeScriptImplicitMemberForComputedProperty)e).isTemporary())) {
            return elements;
        }
        TypeScriptImplicitMemberForComputedProperty element = (TypeScriptImplicitMemberForComputedProperty)elements.get(0);
        String name = element.getName();
        if (name == null) {
            return elements;
        }
        PsiElement explicitElement = element.getExplicitElement();
        if (explicitElement == null) {
            return elements;
        }
        PsiElement parent = explicitElement.getParent();
        if (!(parent instanceof JSObjectLiteralExpression)) {
            return elements;
        }
        JSType type = JSResolveUtil.getExpressionJSType((JSExpression)parent);
        if (type instanceof JSRecordType && (indexer = ((JSRecordType)type).findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null) {
            return ContainerUtil.createMaybeSingletonList((Object)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), parent, false));
        }
        return elements;
    }

    @NotNull
    public List<JSResolveResultForSymbolProcessor> getFilteredResults() {
        int i2;
        List<PsiElement> processorResults = ResolveResultSink.mergeElementsIfNeeded(super.getResults());
        if (processorResults == null || processorResults.isEmpty()) {
            List<JSResolveResultForSymbolProcessor> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveResultSink.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Object results = new SmartList();
        HashSet<Pair> completeResults = new HashSet<Pair>(processorResults.size());
        for (i2 = 0; i2 < processorResults.size(); ++i2) {
            PsiElement processorResult = processorResults.get(i2);
            JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i2);
            if (!resolveStatus.myIsComplete || resolveStatus.getResolveProblem() != null || !completeResults.add(Pair.create((Object)processorResult, (Object)resolveStatus))) continue;
            ResolveResultSink.fillResults(processorResult, resolveStatus, this.getNestingLevelForResultElement(processorResult, i2), (List<JSResolveResultForSymbolProcessor>)results);
        }
        if (results.isEmpty()) {
            for (i2 = 0; i2 < processorResults.size(); ++i2) {
                JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i2);
                if (resolveStatus.myIsComplete && resolveStatus.getResolveProblem() == null) continue;
                PsiElement element = processorResults.get(i2);
                ResolveResultSink.fillResults(element, resolveStatus, this.getNestingLevelForResultElement(element, i2), (List<JSResolveResultForSymbolProcessor>)results);
            }
        }
        if (this.isRuntimeOnlyPlace()) {
            results = TypeScriptPsiUtil.removeCompileTimeTypes((List<JSResolveResultForSymbolProcessor>)results);
        }
        if (TypeScriptPsiUtil.elementsPossiblyContainDuplicates(ContainerUtil.map((Collection)results, JSResolveResultForSymbolProcessor::getResolveResult))) {
            results = (List)TypeScriptPsiUtil.removeDuplicates(results, el -> el.resolveResult.getElement(), this.place);
        }
        if (this.myAcceptAllResults || this.myIncomplete || this.place == null || DialectDetector.isActionScript(this.place)) {
            Object object = results;
            if (object == null) {
                ResolveResultSink.$$$reportNull$$$0(11);
            }
            return object;
        }
        JSCallLikeExpression callExpression = TypeScriptSignatureChooser.getCallLikeExpression(this.place);
        if (callExpression != null) {
            results = ResolveResultSink.filterOverloads((List<JSResolveResultForSymbolProcessor>)results, callExpression);
        }
        Object object = results;
        if (object == null) {
            ResolveResultSink.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    private static List<JSResolveResultForSymbolProcessor> filterOverloads(@NotNull List<JSResolveResultForSymbolProcessor> results, @NotNull JSCallLikeExpression callExpression) {
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(13);
        }
        if (callExpression == null) {
            ResolveResultSink.$$$reportNull$$$0(14);
        }
        for (JSResolveResultForSymbolProcessor result2 : results) {
            if (result2.isCompleteMatch && result2.resolveResult.isValidResult()) continue;
            List<JSResolveResultForSymbolProcessor> list2 = results;
            if (list2 == null) {
                ResolveResultSink.$$$reportNull$$$0(15);
            }
            return list2;
        }
        ArrayList<JSResolveResultForSymbolProcessor> sortedResults = new ArrayList<JSResolveResultForSymbolProcessor>(results);
        Collections.sort(sortedResults, Comparator.comparing(r -> r.getResolveResult().getElement(), JSResolveUtil.FILE_PATH_COMPARATOR));
        ArrayList<JSResolveResultForSymbolProcessor> filteredOverloads = (ArrayList<JSResolveResultForSymbolProcessor>)JSEvaluationRecursionGuard.compute((PsiElement)callExpression, new JSEvaluateContext(callExpression.getContainingFile(), false), () -> new JSTypeSignatureChooser(callExpression).chooseOverload((List<? extends JSResolveResultForSymbolProcessor>)sortedResults, false));
        ArrayList<JSResolveResultForSymbolProcessor> arrayList = filteredOverloads != null ? filteredOverloads : sortedResults;
        if (arrayList == null) {
            ResolveResultSink.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private boolean isRuntimeOnlyPlace() {
        boolean isStrictTypeContext = this.place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)this.place);
        return !isStrictTypeContext && TypeScriptPsiUtil.isPlaceRuntimeOnly(this.place, false);
    }

    private static void fillResults(@NotNull PsiElement element, @NotNull JSSinkResolveStatus sinkResolveStatus, int nestingLevel, @NotNull List<JSResolveResultForSymbolProcessor> outResults) {
        Object[] resolvedImports;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(17);
        }
        if (sinkResolveStatus == null) {
            ResolveResultSink.$$$reportNull$$$0(18);
        }
        if (outResults == null) {
            ResolveResultSink.$$$reportNull$$$0(19);
        }
        if ((resolvedImports = ResolveResultSink.resolveImportExportSpecifiers(element)) != null && resolvedImports.length > 0 && resolvedImports[0].isValidResult()) {
            JSElement importElement = element instanceof JSElement ? (JSElement)element : null;
            outResults.addAll(ContainerUtil.map((Object[])resolvedImports, r -> {
                JSResolveResult first = new JSResolveResult(r.getElement(), new JSResolveStatus(importElement, sinkResolveStatus.getResolveProblem(), sinkResolveStatus.getTypeSubstitutor()));
                return new JSResolveResultForSymbolProcessor(first, true, nestingLevel);
            }));
        } else {
            JSResolveResult first = new JSResolveResult(element, sinkResolveStatus.myResolveStatus);
            outResults.add(new JSResolveResultForSymbolProcessor(first, sinkResolveStatus.myIsComplete, nestingLevel));
        }
    }

    @Override
    public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
        if (this.myCandidateResults == null) {
            this.myCandidateResults = new HashSet<PsiElement>();
        }
        if (!this.myCandidateResults.add(element)) {
            return;
        }
        super.addResult(element, null, null);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(new JSSinkResolveStatus(null, isCompleteMatch, problemKey, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResolveStatus";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsAsResolveResults";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredResults";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForImportedBinding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertBindingElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForSpecifierAlias";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAliasElementsFromResult";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterOverloads";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fillResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSResolveResultForSymbolProcessor {
        private final ResolveResult resolveResult;
        final boolean isCompleteMatch;
        final int nestingLevel;

        public JSResolveResultForSymbolProcessor(@NotNull ResolveResult baseResult) {
            if (baseResult == null) {
                JSResolveResultForSymbolProcessor.$$$reportNull$$$0(0);
            }
            this(baseResult, true, 0);
        }

        public JSResolveResultForSymbolProcessor(ResolveResult resolveResult, boolean isCompleteMatch, int nestingLevel) {
            this.resolveResult = resolveResult;
            this.isCompleteMatch = isCompleteMatch;
            this.nestingLevel = nestingLevel;
        }

        @NotNull
        public ResolveResult getResolveResult() {
            ResolveResult resolveResult = this.resolveResult;
            if (resolveResult == null) {
                JSResolveResultForSymbolProcessor.$$$reportNull$$$0(1);
            }
            return resolveResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$JSResolveResultForSymbolProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$JSResolveResultForSymbolProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

