/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSymbolResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSPropertyAccessorChecker;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalkUpResolveProcessor
extends BaseJSSymbolProcessor {
    private final JSResolveMatchData matchData;
    private boolean mySkipDefs;
    protected final String myName;
    private boolean myTooManyCandidates;

    public WalkUpResolveProcessor(@NotNull String name, @NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (name == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(2);
        }
        super(targetFile, context);
        this.matchData = new JSResolveMatchData();
        this.myName = name;
        if (context instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            JSExpression originalQualifier = refExpr.getQualifier();
            JSExpression qualifier = JSResolveUtil.getRealRefExprQualifier(refExpr);
            if (qualifier == null || originalQualifier == null) {
                if (qualifier == null) {
                    JSImportedElementResolveResult expression = JSImportHandlingUtil.resolveTypeNameUsingImports(refExpr);
                    if (expression != null) {
                        JSQualifiedName qName = JSResolveUtil.buildNamespaceForQualifier(JSResolveUtil.getRealRefExprQualifierFromResult(refExpr, expression)).getQualifiedName();
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName != null ? qName.getQualifiedName() : "");
                    } else if (this.typescript) {
                        TypeScriptModule module = (TypeScriptModule)PsiTreeUtil.getParentOfType((PsiElement)refExpr, TypeScriptModule.class);
                        if (module != null) {
                            String qualifiedName = module.getQualifiedName();
                            assert (qualifiedName != null);
                            this.myTypeInfo.addAllParentScopes(qualifiedName);
                        }
                    } else if (this.ecmal4) {
                        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
                        this.addPackageScope(jsClass, (PsiElement)refExpr);
                    } else {
                        JSExpression withExpression;
                        JSWithStatement withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, JSWithStatement.class);
                        if (withStatement != null && (withExpression = withStatement.getExpression()) != null) {
                            JSTypeEvaluator.evaluateTypes(withExpression, this.createTypeProcessor());
                        }
                    }
                }
            } else {
                if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && qualifier instanceof JSThisExpression) {
                    PsiElement clazz;
                    JSNamespace ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                    this.updateTypeInfoFromThis(ns);
                    String contextQualifierText = JSNamespace.getQualifiedName(ns);
                    Object object = contextQualifierText == null ? null : (clazz = this.ecmal4 ? JSClassResolver.findClassFromNamespace(contextQualifierText, context) : TypeScriptClassResolver.getInstance().findAnyClassByQName(contextQualifierText, JSResolveUtil.getResolveScope(context)));
                    if (clazz instanceof JSClass) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, false, ns.getJSContext());
                    } else if (contextQualifierText != null) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, true, ns.getJSContext());
                    }
                }
                if (!(qualifier instanceof JSThisExpression) && !(qualifier instanceof JSSuperExpression) || !this.ecmal4) {
                    BaseJSSymbolProcessor.JSTypeProcessorBase processor = this.createTypeProcessor();
                    processor.evaluateQualifier(qualifier, originalQualifier);
                }
            }
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, this.createTypeProcessor(), parent);
            if (this.typescript) {
                this.forceSetAddOnlyCompleteMatches();
            }
        }
        if (this.myTypeInfo.typeWasProcessed()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.initCheckFileLevelAccess();
    }

    @Override
    protected boolean isStrictTypingPossible(@NotNull JSType type) {
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(3);
        }
        return super.isStrictTypingPossible(type) && !this.isPredefinedPartialResolve(type) && WalkUpResolveProcessor.isTypeSourceLimitsResolve(type);
    }

    private boolean isPredefinedPartialResolve(@NotNull JSType type) {
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(4);
        }
        if (this.typescript || !(this.myContext instanceof JSReferenceExpression)) {
            return false;
        }
        if (JSResolveUtil.isFrameworkPredefinedExtensibleType(type)) {
            return true;
        }
        JSExpression qualifier = ((JSReferenceExpression)this.myContext).getQualifier();
        boolean isUnqualifiedQualifier = qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null;
        return (isUnqualifiedQualifier || JSResolveUtil.isPredefinedExtensibleType(type)) && WalkUpResolveProcessor.isJavaScriptPredefinedLibraryElement(type.getSourceElement(), false);
    }

    private static boolean isTypeSourceLimitsResolve(@NotNull JSType type) {
        JSQualifiedNamedElement initializedElement;
        JSDocComment comment;
        PsiElement sourceElement;
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(5);
        }
        if ((sourceElement = type.getSourceElement()) instanceof JSDocComment || sourceElement instanceof JSTypeDeclaration) {
            return true;
        }
        if (sourceElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)sourceElement).getName())) {
            return true;
        }
        if (sourceElement instanceof JSQualifiedNamedElement && (comment = JSStubBasedPsiTreeUtil.findDocComment(sourceElement)) != null && comment.hasNamespaceTag()) {
            return true;
        }
        if (sourceElement instanceof JSObjectLiteralExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)sourceElement, false)) != null && ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)initializedElement)) {
            return true;
        }
        return sourceElement instanceof JSClass && ((JSClass)sourceElement).getExtendsList() == null;
    }

    @NotNull
    private BaseJSSymbolProcessor.JSTypeProcessorBase createTypeProcessor() {
        return this.ecmal4 ? new ActionScriptResolveTypeProcessor() : new JSResolveTypeProcessor();
    }

    @Override
    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context) {
        JSElement container;
        JSTypeInfo.GlobalStatusHint statusHint = super.initGlobalStatusHint(context);
        if (context instanceof JSReferenceExpression && (container = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class})) != null && (container.getContainingFile().getContext() != null || container.getContext() instanceof XmlAttributeValue) && statusHint == JSTypeInfo.GlobalStatusHint.GLOBAL) {
            statusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = statusHint;
        if (globalStatusHint == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(6);
        }
        return globalStatusHint;
    }

    protected void doUnqualifiedCheck(@NotNull PsiElement element) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(7);
        }
        this.addPartialResult(element, null);
    }

    protected void doQualifiedCheck(@NotNull JSPsiElementBase element) {
        String isAcceptable;
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(8);
        }
        if ((isAcceptable = this.isAcceptable(element)) != null) {
            if (isAcceptable == "javascript.element.need.to.be.exported" && this.isInLibrary((PsiElement)element)) {
                return;
            }
            JSResolveResult o = new JSResolveResult((PsiElement)element, null, isAcceptable);
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = isAcceptable == "javascript.element.need.to.be.imported" ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_IMPORTED) : (isAcceptable == "javascript.element.need.to.be.exported" ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_EXPORTED, JSTaggedResolveResult.ResolveResultTag.PARTIAL) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
            this.matchData.addResult(o, tags);
            return;
        }
        JSQualifiedName namespace = element.getNamespace();
        IntRef matchLevel = new IntRef(-1);
        Ref isAccessible = Ref.create((Object)true);
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, matchLevel, (Ref<Boolean>)isAccessible);
        if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            String propertyAccessError = JSPropertyAccessorChecker.getPropertyAccessError(this.myContext, (PsiElement)element, false);
            if (propertyAccessError != null) {
                this.addCompleteResultWithProblem((PsiElement)element, propertyAccessError);
                return;
            }
            if (namespace != null && !((Boolean)isAccessible.get()).booleanValue() && this.checkAndAddNotAccessibleJSElement(element)) {
                return;
            }
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL) {
            this.addPartialResult((PsiElement)element, null);
        } else if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.matchData.addResult(new JSResolveResult((PsiElement)element), tags, matchLevel.get());
        }
    }

    private boolean isInLibrary(@NotNull PsiElement resolveResult) {
        VirtualFile file2;
        if (resolveResult == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(9);
        }
        return (file2 = resolveResult.getContainingFile().getVirtualFile()) != null && ProjectRootManager.getInstance((Project)this.myTargetFile.getProject()).getFileIndex().isInLibrary(file2);
    }

    private boolean checkAndAddNotAccessibleJSElement(@NotNull JSPsiElementBase element) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(10);
        }
        if (this.ecmal4 || this.typescript || !(this.myContext instanceof JSReferenceExpression) || JSResolveUtil.isSameReference((JSReferenceExpression)this.myContext, (PsiElement)element)) {
            return false;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        this.addCompleteResultWithProblem((PsiElement)element, accessType == JSAttributeList.AccessType.PRIVATE ? "javascript.jsdoc.private.member.is.not.accessible.message" : (accessType == JSAttributeList.AccessType.PROTECTED ? "javascript.jsdoc.protected.member.is.not.accessible.message" : null));
        return true;
    }

    private void addCompleteResultWithProblem(PsiElement element, String problemKey) {
        this.matchData.addResult(new JSResolveResult(element, null, problemKey), EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
    }

    private void addPartialResult(PsiElement element, @Nullable String resolveProblem) {
        JSResolveResult o = new JSResolveResult(element, null, resolveProblem);
        this.matchData.addResult(o, EnumSet.of(JSTaggedResolveResult.ResolveResultTag.PARTIAL));
    }

    public PsiFile getBaseFile() {
        return this.myTargetFile;
    }

    @Override
    public String getRequiredName() {
        return this.myName;
    }

    public ResolveResult[] getResults() {
        if (this.myTooManyCandidates) {
            return JSResolveResult.tooManyCandidatesResult();
        }
        List<JSTaggedResolveResult> taggedResolveResults = this.getTaggedResolveResults();
        if (taggedResolveResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        int resultCount = taggedResolveResults.size();
        ResolveResult[] result2 = new ResolveResult[resultCount];
        for (int i2 = 0; i2 < resultCount; ++i2) {
            JSTaggedResolveResult taggedResolveResult = taggedResolveResults.get(i2);
            ResolveResult resolveResult = taggedResolveResult.result;
            if (resolveResult instanceof JSResolveResult) {
                JSResolveResult jsResolveResult = (JSResolveResult)resolveResult;
                JSResolveStatus status = jsResolveResult.getStatus();
                if (taggedResolveResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL)) {
                    JSSymbolResolveStatus resolveStatus = new JSSymbolResolveStatus(status, true);
                    resolveResult = new JSResolveResult(jsResolveResult.getElement(), resolveStatus);
                }
            }
            result2[i2] = resolveResult;
        }
        return result2;
    }

    @NotNull
    public List<JSTaggedResolveResult> getTaggedResolveResults() {
        List<JSTaggedResolveResult> list2 = this.matchData.getTaggedResolveResults();
        if (list2 == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public void addLocalResults(@NotNull SinkResolveProcessor<ResolveResultSink> processor) {
        if (processor == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(12);
        }
        ResolveResultSink sink = processor.getResultSink();
        List<ResolveResultSink.JSResolveResultForSymbolProcessor> results = sink.getFilteredResults();
        for (ResolveResultSink.JSResolveResultForSymbolProcessor result2 : results) {
            ResolveResult e = result2.getResolveResult();
            if (e.isValidResult() || !result2.isCompleteMatch) {
                EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                PsiElement element = e.getElement();
                if (element instanceof JSLocalImplicitElementImpl) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.RECORD_TYPE_PROPERTY);
                    JSLocalImplicitElementImpl localImplicitElement = (JSLocalImplicitElementImpl)element;
                    if (localImplicitElement.hasMinorImportance() && !localImplicitElement.hasExplicitJSType()) {
                        tags.add(JSTaggedResolveResult.ResolveResultTag.PARTIAL);
                        this.allowPartialResults();
                    }
                }
                if (result2.isCompleteMatch) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES);
                } else {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
                }
                this.matchData.addResult(e, tags, result2.nestingLevel);
                continue;
            }
            if (!(e instanceof JSResolveResult)) continue;
            this.addPartialResult(e.getElement(), ((JSResolveResult)e).getResolveProblemKey());
        }
    }

    public void setSkipDefinitions(boolean b) {
        this.mySkipDefs = b;
    }

    public void setTooManyCandidates() {
        this.myTooManyCandidates = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaggedResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedPartialResolve";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSourceLimitsResolve";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doUnqualifiedCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doQualifiedCheck";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAddNotAccessibleJSElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLocalResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JSResolveMatchData {
        @Nullable
        private List<JSTaggedResolveResult> matchData = null;

        private JSResolveMatchData() {
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags) {
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(0);
            }
            this.addResult(o, tags, 0);
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, int completeMatchLevel) {
            PsiElement element;
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(1);
            }
            if ((element = o.getElement()) instanceof JSDefinitionExpression && WalkUpResolveProcessor.this.mySkipDefs && JSPsiImplUtils.isUnqualifiedAssignment((JSDefinitionExpression)element)) {
                return;
            }
            if (this.matchData == null) {
                this.matchData = new SmartList();
            }
            if (WalkUpResolveProcessor.this.isFromRelevantFileOrDirectory()) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.CURRENT_FILE);
            }
            BaseJSSymbolProcessor.addResolveResultTags(tags, element, WalkUpResolveProcessor.this.myContext);
            this.matchData.add(new JSTaggedResolveResult(o, tags, completeMatchLevel));
        }

        List<JSTaggedResolveResult> getTaggedResolveResults() {
            if (this.matchData == null) {
                return Collections.emptyList();
            }
            Collections.sort(this.matchData);
            JSTaggedResolveResult topResult = this.matchData.get(0);
            boolean topResultIsPartial = topResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL);
            if (WalkUpResolveProcessor.this.addOnlyCompleteMatches() && topResultIsPartial) {
                this.matchData = null;
                return Collections.emptyList();
            }
            int resultCount = 0;
            for (JSTaggedResolveResult taggedResolveResult : this.matchData) {
                int compare;
                if (!topResultIsPartial && (compare = taggedResolveResult.comparePriorityTo(topResult)) != 0) {
                    assert (compare > 0);
                    break;
                }
                ++resultCount;
            }
            this.matchData = this.matchData.subList(0, resultCount);
            return this.matchData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveMatchData", "addResult"));
        }
    }

    private class JSResolveTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private JSResolveTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context) {
            if (type == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(1);
            }
            this.processType(type, context);
        }

        private void processType(@NotNull JSType type, @NotNull JSEvaluateContext context) {
            if (type == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(3);
            }
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)candidate -> {
                this.processCandidate((JSType)candidate, context);
                return true;
            }), type, WalkUpResolveProcessor.this.typescript, true, false);
            this.processCandidate(type, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ActionScriptResolveTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private ActionScriptResolveTypeProcessor() {
        }

        @Override
        public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
            if (type == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(1);
            }
            this.process(type, evaluateContext);
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context) {
            if (type == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(3);
            }
            if (type instanceof JSAnyType) {
                return;
            }
            if (!(type instanceof JSNamespace)) {
                return;
            }
            boolean result2 = JSTypeEvaluateManager.iterateTypeHierarchy((JSNamespace)type, (Processor<JSClass>)((Processor)clazz -> !"flash.utils.Proxy".equals(clazz.getQualifiedName())), (Processor<JSType>)((Processor)baseType -> !"Proxy".equals(JSTypeUtils.getQualifiedNameMatchingType(baseType, false))), WalkUpResolveProcessor.this.myContext, false);
            if (!result2) {
                return;
            }
            WalkUpResolveProcessor.this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(type.getTypeText());
        }

        @Override
        protected void allowPartialResults() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$ActionScriptResolveTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdditionalType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

