/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptModuleStubImpl
extends JSQualifiedObjectStubBase<TypeScriptModule>
implements TypeScriptModuleStub {
    private static final BooleanStructureElement IS_AUGMENTATION = new BooleanStructureElement();
    private static final BooleanStructureElement IS_SHORTHAND_AMBIENT_MODULE = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, IS_AUGMENTATION, IS_SHORTHAND_AMBIENT_MODULE);

    public TypeScriptModuleStubImpl(TypeScriptModule module, StubElement parent, @NotNull TypeScriptModuleElementType elementType) {
        if (elementType == null) {
            TypeScriptModuleStubImpl.$$$reportNull$$$0(0);
        }
        super(module, parent, elementType);
        this.writeFlag(IS_AUGMENTATION, module.isAugmentation());
        this.writeFlag(IS_SHORTHAND_AMBIENT_MODULE, module.isShorthandAmbientModule());
    }

    public TypeScriptModuleStubImpl(StubInputStream dataStream, StubElement parentStub, @NotNull TypeScriptModuleElementType elementType) throws IOException {
        if (elementType == null) {
            TypeScriptModuleStubImpl.$$$reportNull$$$0(1);
        }
        super(dataStream, parentStub, (IStubElementType)elementType);
    }

    @Override
    public TypeScriptModule createPsi() {
        return new TypeScriptModuleImpl(this);
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        String name = this.getName();
        String externalModule = TypeScriptUtil.convertToExternalModuleText(name);
        if (externalModule == null) {
            return;
        }
        if (this.isAugmentation()) {
            sink.occurrence(TypeScriptExternalModuleIndex.KEY, (Object)"aug");
            return;
        }
        JSPathMappingsUtil.AsteriskCount asteriskCount = JSPathMappingsUtil.hasZeroOrOneAsteriskCharacter(externalModule);
        sink.occurrence(TypeScriptExternalModuleIndex.KEY, (Object)(asteriskCount == JSPathMappingsUtil.AsteriskCount.ONE ? "pat" : "reg"));
    }

    @Override
    protected boolean doIndexQualifiedName() {
        return true;
    }

    @Override
    protected boolean doIndexForGlobalQualifiedNameIndex() {
        return StubTreeUtil.isFromGlobalNamespace(this);
    }

    @Override
    public boolean isAugmentation() {
        return this.readFlag(IS_AUGMENTATION);
    }

    @Override
    public boolean isShorthandAmbientModule() {
        return this.readFlag(IS_SHORTHAND_AMBIENT_MODULE);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            TypeScriptModuleStubImpl.$$$reportNull$$$0(2);
        }
        return flagsStructure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/TypeScriptModuleStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/TypeScriptModuleStubImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

