/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompositeTypeBaseImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final List<JSType> myTypes;

    @Contract(value="null -> true")
    public static boolean isEmptyType(@Nullable JSType type) {
        return type == null || type instanceof TypeScriptNeverJSTypeImpl;
    }

    @NotNull
    public static List<JSType> flattenTypes(@NotNull StreamEx<? extends JSType> stream, @NotNull Class<? extends JSUnionOrIntersectionType> toFlatClass) {
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(0);
        }
        if (toFlatClass == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(1);
        }
        List list2 = ((StreamEx)JSCompositeTypeBaseImpl.flattenTypesStream((StreamEx<? extends JSType>)((StreamEx)stream.distinct()), toFlatClass).nonNull().distinct()).toList();
        if (list2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static StreamEx<JSType> flattenTypesStream(@NotNull StreamEx<? extends JSType> stream, @NotNull Class<? extends JSUnionOrIntersectionType> toFlatClass) {
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(3);
        }
        if (toFlatClass == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        StreamEx streamEx = stream.flatMap(el -> toFlatClass.isInstance(el) || el instanceof JSContextualUnionType ? JSCompositeTypeBaseImpl.flattenTypesStream((StreamEx<? extends JSType>)StreamEx.of(((JSUnionOrIntersectionType)el).getTypes()), toFlatClass) : StreamEx.of((Object)el));
        if (streamEx == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(5);
        }
        return streamEx;
    }

    @Nullable
    protected static JSType getTypeOfType(@Nullable JSType type, boolean allowResolve, @Nullable JSTypeSubstitutionContext context) {
        if (!allowResolve) {
            return type;
        }
        return type instanceof JSEvaluableType ? (context != null ? type.substitute(context) : type.substitute()) : type;
    }

    @NotNull
    private static JSType asNotNull(@Nullable JSType el, @NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(6);
        }
        JSType jSType = el == null ? new JSUndefinedType(source2) : el;
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    public JSCompositeTypeBaseImpl(JSTypeSource source2, JSType ... _types) {
        this(source2, (StreamEx<? extends JSType>)StreamEx.of((Object[])_types));
    }

    public JSCompositeTypeBaseImpl(@NotNull JSTypeSource source2, Collection<? extends JSType> _types) {
        if (source2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(8);
        }
        this(source2, (StreamEx<? extends JSType>)StreamEx.of(_types));
    }

    public JSCompositeTypeBaseImpl(@NotNull JSTypeSource source2, StreamEx<? extends JSType> _types) {
        if (source2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(9);
        }
        super(source2);
        this.myTypes = _types.map(el -> JSCompositeTypeBaseImpl.asNotNull(el, source2)).toImmutableList();
    }

    protected JSCompositeTypeBaseImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(10);
        }
        if (inputStream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(11);
        }
        super(source2);
        this.myTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source2, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(12);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myTypes, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(14);
        }
        String delimiter = this.getTypeSeparatorForTypeText(format);
        List<JSType> toProcess = this.getPresentableTypes(format);
        for (int i2 = 0; i2 < toProcess.size(); ++i2) {
            JSType currentType = toProcess.get(i2);
            if (i2 != 0) {
                builder.append(delimiter);
            }
            if (i2 > 10 && format == JSType.TypeTextFormat.PRESENTABLE) {
                builder.append("...");
                return;
            }
            if (this.shouldWrapNestedType(currentType)) {
                builder.append("(");
            }
            this.buildNestedTypePresentation(currentType, i2, format, builder);
            if (!this.shouldWrapNestedType(currentType)) continue;
            builder.append(")");
        }
    }

    @NotNull
    protected String getTypeSeparatorForTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(15);
        }
        Object object = format == JSType.TypeTextFormat.PRESENTABLE || this.isTypeScript() && format == JSType.TypeTextFormat.CODE ? " " + this.getTypeSeparator() + " " : this.getTypeSeparator();
        if (object == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    public List<JSType> getPresentableTypes(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(17);
        }
        List<JSType> types2 = this.myTypes;
        if (format != JSType.TypeTextFormat.CODE && format != JSType.TypeTextFormat.PRESENTABLE) {
            List<JSType> list2 = types2;
            if (list2 == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ArrayList<JSType> newTypes = new ArrayList<JSType>();
        ProcessingContext ctx = new ProcessingContext();
        for (JSType type : types2) {
            if (this.skipTypeFromPresentable(type) || newTypes.stream().anyMatch(t -> this.areTypesPresentablyEquivalent((JSType)t, type, format, ctx))) continue;
            newTypes.add(type);
        }
        ArrayList<JSType> arrayList = newTypes;
        if (arrayList == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    protected boolean skipTypeFromPresentable(JSType t) {
        return false;
    }

    protected boolean areTypesPresentablyEquivalent(JSType t, JSType type, JSType.TypeTextFormat format, ProcessingContext ctx) {
        if (this.preserveInnerTypes()) {
            return false;
        }
        if (t.isEquivalentTo(type, ctx, false)) {
            return true;
        }
        if (JSTypeUtils.isAnyType(t) && JSTypeUtils.isAnyType(type)) {
            return true;
        }
        if (format == JSType.TypeTextFormat.CODE && t instanceof JSPrimitiveLiteralType && type instanceof JSPrimitiveLiteralType && ((JSPrimitiveLiteralType)t).allowWidening() && ((JSPrimitiveLiteralType)type).allowWidening()) {
            return ((JSPrimitiveLiteralType)t).asPrimitiveType().isEquivalentTo(((JSPrimitiveLiteralType)type).asPrimitiveType(), ctx);
        }
        return false;
    }

    private boolean shouldWrapNestedType(@NotNull JSType currentType) {
        if (currentType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return currentType instanceof JSUnionOrIntersectionType && this.getClass() != currentType.getClass() || currentType instanceof JSFunctionTypeImpl;
    }

    protected void buildNestedTypePresentation(@NotNull JSType t, int index, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (t == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(21);
        }
        if (format == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(22);
        }
        if (builder == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(23);
        }
        t.buildTypeText(format, builder);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(24);
        }
        return JSTypeCastUtil.areListsEquivalent(this.getTypes(), ((JSCompositeTypeBaseImpl)type).getTypes(), processingContext, allowResolve);
    }

    @NotNull
    public final List<JSType> getTypes() {
        List<JSType> list2 = this.myTypes;
        if (list2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(26);
        }
        visitor.visitJSCompositeBaseType(this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(27);
        }
        for (JSType type : this.myTypes) {
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected abstract String getTypeSeparator();

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        Function transformFunc;
        List<JSType> oldTypes;
        List newTypes;
        if (childTransform == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(28);
        }
        if (newSource == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(29);
        }
        if (ContainerUtil.equalsIdentity((List)(newTypes = ContainerUtil.map(oldTypes = this.getTypes(), (Function)(transformFunc = t -> JSTypeUtils.transformTypeHierarchySafe(t, childTransform)))), oldTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(30);
            }
            return jSCompositeTypeBaseImpl;
        }
        JSType jSType = this.createType(newTypes, newSource, childTransform instanceof JSTypeBaseImpl.SourceTransformer);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType createType(@NotNull List<JSType> var1, @NotNull JSTypeSource var2, boolean var3);

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(32);
        }
        JSType jSType = this.createType(this.getTypes(), source2, true);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(33);
        }
        return jSType;
    }

    @Nullable
    protected JSType getSimpleCompositeTypeResult() {
        List<JSType> types2 = this.getTypes();
        if (types2.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types2, null);
        }
        if (types2.isEmpty()) {
            return JSAnyType.get(this.getSource().getSourceElement(), this.isSourceStrict());
        }
        return null;
    }

    @Override
    protected int hashCodeImpl() {
        return JSTypeHashCodeUtil.getHashCode(this.getTypes());
    }

    @NotNull
    protected Collection<JSRecordType> getNestedTypesAsRecordType() {
        List list2 = ContainerUtil.map(this.getTypes(), JSType::asRecordType);
        if (list2 == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        Stream<JSType> mergedSignatureType;
        if (processingContext == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(35);
        }
        if (!(this instanceof JSUnionOrIntersectionType)) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(36);
            }
            return stream;
        }
        JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)((Object)this);
        boolean strict = JSTypeCastUtil.strictNullChecks(processingContext);
        List compositeParts = JSTypeUtils.collectValidConstituents(compositeType, strict).collect(Collectors.toList());
        List types2 = (List)StreamEx.of(compositeParts).map(jsType2 -> jsType2.getFunctionTypes(JSCompositeTypeBaseImpl.copyProcessingContextForFunctionTypes(processingContext, strict), newCallSignatures).collect(Collectors.toList())).nonNull().collect(Collectors.toList());
        List flatten = ContainerUtil.flatten((Iterable)types2);
        if (!JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType) || compositeType instanceof JSIntersectionType && !newCallSignatures || !compositeType.isSourceStrict()) {
            Stream<JSType> stream = flatten.stream();
            if (stream == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(37);
            }
            return stream;
        }
        if (flatten.size() <= 1) {
            Stream<JSType> stream = flatten.stream();
            if (stream == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(38);
            }
            return stream;
        }
        if (compositeType instanceof JSIntersectionType) {
            Stream<JSType> stream = JSTypeUtils.mergeWithMixins(flatten);
            if (stream == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(39);
            }
            return stream;
        }
        if (compositeType instanceof JSUnionType && (mergedSignatureType = JSTypeUtils.getMergedUnionSignatureType(types2)) != null) {
            Stream<JSType> stream = mergedSignatureType;
            if (stream == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(40);
            }
            return stream;
        }
        JSRecordType substitute = compositeType.asRecordType();
        Stream<JSType> stream = substitute.getFunctionTypes(processingContext, newCallSignatures);
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(41);
        }
        return stream;
    }

    @NotNull
    public final JSType transformTypes(@NotNull NullableFunction<? super JSType, JSType> converter) {
        List<JSType> originalTypes;
        List result2;
        if (converter == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(42);
        }
        if (ContainerUtil.equalsIdentity((List)(result2 = ContainerUtil.mapNotNull(originalTypes = this.getTypes(), converter)), originalTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(43);
            }
            return jSCompositeTypeBaseImpl;
        }
        if (!this.preserveInnerTypes()) {
            if (result2.isEmpty()) {
                return new TypeScriptNeverJSTypeImpl(this.getSource());
            }
            if (result2.size() == 1) {
                JSType jSType = (JSType)result2.get(0);
                if (jSType == null) {
                    JSCompositeTypeBaseImpl.$$$reportNull$$$0(44);
                }
                return jSType;
            }
        }
        JSType jSType = this.createType(result2, this.getSource(), false);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    protected boolean preserveInnerTypes() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFlatClass";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenTypesStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asNotNull";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparatorForTypeText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableTypes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypesAsRecordType";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "flattenTypes";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flattenTypesStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asNotNull";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparatorForTypeText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapNestedType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildNestedTypePresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "transformTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

