/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSEvaluableTypeBase
extends JSSimpleTypeBaseImpl
implements JSCodeBasedType {
    @NotNull
    protected final Segment myRange;

    protected JSEvaluableTypeBase(@NotNull JSTypeSource source2, @NotNull Segment range) {
        if (source2 == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(1);
        }
        super(source2);
        this.myRange = range;
    }

    protected JSEvaluableTypeBase(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(3);
        }
        super(source2);
        this.myRange = JSTypeSerializer.readSegment(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeSegment(this.myRange, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(6);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            Segment range = this.getSegment();
            builder.append(this.getPrefix() + "(" + range.getStartOffset() + "," + range.getEndOffset() + ")" + this.getPostfix());
            return;
        }
        JSType evaluatedType = this.evaluateTypeRecursive();
        evaluatedType.buildTypeText(format, builder);
    }

    @NotNull
    private JSType evaluateTypeRecursive() {
        JSType eval = this.substitute();
        JSType jSType = eval.transformTypeHierarchy(new JSRecursiveExpandTransformer());
        if (jSType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(9);
        }
        JSType type = this.substitute();
        return type.isDirectlyAssignableType(elementType, processingContext);
    }

    @Nullable
    protected PsiElement findElementToProcess(@Nullable Segment range) {
        PsiElement element;
        JSTypeSource source2 = this.getSource();
        PsiElement sourceElement = source2.getSourceElement();
        if (sourceElement == null || !sourceElement.isValid()) {
            return null;
        }
        PsiFile scope = source2.getScope();
        if (scope == null) {
            return null;
        }
        PsiElement psiElement = element = range != null ? (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)scope, () -> scope.findElementAt(range.getStartOffset())) : null;
        while (element != null && !(element instanceof PsiFile) && element.getTextRange().getStartOffset() == range.getStartOffset() && element.getTextRange().getEndOffset() <= range.getEndOffset()) {
            if (element.getTextRange().getEndOffset() == range.getEndOffset() && this.isElementAcceptable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Override
    protected int hashCodeImpl() {
        JSTypeSource source2 = this.getSource();
        PsiElement element = source2.getSourceElement();
        VirtualFile file2 = element != null && element.isValid() ? PsiUtilCore.getVirtualFile((PsiElement)element) : null;
        int contextId = file2 == null ? super.hashCodeImpl() : file2.hashCode();
        return Objects.hash(contextId, this.myRange.getStartOffset(), this.myRange.getEndOffset());
    }

    protected abstract boolean isElementAcceptable(@NotNull PsiElement var1);

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        Segment otherTypeSegment;
        if (type == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(10);
        }
        JSEvaluableTypeBase otherType = (JSEvaluableTypeBase)type;
        Segment segment = this.getSegment();
        if (!segment.equals(otherTypeSegment = otherType.getSegment())) {
            return false;
        }
        PsiFile lScope = this.getScope();
        if (lScope == null || !lScope.isValid()) {
            return false;
        }
        PsiFile rScope = type.getSource().getScope();
        if (rScope == null || !rScope.isValid()) {
            return false;
        }
        return lScope.getManager().areElementsEquivalent((PsiElement)lScope, (PsiElement)rScope);
    }

    protected abstract String getPrefix();

    protected abstract String getPostfix();

    @NotNull
    public Segment getSegment() {
        Segment segment = this.myRange;
        if (segment == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(11);
        }
        return segment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateTypeRecursive";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

