/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSIntersectionType {
    static final String SEPARATOR = "&";

    @ApiStatus.Internal
    public JSIntersectionTypeImpl(@NotNull JSTypeSource source2, @NotNull Collection<? extends JSType> _types) {
        if (source2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (_types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        super(source2, _types);
    }

    protected JSIntersectionTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        super(source2, inputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(5);
        }
        boolean hadAssignable = false;
        List<JSType> types2 = this.getTypes();
        HashSet<JSType> nonAssignable = new HashSet<JSType>();
        boolean allNonAssignableWeak = true;
        for (JSType type : types2) {
            if (!type.isDirectlyAssignableType(elementType, processingContext)) {
                nonAssignable.add(type);
                allNonAssignableWeak &= JSIntersectionTypeImpl.isWeakOrWithoutProperties(type);
                continue;
            }
            if (this instanceof JSContextualUnionType) {
                return true;
            }
            hadAssignable = true;
        }
        if (nonAssignable.isEmpty()) {
            return true;
        }
        if (allNonAssignableWeak) {
            if (hadAssignable) {
                Set names = nonAssignable.stream().flatMap(t -> t.asRecordType().getPropertyNames().stream()).collect(Collectors.toSet());
                JSRecordType elementRecordType = elementType.asRecordType();
                names.retainAll(elementRecordType.getPropertyNames());
                if (names.isEmpty()) {
                    return true;
                }
                JSRecordType ownRecordType = this.asRecordType();
                for (String name : names) {
                    JSRecordType.PropertySignature ownSignature = ownRecordType.findPropertySignature(name);
                    JSRecordType.PropertySignature otherSignature = elementRecordType.findPropertySignature(name);
                    assert (ownSignature != null && otherSignature != null);
                    JSType ownSignatureType = ownSignature.getJSType();
                    if (ownSignatureType == null || ownSignatureType.isDirectlyAssignableType(otherSignature.getJSType(), processingContext)) continue;
                    return false;
                }
                return true;
            }
            return this.asRecordType().isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean isWeakOrWithoutProperties(@Nullable JSType t) {
        JSType jSType = t = t == null ? null : t.substitute();
        if (t instanceof JSPrimitiveType) {
            t = null;
        }
        if (t != null) {
            t = t.asRecordType();
        }
        return t != null && (((JSRecordType)t).isWeak() || !((JSRecordType)t).hasProperties());
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        return SEPARATOR;
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        if (sourceOnly) {
            return new JSIntersectionTypeImpl(newSource, transformedTypes);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(transformedTypes, newSource);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType result2;
        if (context == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(9);
        }
        if ((result2 = this.getSimpleCompositeTypeResult()) != null) {
            return result2;
        }
        return TypeScriptTypeRelations.expandUnionOrIntersectionType(this, context);
    }

    @Override
    @NotNull
    public JSRecordType asRecordTypeNoCache() {
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            return new JSRecordTypeImpl(this.getSource(), ContainerUtil.emptyList());
        }
        ArrayList<JSRecordType.TypeMember> resultMembers = new ArrayList<JSRecordType.TypeMember>();
        MultiMap map = MultiMap.createLinked();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                ProgressManager.checkCanceled();
                if (member instanceof JSRecordType.PropertySignature) {
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    String name = propertySignature.getMemberName();
                    map.putValue((Object)name, (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                boolean startOptional;
                ProgressManager.checkCanceled();
                Collection value = (Collection)entry.getValue();
                boolean isContextualUnion = this instanceof JSContextualUnionType;
                boolean isOptional = startOptional = !isContextualUnion;
                boolean isReadonly = isContextualUnion;
                ArrayList<JSType> types2 = new ArrayList<JSType>();
                ArrayList<PsiElement> propertySources = new ArrayList<PsiElement>(value.size());
                for (JSRecordType.PropertySignature signature : value) {
                    if (startOptional != signature.isOptional()) {
                        isOptional = signature.isOptional();
                    }
                    if (isContextualUnion && !signature.isConst()) {
                        isReadonly = false;
                    }
                    if (!isContextualUnion && signature.isConst()) {
                        isReadonly = true;
                    }
                    if (signature.getJSType() != null) {
                        types2.add(signature.getJSType());
                    }
                    JSRecordType.MemberSource source2 = signature.getMemberSource();
                    propertySources.addAll(source2.getAllSourceElements());
                }
                JSType resultType = this.getSubIntersectionType(types2);
                boolean finalOptional = isOptional || isContextualUnion && value.size() != resolvedTypes.size();
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, finalOptional, isReadonly, JSRecordMemberSourceFactory.createSource(propertySources, JSRecordType.MemberSourceKind.Intersection)));
            }
        }
        return new JSRecordTypeImpl(this.getSource(), resultMembers);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @NotNull
    protected JSType getSubIntersectionType(@NotNull Collection<JSType> types2) {
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(10);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(types2, this.getSource());
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIntersectionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSubIntersectionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

