/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConstType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSWidenType
extends JSTypeBaseImpl
implements JSWrapperType,
JSCodeBasedType {
    @NotNull
    private final Widening myWideningFunction;
    @NotNull
    private final JSType myType;

    @Contract(value="null, _ -> null")
    public static JSType createWidening(@Nullable JSType type, @Nullable PsiElement contextOwner) {
        if (type == null || type instanceof JSUtilType && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSTypeWithWidening)) {
            return type;
        }
        if (contextOwner instanceof TypeScriptVariable) {
            boolean isConst = ((TypeScriptVariable)contextOwner).isConst();
            if (type instanceof JSLiteralType) {
                return isConst || !((JSTypeWithWidening)type).allowWidening() ? (JSTypeWithWidening)type : ((JSTypeWithWidening)type).widen(false);
            }
            return new JSWidenType(type, isConst);
        }
        if (contextOwner instanceof JSArrayLiteralExpression || contextOwner instanceof JSProperty) {
            return new JSWidenType(type, new ExpectedTypeWidening(contextOwner));
        }
        if (type instanceof JSLiteralType) {
            return ((JSLiteralType)type).allowWidening() ? ((JSTypeWithWidening)type).widen(false) : type;
        }
        return new JSWidenType(type);
    }

    @NotNull
    private static JSType getTypeInConstContext(@NotNull JSType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(0);
        }
        if (original instanceof JSTupleType) {
            return JSWidenType.getReadonlyTupleType((JSTupleType)original);
        }
        if (original instanceof JSRecordType) {
            return JSWidenType.makePropsReadonly(original);
        }
        if (original instanceof JSLiteralType) {
            JSLiteralType jSLiteralType = ((JSLiteralType)original).copyWithAllowWidening(false);
            if (jSLiteralType == null) {
                JSWidenType.$$$reportNull$$$0(1);
            }
            return jSLiteralType;
        }
        if (original instanceof JSArrayType) {
            return new JSReadonlyArrayTypeImpl(((JSArrayType)original).getType(), original.getSource());
        }
        JSType jSType = original;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    @NotNull
    private static JSType getReadonlyTupleType(@NotNull JSTupleType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(3);
        }
        JSType jSType = JSCompositeTypeFactory.createTupleType(original.getSource(), original.getTypes(), original.isSourceStrict(), original.getOptionalStart(), true);
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    @NotNull
    private static JSType makePropsReadonly(@NotNull JSType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(5);
        }
        List<JSRecordType.TypeMember> originalMembers = ((JSRecordType)original).getTypeMembers();
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(originalMembers.size());
        boolean modified = false;
        for (JSRecordType.TypeMember member : originalMembers) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)ObjectUtils.tryCast((Object)member, JSRecordType.PropertySignature.class);
            if (propertySignature != null) {
                modified = true;
                members.add(new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getJSType(), propertySignature.isOptional(), true, member.getMemberSource()));
                continue;
            }
            members.add(member);
        }
        JSType jSType = modified ? new JSRecordTypeImpl(original.getSource(), members) : original;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(6);
        }
        return jSType;
    }

    @Contract(value="null -> false")
    public static boolean isConstContext(@Nullable PsiElement element) {
        PsiElement grandParent;
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getContext();
        if (parent instanceof TypeScriptCastExpression) {
            return ((TypeScriptCastExpression)parent).getType() instanceof TypeScriptConstType;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return JSWidenType.isConstContext(parent);
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return JSWidenType.isConstContext(parent);
        }
        JSProperty property = (JSProperty)ObjectUtils.coalesce((Object)((JSProperty)ObjectUtils.tryCast((Object)parent, JSProperty.class)), (Object)((JSProperty)ObjectUtils.tryCast((Object)element, JSProperty.class)));
        if (property != null && (grandParent = property.getContext()) instanceof JSObjectLiteralExpression) {
            return JSWidenType.isConstContext(grandParent);
        }
        if (parent instanceof JSSpreadExpression) {
            return JSWidenType.isConstContext(parent);
        }
        if (parent instanceof JSStringTemplateExpression) {
            return JSWidenType.isConstContext(parent);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTupleLikeType(@Nullable JSType type, boolean isTypeScript) {
        Ref isTuple;
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isSingleTypeAlias(type)) {
            type = type.substitute();
        }
        if (type instanceof JSUnionType) {
            isTuple = Ref.create((Object)false);
            for (JSType jsType2 : ((JSUnionType)type).getTypes()) {
                RecursionManager.doPreventingRecursion((Object)type.getResolvedTypeId(), (boolean)false, () -> {
                    isTuple.set((Object)JSWidenType.isTupleLikeType(jsType2, isTypeScript));
                    return true;
                });
                if (!((Boolean)isTuple.get()).booleanValue()) continue;
                return true;
            }
        }
        if (type instanceof JSTupleType) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type);
        }
        if (!isTypeScript || type instanceof JSUtilType) {
            return false;
        }
        if (type instanceof TypeScriptOverloadContextualType) {
            return true;
        }
        isTuple = Ref.create((Object)false);
        JSType finalType = type;
        RecursionManager.doPreventingRecursion((Object)type.getResolvedTypeId(), (boolean)false, () -> {
            isTuple.set((Object)finalType.asRecordType().hasProperty("0"));
            return true;
        });
        return (Boolean)isTuple.get();
    }

    @Nullable
    private static JSType widenMultiStatementReturnType(@NotNull JSFunctionItem function2, @NotNull JSUnionType returnType, @NotNull JSTypeSubstitutionContext context) {
        if (function2 == null) {
            JSWidenType.$$$reportNull$$$0(7);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(9);
        }
        JSType type = returnType.substitute(context);
        boolean prohibitWidening = false;
        if (type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(JSTypeUtils::containsLiteralTypes)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            return TypeScriptTypeRelations.subtypeReduction(JSTypeUtils.getApparentType(JSCompositeTypeImpl.optimizeTypeIfComposite(type)), (PsiElement)function2);
        }
        return TypeScriptTypeRelations.subtypeReduction(JSCompositeTypeImpl.optimizeTypeIfComposite(type), (PsiElement)function2);
    }

    @NotNull
    private static JSType widenOneStatementReturnType(@NotNull JSFunctionItem function2, @NotNull JSExpectedTypeKind kind, @NotNull JSType returnType, @NotNull JSTypeSubstitutionContext context) {
        JSType type;
        if (function2 == null) {
            JSWidenType.$$$reportNull$$$0(10);
        }
        if (kind == null) {
            JSWidenType.$$$reportNull$$$0(11);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(13);
        }
        boolean prohibitWidening = false;
        if (function2 instanceof JSFunctionExpression) {
            if (kind != JSExpectedTypeKind.CONTEXTUAL) {
                JSType jSType = returnType;
                if (jSType == null) {
                    JSWidenType.$$$reportNull$$$0(14);
                }
                return jSType;
            }
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((Object)function2), JSExpectedTypeKind.WIDENING);
            if (expectedType instanceof JSFunctionTypeImpl && JSTypeUtils.containsLiteralTypes(((JSFunctionTypeImpl)expectedType).getReturnType())) {
                prohibitWidening = true;
            }
        }
        if (!prohibitWidening && (type = returnType.substitute(context)) instanceof JSUnionType && JSTypeUtils.containsLiteralTypes(type)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            returnType = JSTypeUtils.getApparentType(returnType);
        }
        JSType jSType = returnType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    public JSWidenType(@NotNull JSType type, @NotNull Widening wideningFunction) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(16);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(17);
        }
        this(type, type.getSource(), wideningFunction);
    }

    private JSWidenType(@NotNull JSType type, boolean isConstVariable) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(18);
        }
        this(type, isConstVariable ? SimpleWidening.CONST_VARIABLE : SimpleWidening.INSTANCE);
    }

    private JSWidenType(@NotNull JSType type) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(19);
        }
        this(type, SimpleWidening.INSTANCE);
    }

    private JSWidenType(@NotNull JSType type, @NotNull JSTypeSource source2, @NotNull Widening wideningFunction) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(20);
        }
        if (source2 == null) {
            JSWidenType.$$$reportNull$$$0(21);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(22);
        }
        super(source2);
        this.myType = type instanceof JSWidenType && ((JSWidenType)type).getContextTypeProvider() == wideningFunction ? ((JSWidenType)type).getOriginalType() : type;
        this.myWideningFunction = wideningFunction;
    }

    public JSWidenType(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSWidenType.$$$reportNull$$$0(23);
        }
        if (inputStream == null) {
            JSWidenType.$$$reportNull$$$0(24);
        }
        super(source2);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source2, inputStream);
        boolean isConstVariable = JSTypeSerializer.readBoolean(inputStream);
        this.myWideningFunction = isConstVariable ? SimpleWidening.CONST_VARIABLE : SimpleWidening.INSTANCE;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSWidenType.$$$reportNull$$$0(25);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        assert (this.myWideningFunction instanceof SimpleWidening);
        JSTypeSerializer.writeBoolean(((SimpleWidening)this.myWideningFunction).myIsConstVariable, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSWidenType.$$$reportNull$$$0(26);
        }
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    public JSType distributeType() {
        JSType substitute = this.substitute();
        if (substitute != this && substitute instanceof JSDistributedType) {
            JSType jSType = ((JSDistributedType)((Object)substitute)).distributeType();
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(27);
            }
            return jSType;
        }
        JSWidenType jSWidenType = this;
        if (jSWidenType == null) {
            JSWidenType.$$$reportNull$$$0(28);
        }
        return jSWidenType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType jsType2;
        if (elementType == null) {
            JSWidenType.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSWidenType.$$$reportNull$$$0(30);
        }
        if ((jsType2 = this.substitute()) == this) {
            return true;
        }
        return jsType2.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType processed;
        if (childTransform == null) {
            JSWidenType.$$$reportNull$$$0(31);
        }
        if (newSource == null) {
            JSWidenType.$$$reportNull$$$0(32);
        }
        if ((processed = this.myType.transformTypeHierarchy(childTransform)) == this.myType) {
            JSWidenType jSWidenType = this;
            if (jSWidenType == null) {
                JSWidenType.$$$reportNull$$$0(33);
            }
            return jSWidenType;
        }
        if (processed instanceof JSLiteralType && this.myWideningFunction == SimpleWidening.INSTANCE) {
            JSType jSType = ((JSLiteralType)processed).widen(false);
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        return new JSWidenType(processed, this.myWideningFunction);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSWidenType.$$$reportNull$$$0(35);
        }
        return new JSWidenType(this.myType, source2, this.myWideningFunction);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(36);
        }
        JSWidenType rType = (JSWidenType)type;
        return this.myType.isEquivalentTo(rType.myType, context, allowResolve) && Objects.equals(this.myWideningFunction, rType.myWideningFunction);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myType, this.myWideningFunction);
    }

    @Override
    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(37);
        }
        return jSType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSWidenType.$$$reportNull$$$0(38);
        }
        if (builder == null) {
            JSWidenType.$$$reportNull$$$0(39);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder.append("(widen ");
            this.myType.buildTypeText(format, builder);
            builder.append(")");
            return;
        }
        JSType substitute = this.substitute();
        if (substitute == this) {
            substitute = this.myType;
        }
        substitute.buildTypeText(format, builder);
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(40);
        }
        return this.myWideningFunction.apply(this.myType, context);
    }

    @NotNull
    public Widening getContextTypeProvider() {
        Widening widening = this.myWideningFunction;
        if (widening == null) {
            JSWidenType.$$$reportNull$$$0(41);
        }
        return widening;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 9: 
            case 13: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideningFunction";
                break;
            }
            case 21: 
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInConstContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadonlyTupleType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makePropsReadonly";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "widenOneStatementReturnType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInConstContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 41: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReadonlyTupleType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makePropsReadonly";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "widenMultiStatementReturnType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "widenOneStatementReturnType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ReturnTypeWidening
    implements Widening {
        @NotNull
        private final JSFunctionItem myFunction;
        @NotNull
        private final JSExpectedTypeKind myKind;

        public ReturnTypeWidening(@NotNull JSFunctionItem function2, @NotNull JSExpectedTypeKind kind) {
            if (function2 == null) {
                ReturnTypeWidening.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ReturnTypeWidening.$$$reportNull$$$0(1);
            }
            this.myFunction = function2;
            this.myKind = kind;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context) {
            PsiElement sourceElement;
            if (original == null) {
                ReturnTypeWidening.$$$reportNull$$$0(2);
            }
            if ((sourceElement = original.getSourceElement()) == null) {
                return original;
            }
            PsiElement elContext = sourceElement.getContext();
            if (elContext instanceof JSReturnStatement || elContext instanceof JSFunction && ((JSFunction)elContext).isShorthandArrowFunction()) {
                return JSWidenType.widenOneStatementReturnType(this.myFunction, this.myKind, original, context);
            }
            if (original instanceof JSUnionType && sourceElement == this.myFunction) {
                return JSWidenType.widenMultiStatementReturnType(this.myFunction, (JSUnionType)original, context);
            }
            return original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReturnTypeWidening widening = (ReturnTypeWidening)o;
            return this.myFunction.equals(widening.myFunction) && this.myKind == widening.myKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myFunction, this.myKind});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ReturnTypeWidening";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ExpectedTypeWidening
    implements Widening {
        @NotNull
        private final PsiElement myElement;

        public ExpectedTypeWidening(@NotNull PsiElement element) {
            if (element == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, @NotNull JSTypeSubstitutionContext context) {
            if (original == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(1);
            }
            if (context == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(2);
            }
            if (JSWidenType.isConstContext(this.myElement)) {
                return JSWidenType.getTypeInConstContext(original);
            }
            if (this.myElement instanceof JSArrayLiteralExpression) {
                if (!(original instanceof JSTupleType)) {
                    return original;
                }
                JSType contextType = this.getContextType();
                original = ExpectedTypeWidening.widenTupleTypeNestedTypes(contextType, (JSTupleType)original, context, this.myElement);
                boolean isTypeScript = DialectDetector.isTypeScript(this.myElement);
                if (!isTypeScript && ContainerUtil.exists(((JSTupleType)original).getTypes(), ExpectedTypeWidening::isPropertyOwner)) {
                    return original;
                }
                return JSWidenType.isTupleLikeType(contextType, isTypeScript) ? original : ((JSTupleType)original).toArrayType(true);
            }
            JSType nested = original.substitute(context);
            if (nested == null) {
                return null;
            }
            if (!this.isWideningApplicable(nested)) {
                return nested;
            }
            JSType expectedType = this.getContextType();
            return expectedType instanceof TypeScriptOverloadContextualType ? nested : JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(nested, JSTypeUtils.getValuableType(expectedType));
        }

        private static boolean isPropertyOwner(@NotNull JSType type) {
            if (type == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(3);
            }
            if (type instanceof JSPsiBasedTypeOfType) {
                Object element = ((JSPsiBasedTypeOfType)type).getElement();
                return element instanceof JSObjectLiteralExpression;
            }
            return type instanceof JSRecordType || type instanceof JSPropertiesOwnerType;
        }

        @NotNull
        private static JSTupleType widenTupleTypeNestedTypes(@Nullable JSType arrayContextualType, @NotNull JSTupleType type, @NotNull JSTypeSubstitutionContext context, @NotNull PsiElement element) {
            if (type == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(4);
            }
            if (context == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(6);
            }
            if (arrayContextualType == null) {
                JSTupleType jSTupleType = type.transformTypes((el, i2) -> el instanceof JSWidenType ? el : JSTypeUtils.widenLiteralTypes(el, true));
                if (jSTupleType == null) {
                    ExpectedTypeWidening.$$$reportNull$$$0(7);
                }
                return jSTupleType;
            }
            JSTypeSource source2 = JSTypeSourceFactory.createTypeSource(element, true);
            JSTupleType jSTupleType = type.transformTypes((el, i2) -> {
                JSType from = ExpectedTypeEvaluator.getArrayElementTypeForIndex(arrayContextualType, i2, source2);
                return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(el, from == null ? null : context.substituteNested(from));
            });
            if (jSTupleType == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(8);
            }
            return jSTupleType;
        }

        private boolean isWideningApplicable(@NotNull JSType type) {
            if (type == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(9);
            }
            if (type instanceof JSLiteralType) {
                return ((JSLiteralType)type).allowWidening();
            }
            if (type instanceof JSEvaluableType) {
                return true;
            }
            if (type instanceof JSTypeImpl) {
                return ((JSTypeImpl)type).allowWidening() && ((JSTypeImpl)type).resolveType().isEnumLiteral();
            }
            if (type instanceof JSUnionOrIntersectionType) {
                return ((JSUnionOrIntersectionType)type).getTypes().stream().anyMatch(this::isWideningApplicable);
            }
            return false;
        }

        @Nullable
        private JSType getContextType() {
            JSExpectedTypeKind kind = JSExpectedTypeKind.WIDENING;
            if (this.myElement instanceof JSProperty) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSProperty)this.myElement, kind);
            }
            if (this.myElement instanceof JSExpression) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)this.myElement, kind);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpectedTypeWidening widening = (ExpectedTypeWidening)o;
            return this.myElement.equals(widening.myElement);
        }

        public int hashCode() {
            return Objects.hash(this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSWidenType$ExpectedTypeWidening";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ExpectedTypeWidening";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "widenTupleTypeNestedTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPropertyOwner";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "widenTupleTypeNestedTypes";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isWideningApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SimpleWidening
    implements Widening {
        private static final SimpleWidening INSTANCE = new SimpleWidening(false);
        private static final SimpleWidening CONST_VARIABLE = new SimpleWidening(true);
        private final boolean myIsConstVariable;

        private SimpleWidening(boolean isConstVariable) {
            this.myIsConstVariable = isConstVariable;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context) {
            PsiElement element;
            if (original == null) {
                SimpleWidening.$$$reportNull$$$0(0);
            }
            if ((element = original.getSourceElement()) == null) {
                return original;
            }
            JSType nested = original.substitute(context);
            if (nested == null) {
                return null;
            }
            if (nested instanceof JSCodeBasedType) {
                return original;
            }
            if (JSWidenType.isConstContext(nested.getSourceElement())) {
                return JSWidenType.getTypeInConstContext(nested);
            }
            if (nested instanceof JSTupleType && ((JSTupleType)nested).allowWidening()) {
                JSTupleType tupleType = ((JSTupleType)nested).transformTypes((el, i2) -> JSTypeUtils.widenLiteralTypes(el, true));
                nested = tupleType.toArrayType(true);
            }
            if (this.myIsConstVariable && !(original instanceof JSDestructuringTypeImpl)) {
                return nested;
            }
            JSType widen = JSTypeUtils.getApparentType(JSTypeUtils.widenLiteralTypes(nested, true));
            if (widen instanceof JSFreshObjectLiteralType) {
                widen = ((JSFreshObjectLiteralType)widen).removeFreshness();
            }
            return widen;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/javascript/psi/types/JSWidenType$SimpleWidening", "apply"));
        }
    }

    static interface Widening {
        @Nullable
        public JSType apply(@NotNull JSType var1, JSTypeSubstitutionContext var2);
    }
}

