/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyIndexedAccessType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSType.CompositeStructure {
    @NotNull
    private final JSType myQualifierType;
    @Nullable
    private final JSType myIndexExpressionType;

    public JSApplyIndexedAccessType(@NotNull JSType qualifierType, @Nullable JSType indexExpressionType, @NotNull JSTypeSource source2) {
        if (qualifierType == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(1);
        }
        super(source2);
        this.myQualifierType = qualifierType;
        this.myIndexExpressionType = indexExpressionType;
    }

    public JSApplyIndexedAccessType(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(3);
        }
        super(source2);
        this.myQualifierType = JSTypeSerializer.TYPE_SERIALIZER.read(source2, inputStream);
        this.myIndexExpressionType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source2, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myQualifierType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myIndexExpressionType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(5);
        }
        this.myQualifierType.accept(visitor);
        if (this.myIndexExpressionType != null) {
            this.myIndexExpressionType.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(6);
        }
        return new JSApplyIndexedAccessType(this.myQualifierType, this.myIndexExpressionType, source2);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myQualifierType, this.myIndexExpressionType);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(7);
        }
        return this.myQualifierType.isEquivalentTo(((JSApplyIndexedAccessType)type).myQualifierType, context, allowResolve) && (this.myIndexExpressionType == null ? ((JSApplyIndexedAccessType)type).myIndexExpressionType == null : this.myIndexExpressionType.isEquivalentTo(((JSApplyIndexedAccessType)type).myIndexExpressionType, context, allowResolve));
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(8);
        }
        if (newSource == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(9);
        }
        JSType newQualifierType = this.myQualifierType.transformTypeHierarchy(childTransform);
        JSType newArgumentType = JSTypeUtils.transformTypeHierarchySafe(this.myIndexExpressionType, childTransform);
        if (newQualifierType == this.myQualifierType && this.myIndexExpressionType == newArgumentType) {
            JSApplyIndexedAccessType jSApplyIndexedAccessType = this;
            if (jSApplyIndexedAccessType == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(10);
            }
            return jSApplyIndexedAccessType;
        }
        return new JSApplyIndexedAccessType(newQualifierType, newArgumentType, newSource);
    }

    @NotNull
    public JSType getQualifierType() {
        JSType jSType = this.myQualifierType;
        if (jSType == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSType jsonComponentType;
        if (evaluateContext == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(12);
        }
        JSType qualifierType = this.getQualifierType();
        String propertyName = this.getIndexExpressionAsPropertyName();
        if (propertyName != null) {
            return new JSEvaluationResultElement(new JSQualifiedReferenceType(propertyName, qualifierType, this.getSource()), false, evaluateContext);
        }
        if (this.myIndexExpressionType instanceof JSSymbolType) {
            JSEvaluationResultElement jSEvaluationResultElement = JSApplyIndexedAccessType.getTaskForUnknownElement(this.getSourceElement(), evaluateContext);
            if (jSEvaluationResultElement == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(13);
            }
            return jSEvaluationResultElement;
        }
        JSType substitutedQualifier = null;
        if (!(qualifierType instanceof JSTupleType)) {
            substitutedQualifier = qualifierType.substitute();
        }
        JSTupleType tupleType = qualifierType instanceof JSTupleType ? (JSTupleType)qualifierType : (substitutedQualifier instanceof JSTupleType ? (JSTupleType)substitutedQualifier : null);
        Integer index = JSApplyIndexedAccessType.getNumberLiteralTypeValue(this.myIndexExpressionType);
        if (tupleType != null && index != null && tupleType.hasTypeByIndex(index)) {
            JSType typeByIndex = tupleType.getTypeByIndex(index);
            if (typeByIndex != null) {
                JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(typeByIndex, evaluateContext);
                if (jSEvaluationResultElement == null) {
                    JSApplyIndexedAccessType.$$$reportNull$$$0(14);
                }
                return jSEvaluationResultElement;
            }
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(15);
            }
            return jSEvaluationTaskList;
        }
        if (substitutedQualifier == null) {
            substitutedQualifier = qualifierType.substitute();
        }
        if (substitutedQualifier instanceof JsonElementType && (jsonComponentType = ((JsonElementType)substitutedQualifier).getComponentType(this.myIndexExpressionType, this.getSourceElement())) != null) {
            JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(jsonComponentType, evaluateContext);
            if (jSEvaluationResultElement == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(16);
            }
            return jSEvaluationResultElement;
        }
        JSType componentType = JSTypeUtils.getIndexableComponentType(substitutedQualifier);
        if (componentType == null && (this.isTypeScript() || this.myIndexExpressionType != null)) {
            componentType = JSApplyIndexedAccessType.getComponentTypeFromIndexSignature(substitutedQualifier, this.myIndexExpressionType);
        }
        if (componentType != null) {
            JSType optimizeTypeIfComposite = componentType.substitute();
            JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(optimizeTypeIfComposite, evaluateContext);
            if (jSEvaluationResultElement == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(17);
            }
            return jSEvaluationResultElement;
        }
        JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
        if (jSEvaluationTaskList == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(18);
        }
        return jSEvaluationTaskList;
    }

    @Nullable
    private String getIndexExpressionAsPropertyName() {
        if (this.myIndexExpressionType instanceof JSSymbolType) {
            PsiElement context;
            PsiElement element = this.myIndexExpressionType.getSourceElement();
            if (element instanceof JSTypeDeclaration && (context = element.getContext()) instanceof JSQualifiedNamedElement) {
                JSQualifiedName namespace = ((JSQualifiedNamedElement)context).getNamespace();
                if (namespace != null && namespace.getParent() == null && "SymbolConstructor".equals(namespace.getName())) {
                    String name = ((JSQualifiedNamedElement)context).getName();
                    return "[Symbol." + name + "]";
                }
                return "[" + ((JSQualifiedNamedElement)context).getQualifiedName() + "]";
            }
        } else if (this.myIndexExpressionType instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)this.myIndexExpressionType).getLiteral();
        }
        return null;
    }

    @Nullable
    private static Integer getNumberLiteralTypeValue(@Nullable JSType type) {
        int intValue;
        BigInteger literal;
        if (type instanceof JSNumberLiteralTypeImpl) {
            Double literal2 = ((JSNumberLiteralTypeImpl)type).getLiteral();
            int intValue2 = literal2.intValue();
            if ((double)intValue2 == literal2) {
                return intValue2;
            }
        } else if (type instanceof JSBigIntLiteralTypeImpl && (literal = ((JSBigIntLiteralTypeImpl)type).getLiteral()).equals(BigInteger.valueOf(intValue = literal.intValue()))) {
            return intValue;
        }
        return null;
    }

    @Nullable
    public static JSType getComponentTypeFromIndexSignature(@NotNull JSType qualifierType, @Nullable JSType argumentType) {
        if (qualifierType == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(19);
        }
        JSRecordType recordType = qualifierType.asRecordType();
        ArrayList indexSignatures = new ArrayList();
        ContainerUtil.addIfNotNull(indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING));
        ContainerUtil.addIfNotNull(indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC));
        if (indexSignatures.isEmpty()) {
            return null;
        }
        PsiElement argumentSource = argumentType != null ? argumentType.getSourceElement() : null;
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(argumentSource);
        for (JSRecordType.IndexSignature signature : indexSignatures) {
            if (!JSResolveUtil.isAssignableJSType(signature.getMemberParameterType(), argumentType, processingContext)) continue;
            return signature.getMemberType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyIndexedAccessType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyIndexedAccessType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getComponentTypeFromIndexSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

