/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSStubBasedExpressionType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType {
    private static final IStubElementType<?, ?>[] ELEMENT_TYPES = new IStubElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, JSStubElementTypes.FUNCTION_EXPRESSION, JSStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION, FlowJSElementTypes.FLOW_JS_FUNCTION_EXPRESSION, ES6StubElementTypes.CLASS_EXPRESSION, FlowJSElementTypes.FLOW_JS_CLASS_EXPRESSION, JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION};
    private static boolean ourAssertInTestModeOnCalculatingAnchor = true;
    @NotNull
    private final JSExpressionAnchor myAnchor;

    private JSStubBasedExpressionType(@NotNull StubBasedPsiElement<?> element, @NotNull JSTypeSource source2) {
        if (element == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(1);
        }
        super(source2);
        this.myAnchor = new JSExpressionPsiAnchor(element);
    }

    public JSStubBasedExpressionType(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(3);
        }
        super(source2);
        int stubIndex = JSTypeSerializer.readInt(inputStream);
        int elementTypeIndex = JSTypeSerializer.readInt(inputStream);
        this.myAnchor = new JSExpressionStubAnchor(stubIndex, elementTypeIndex, this.getScope());
    }

    private JSStubBasedExpressionType(@NotNull JSExpressionAnchor anchor, @NotNull JSTypeSource source2) {
        if (anchor == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(4);
        }
        if (source2 == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(5);
        }
        super(source2);
        this.myAnchor = anchor;
    }

    @NotNull
    public static JSStubBasedExpressionType forExpression(@NotNull StubBasedPsiElement<?> expression) {
        if (expression == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(6);
        }
        JSStubBasedExpressionType jSStubBasedExpressionType = (JSStubBasedExpressionType)CachedValuesManager.getCachedValue(expression, () -> {
            JSStubBasedExpressionType type = new JSStubBasedExpressionType(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            return new CachedValueProvider.Result((Object)type, new Object[]{expression});
        });
        if (jSStubBasedExpressionType == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(7);
        }
        return jSStubBasedExpressionType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(8);
        }
        super.serialize(outputStream);
        if (this.myAnchor instanceof JSExpressionPsiAnchor) {
            ((JSExpressionPsiAnchor)this.myAnchor).assertStubIndexCached();
        }
        JSTypeSerializer.writeInt(this.myAnchor.getStubIndex(), outputStream);
        JSTypeSerializer.writeInt(this.myAnchor.getElementTypeIndex(), outputStream);
    }

    @Override
    protected int hashCodeImpl() {
        JSExpression expression = this.findAssociatedExpression();
        return expression == null ? 0 : expression.hashCode();
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(9);
        }
        return Objects.equals(this.findAssociatedExpression(), ((JSStubBasedExpressionType)type).findAssociatedExpression());
    }

    @Override
    @NotNull
    protected JSStubBasedExpressionType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(10);
        }
        JSExpressionAnchor newAnchor = this.myAnchor instanceof JSExpressionStubAnchor ? new JSExpressionStubAnchor(this.myAnchor.getStubIndex(), this.myAnchor.getElementTypeIndex(), source2.getScope()) : this.myAnchor;
        return new JSStubBasedExpressionType(newAnchor, source2);
    }

    @Nullable
    public JSExpression findAssociatedExpression() {
        return this.myAnchor.findAssociatedExpression();
    }

    public void applyMappings(@NotNull Map<StubBasedPsiElement<?>, ObjectStubBase<?>> mappings) {
        if (mappings == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(11);
        }
        if (this.myAnchor instanceof JSExpressionPsiAnchor) {
            ((JSExpressionPsiAnchor)this.myAnchor).applyMappings(mappings);
        }
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSExpression expression;
        if (evaluateContext == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(12);
        }
        if ((expression = this.findAssociatedExpression()) == null) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSStubBasedExpressionType.$$$reportNull$$$0(13);
            }
            return jSEvaluationTaskList;
        }
        JSEvaluateContext newContext = evaluateContext.withCombinedStrictness(!JSTypeEvaluator.isEmptyJSObjectLiteral(expression));
        JSTypeEvaluator evaluator = JSTypeEvaluator.createEvaluator((PsiElement)expression, newContext);
        evaluator.doEvaluateTypesStubSafely(expression);
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(Collections.unmodifiableList(evaluator.getResult().getResults()));
        if (jSEvaluationTask == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(14);
        }
        return jSEvaluationTask;
    }

    @TestOnly
    public static void setNoAssertInTestModeOnCalculatingAnchor(@NotNull Disposable testRootDisposable) {
        if (testRootDisposable == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(15);
        }
        final boolean previousValue = ourAssertInTestModeOnCalculatingAnchor;
        ourAssertInTestModeOnCalculatingAnchor = false;
        Disposer.register((Disposable)testRootDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertInTestModeOnCalculatingAnchor = previousValue;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRootDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forExpression";
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setNoAssertInTestModeOnCalculatingAnchor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JSExpressionStubAnchor
    implements JSExpressionAnchor {
        private final int myStubIndex;
        private final int myElementTypeIndex;
        @Nullable
        private SoftReference<StubBasedPsiElement<?>> myRestoredElement;
        @Nullable
        PsiFile myFile;

        private JSExpressionStubAnchor(int stubIndex, int elementTypeIndex, @Nullable PsiFile file2) {
            this.myStubIndex = stubIndex;
            this.myElementTypeIndex = elementTypeIndex;
            this.myFile = file2;
        }

        @Override
        @Nullable
        public JSExpression findAssociatedExpression() {
            JSExpression restored = (JSExpression)SoftReference.deref(this.myRestoredElement);
            if (restored != null) {
                return restored;
            }
            PsiFile scope = this.myFile;
            if (scope == null) {
                return null;
            }
            if (!(scope instanceof PsiFileWithStubSupport)) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("Not PsiFileWithStubSupport:" + scope.getClass());
                return null;
            }
            IStubElementType<?, ?> type = ELEMENT_TYPES[this.myElementTypeIndex];
            PsiElement element = PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)((PsiFileWithStubSupport)scope), (int)this.myStubIndex, type, (boolean)false);
            if (!(element instanceof JSExpression)) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("Not JSExpression: " + element + " expected element type: " + type.getExternalId() + " file: " + scope.getName() + " index: " + this.myStubIndex);
                return null;
            }
            this.myRestoredElement = new SoftReference((Object)((StubBasedPsiElement)element));
            return (JSExpression)element;
        }

        @Override
        public int getStubIndex() {
            return this.myStubIndex;
        }

        @Override
        public int getElementTypeIndex() {
            return this.myElementTypeIndex;
        }
    }

    private static final class JSExpressionPsiAnchor
    implements JSExpressionAnchor {
        @NotNull
        private final StubBasedPsiElement<?> myElement;
        private int myCachedStubIndex;
        private int myCachedElementTypeIndex;

        private JSExpressionPsiAnchor(@NotNull StubBasedPsiElement<?> element) {
            if (element == null) {
                JSExpressionPsiAnchor.$$$reportNull$$$0(0);
            }
            this.myCachedStubIndex = -1;
            this.myCachedElementTypeIndex = -1;
            this.myElement = element;
            this.cacheStubIndexIfAvailable(element);
        }

        private void cacheStubIndexIfAvailable(@NotNull StubBasedPsiElement<?> element) {
            StubElement liveStub;
            if (element == null) {
                JSExpressionPsiAnchor.$$$reportNull$$$0(1);
            }
            StubElement stubElement = liveStub = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getGreenStub() : element.getStub();
            if (liveStub != null) {
                this.myCachedStubIndex = ((StubBase)liveStub).getStubId();
            }
        }

        @Override
        @NotNull
        public JSExpression findAssociatedExpression() {
            JSExpression jSExpression = (JSExpression)this.myElement;
            if (jSExpression == null) {
                JSExpressionPsiAnchor.$$$reportNull$$$0(2);
            }
            return jSExpression;
        }

        @Override
        public int getStubIndex() {
            this.cacheStubIndexIfAvailable(this.myElement);
            int stubIndex = this.myCachedStubIndex;
            if (stubIndex == -1) {
                stubIndex = PsiAnchor.calcStubIndex(this.myElement);
                if (stubIndex == -1) {
                    throw new IllegalArgumentException(this.myElement.getElementType().getExternalId() + " not found");
                }
                this.myCachedStubIndex = stubIndex;
            }
            return stubIndex;
        }

        @Override
        public int getElementTypeIndex() {
            int elementTypeIndex = this.myCachedElementTypeIndex;
            if (elementTypeIndex == -1) {
                elementTypeIndex = ArrayUtil.indexOf((Object[])ELEMENT_TYPES, (Object)this.myElement.getElementType());
                if (elementTypeIndex == -1) {
                    throw new IllegalArgumentException(this.myElement.getElementType().getExternalId() + " is not supported");
                }
                this.myCachedElementTypeIndex = elementTypeIndex;
            }
            return elementTypeIndex;
        }

        private void applyMappings(@NotNull Map<StubBasedPsiElement<?>, ObjectStubBase<?>> mappings) {
            if (mappings == null) {
                JSExpressionPsiAnchor.$$$reportNull$$$0(3);
            }
            if (this.myCachedStubIndex == -1) {
                ObjectStubBase<?> stub = mappings.get(this.myElement);
                if (stub == null) {
                    Logger.getInstance(JSStubBasedExpressionType.class).error("Mapping was not found");
                } else {
                    if (ApplicationManager.getApplication().isUnitTestMode() && stub.getStubType() != this.myElement.getElementType()) {
                        Logger.getInstance(JSStubBasedExpressionType.class).error("Mappings are invalid: stub type = " + stub.getStubType() + ", myElement type = " + this.myElement.getElementType());
                    }
                    this.myCachedStubIndex = stub.getStubId();
                }
            }
        }

        private void assertStubIndexCached() {
            IStubFileElementType fileElementType;
            PsiFile scope;
            if (!ApplicationManager.getApplication().isUnitTestMode() || !ourAssertInTestModeOnCalculatingAnchor) {
                return;
            }
            this.cacheStubIndexIfAvailable(this.myElement);
            if (this.myCachedStubIndex == -1 && (scope = this.myElement.getContainingFile()) instanceof PsiFileImpl && (fileElementType = ((PsiFileImpl)scope).getElementTypeForStubBuilder()) != null && fileElementType.getBuilder() instanceof JSFileStubBuilder) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("myStubIndex wasn't set");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType$JSExpressionPsiAnchor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType$JSExpressionPsiAnchor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAssociatedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheStubIndexIfAvailable";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyMappings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface JSExpressionAnchor {
        @Nullable
        public JSExpression findAssociatedExpression();

        public int getStubIndex();

        public int getElementTypeIndex();
    }
}

