/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSChainedTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNarrowTypeByArrayMutationOperation
extends JSChainedTypeOperationBase {
    @NotNull
    private final List<JSType> myArguments;
    @Nullable
    private final JSType myIndexExpressionType;
    @Nullable
    private final JSType myInitializerType;

    public JSNarrowTypeByArrayMutationOperation(@NotNull JSTypeOperation prev, @Nullable JSCallExpression element, @Nullable JSExpression indexExpression, @Nullable JSExpression initializer) {
        if (prev == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(0);
        }
        super(prev);
        this.myArguments = element != null ? JSNarrowTypeByArrayMutationOperation.getArgumentTypes(element) : ContainerUtil.emptyList();
        this.myIndexExpressionType = indexExpression != null ? JSTypeGuardUtil.getOperationType(indexExpression) : null;
        this.myInitializerType = initializer != null ? JSTypeGuardUtil.getOperationType(initializer) : null;
    }

    @NotNull
    private static List<JSType> getArgumentTypes(@NotNull JSCallExpression expression) {
        Object[] arguments;
        if (expression == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(1);
        }
        if ((arguments = expression.getArguments()).length == 0) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List list3 = ContainerUtil.map((Object[])arguments, JSTypeGuardUtil::getOperationType);
        if (list3 == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType prevType) {
        JSType initializerType;
        JSType indexType;
        JSType unwrapped;
        if (context == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(4);
        }
        if (prevType == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(5);
        }
        if (!((unwrapped = JSTypeUtils.unwrapType(prevType)) instanceof JSArrayType) || !context.isEvolvingArrayType(unwrapped)) {
            JSType jSType = prevType;
            if (jSType == null) {
                JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        JSArrayType arrayType = (JSArrayType)unwrapped;
        JSType startType = arrayType.getType();
        if (startType == null) {
            startType = JSAnyType.get(JSTypeSourceFactory.createTypeSource(context.getContextElement(), true));
        }
        if (!this.myArguments.isEmpty()) {
            List arguments = ContainerUtil.mapNotNull(this.myArguments, el -> context.expandOperationType((JSType)el));
            JSType currentType = startType;
            for (JSType argument : arguments) {
                currentType = JSNarrowTypeByArrayMutationOperation.addEvolvingArrayElementType(context, currentType, argument);
            }
            JSType jSType = currentType == startType ? arrayType : context.getEvolvingArrayType(currentType);
            if (jSType == null) {
                JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (this.myIndexExpressionType != null && this.myInitializerType != null && (indexType = context.expandOperationType(this.myIndexExpressionType)) instanceof JSNumberType && (initializerType = context.expandOperationType(this.myInitializerType)) != null) {
            JSType type = JSNarrowTypeByArrayMutationOperation.addEvolvingArrayElementType(context, startType, initializerType);
            JSType jSType = type == startType ? arrayType : context.getEvolvingArrayType(type);
            if (jSType == null) {
                JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType jSType = prevType;
        if (jSType == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    private static JSType addEvolvingArrayElementType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType currentParameter, @Nullable JSType type) {
        if (context == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(10);
        }
        if (currentParameter == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JSType jSType = currentParameter;
            if (jSType == null) {
                JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        JSType baseType = JSTypeGuardUtil.getBaseTypeOfLiteralType(type);
        JSType jSType = JSTypeGuardUtil.getUnionType((Collection<? extends JSType>)ContainerUtil.immutableList((Object[])new JSType[]{currentParameter, baseType}), context.getDefaultTypeSource());
        if (jSType == null) {
            JSNarrowTypeByArrayMutationOperation.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByArrayMutationOperation";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByArrayMutationOperation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addEvolvingArrayElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypes";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addEvolvingArrayElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

