/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSProjectUtil {
    public static boolean isInLibrary(@NotNull PsiElement element) {
        JSClass jsClass;
        if (element == null) {
            JSProjectUtil.$$$reportNull$$$0(0);
        }
        if ((jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class, (boolean)false)) != null && JSResolveUtil.isObjectClass(jsClass)) {
            return true;
        }
        return JSProjectUtil.isInLibrary(element.getContainingFile());
    }

    public static boolean isInLibrary(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        if (file2.getContext() != null) {
            file2 = file2.getContext().getContainingFile();
        }
        if (file2 == null) {
            return false;
        }
        VirtualFile vFile = file2.getOriginalFile().getVirtualFile();
        return JSProjectUtil.isInLibrary(vFile, file2.getProject());
    }

    public static boolean isInLibrary(@Nullable VirtualFile vFile, @NotNull Project project) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(1);
        }
        if (vFile == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInLibrary(vFile);
    }

    @Nullable
    public static ScriptingFrameworkDescriptor detectFramework(@NotNull String url) {
        String baseKey;
        if (url == null) {
            JSProjectUtil.$$$reportNull$$$0(2);
        }
        if ((baseKey = JSDocumentationUtils.getBaseKey(url)) == null) {
            return null;
        }
        String name = JSExternalLibraryDocBundle.getLibraryName(baseKey);
        if (name == null) {
            return null;
        }
        String versionMatcher = JSExternalLibraryDocBundle.getVersionMatcher(baseKey);
        String version = null;
        if (versionMatcher != null && url.matches("^.*(" + versionMatcher + ").*$")) {
            version = url.replaceFirst("^.*(" + versionMatcher + ").*$", "$1");
        }
        return new ScriptingFrameworkDescriptor(name, version);
    }

    @Nullable
    public static VirtualFile findFileUpToContentRoot(@NotNull Project project, @NotNull VirtualFile fileOrDir, String ... names) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(3);
        }
        if (fileOrDir == null) {
            JSProjectUtil.$$$reportNull$$$0(4);
        }
        if (names == null) {
            JSProjectUtil.$$$reportNull$$$0(5);
        }
        Ref result2 = new Ref();
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            for (String name : names) {
                VirtualFile child = directory.findChild(name);
                if (child == null || child.isDirectory() || !child.isValid()) continue;
                result2.set((Object)child);
                return false;
            }
            return true;
        }));
        return (VirtualFile)result2.get();
    }

    public static VirtualFile @NotNull [] findAllFilesUpToContentRoot(@NotNull Project project, @NotNull VirtualFile fileOrDir, String ... names) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(6);
        }
        if (fileOrDir == null) {
            JSProjectUtil.$$$reportNull$$$0(7);
        }
        if (names == null) {
            JSProjectUtil.$$$reportNull$$$0(8);
        }
        VirtualFile[] results = new VirtualFile[names.length];
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            boolean hasNull = false;
            for (int i2 = 0; i2 < names.length; ++i2) {
                VirtualFile child;
                if (results[i2] == null && (child = directory.findChild(names[i2])) != null && !child.isDirectory() && child.isValid()) {
                    results[i2] = child;
                }
                hasNull = hasNull || results[i2] == null;
            }
            return hasNull;
        }));
        if (results == null) {
            JSProjectUtil.$$$reportNull$$$0(9);
        }
        return results;
    }

    public static boolean processDirectoriesUpToContentRoot(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> directoryProcessor) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            JSProjectUtil.$$$reportNull$$$0(11);
        }
        if (directoryProcessor == null) {
            JSProjectUtil.$$$reportNull$$$0(12);
        }
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile dir;
            if (project.isDisposed()) {
                return true;
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return true;
            }
            VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
            while (dir != null && contentRoot != null) {
                if (!directoryProcessor.process((Object)dir)) {
                    return false;
                }
                if (dir.equals(contentRoot)) {
                    if ((dir = dir.getParent()) == null) {
                        return true;
                    }
                    contentRoot = fileIndex.getContentRootForFile(dir, false);
                    continue;
                }
                dir = dir.getParent();
            }
            return false;
        });
    }

    @Nullable
    public static <T> T processDirectoriesUpToContentRootAndFindFirst(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Function<? super VirtualFile, T> directoryProcessor) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(13);
        }
        if (fileOrDir == null) {
            JSProjectUtil.$$$reportNull$$$0(14);
        }
        if (directoryProcessor == null) {
            JSProjectUtil.$$$reportNull$$$0(15);
        }
        Ref ref = Ref.create();
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)file2 -> {
            Object value = directoryProcessor.fun(file2);
            ref.set(value);
            return value == null;
        }));
        return (T)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSProjectUtil";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSProjectUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilesUpToContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFileUpToContentRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAllFilesUpToContentRoot";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoriesUpToContentRoot";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoriesUpToContentRootAndFindFirst";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

