/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    @NlsContexts.DialogTitle
    @NotNull
    private final String myRefactoringName;
    private final @NlsContexts.DialogMessage @NotNull String myCannotRefactorReason;

    public BaseJSRefactoringHandler(@NotNull @NlsContexts.DialogTitle String refactoringName, @NlsContexts.DialogMessage @NotNull String cannotRefactorReason) {
        if (refactoringName == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (cannotRefactorReason == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(1);
        }
        this.myRefactoringName = refactoringName;
        this.myCannotRefactorReason = cannotRefactorReason;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element instanceof JSFile) {
                element = JSResolveUtil.getXmlBackedClass((JSFile)element);
            }
            if (element == null || element instanceof PsiFile) {
                if (element != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element)) {
                    this.invoke(project, new PsiElement[]{XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element)}, dataContext);
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)this.myCannotRefactorReason), (String)this.myRefactoringName, null);
                }
                return;
            }
            if (element.getNode().getElementType() == JSElementTypes.IMPLEMENTS_LIST && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)element.getContainingFile())) {
                element = JSResolveUtil.getXmlBackedClass((JSFile)element.getContainingFile());
            }
            if (!JSRefactoringUtil.checkReadOnlyStatus(element, editor, this.myRefactoringName)) {
                return;
            }
            if (JSUtils.isMember(element) || element instanceof JSClass) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    @Nullable
    protected static JSClass getClass(PsiElement element) {
        if (element instanceof JSClass) {
            return (JSClass)element;
        }
        if (element instanceof JSFile) {
            return JSPsiImplUtils.findClass((JSFile)element);
        }
        if (element instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element);
        }
        return JSUtils.getMemberContainingClass(element);
    }

    protected boolean checkEcma(PsiElement element, Editor editor) {
        if (!BaseJSRefactoringHandler.doCheckEcma(element)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JavaScriptBundle.message("error.not.available.in.javascript.code", this.myRefactoringName), (String)this.myRefactoringName, null);
            return false;
        }
        return true;
    }

    public static boolean doCheckEcma(PsiElement element) {
        if (element instanceof XmlBackedJSClassImpl) {
            return JavaScriptSupportLoader.isFlexMxmFile(element.getContainingFile());
        }
        if (element instanceof XmlFile) {
            return JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element);
        }
        return element.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cannotRefactorReason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/BaseJSRefactoringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

