/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FormatFixer {
    private static final Logger LOG = Logger.getInstance((String)FormatFixer.class.getName());
    private final RangeMarker myRangeMarker;
    private final PsiFile myFile;
    private final Document myDocument;
    private final boolean myIsReformat;
    private boolean myFreezeRange;

    public static FormatFixer create(@NotNull PsiFile file2, @NotNull TextRange possibleRange, @NotNull Mode mode) {
        if (file2 == null) {
            FormatFixer.$$$reportNull$$$0(0);
        }
        if (possibleRange == null) {
            FormatFixer.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            FormatFixer.$$$reportNull$$$0(2);
        }
        Document document2 = file2.getViewProvider().getDocument();
        assert (document2 != null) : "Should be invoked only when having a document";
        return FormatFixer.create(file2, possibleRange, document2, mode);
    }

    public static FormatFixer create(@NotNull PsiFile file2, @NotNull TextRange possibleRange, @NotNull Document document2, @NotNull Mode mode) {
        if (file2 == null) {
            FormatFixer.$$$reportNull$$$0(3);
        }
        if (possibleRange == null) {
            FormatFixer.$$$reportNull$$$0(4);
        }
        if (document2 == null) {
            FormatFixer.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            FormatFixer.$$$reportNull$$$0(6);
        }
        if (!file2.isValid()) {
            String detail;
            try {
                detail = " with text: '" + possibleRange.substring(file2.getText()) + "'";
            }
            catch (StringIndexOutOfBoundsException e) {
                detail = " with invalid range: " + possibleRange;
            }
            LOG.error("invalid file: " + file2.getName() + detail);
        }
        int reformatRangeStart = possibleRange.getStartOffset();
        int reformatRangeEnd = possibleRange.getEndOffset();
        CharSequence text = document2.getCharsSequence();
        if (mode == Mode.ReformatExactRange) {
            FormatFixer fixer = new FormatFixer(true, file2, document2, reformatRangeStart, reformatRangeEnd);
            fixer.myFreezeRange = true;
            return fixer;
        }
        if (mode == Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact) {
            reformatRangeStart = document2.getLineStartOffset(document2.getLineNumber(reformatRangeStart));
            reformatRangeEnd = document2.getLineEndOffset(document2.getLineNumber(reformatRangeEnd - 1));
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else if (mode == Mode.FirstLinebreak) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t") + 1;
            }
            if ((reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t")) < text.length() - 1 && text.charAt(reformatRangeEnd) == '\n') {
                ++reformatRangeEnd;
            }
        } else if (mode == Mode.Reformat) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t\n") + 1;
            }
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else if (mode == Mode.FollowingWhitespace) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t") + 1;
            }
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else {
            LOG.error(String.valueOf((Object)mode));
        }
        return new FormatFixer(mode == Mode.Reformat, file2, document2, reformatRangeStart, reformatRangeEnd);
    }

    private FormatFixer(boolean isReformat, PsiFile file2, Document document2, int reformatRangeStart, int reformatRangeEnd) {
        this.myIsReformat = isReformat;
        PsiElement context = file2.getContext();
        if (context != null) {
            TextRange range = InjectedLanguageManager.getInstance((Project)file2.getProject()).injectedToHost((PsiElement)file2, new TextRange(reformatRangeStart, reformatRangeEnd));
            file2 = context.getContainingFile();
            document2 = file2.getViewProvider().getDocument();
            reformatRangeStart = range.getStartOffset();
            reformatRangeEnd = range.getEndOffset();
        }
        assert (document2 != null);
        this.myRangeMarker = document2.createRangeMarker(reformatRangeStart, reformatRangeEnd);
        this.myDocument = document2;
        FileViewProvider viewProvider = file2.getViewProvider();
        this.myFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static FormatFixer create(PsiElement from, PsiElement to, Mode mode) {
        PsiFile file2 = from.getContainingFile();
        LOG.assertTrue(file2 == to.getContainingFile());
        return FormatFixer.create(file2, from.getTextRange().union(to.getTextRange()), mode);
    }

    public static FormatFixer create(PsiElement element, Mode mode) {
        return FormatFixer.create(element, element, mode);
    }

    public void fixFormat() {
        int changeEnd;
        Project project = this.myFile.getProject();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(this.myDocument);
        if (!this.myRangeMarker.isValid()) {
            return;
        }
        int changeStart = this.myRangeMarker.getStartOffset();
        if (changeStart >= (changeEnd = Math.min(this.myRangeMarker.getEndOffset(), this.myDocument.getTextLength()))) {
            return;
        }
        if (this.myIsReformat) {
            if (!this.myFreezeRange) {
                changeEnd = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)changeEnd, (String)" \t\n");
            }
            CodeStyleManager.getInstance((Project)project).reformatText(this.myFile, changeStart, changeEnd);
        } else {
            int start;
            int n = start = changeStart > 0 ? CharArrayUtil.shiftBackward((CharSequence)this.myDocument.getCharsSequence(), (int)(changeStart - 1), (String)" \t\n") + 1 : changeStart;
            if (start < changeStart && this.myDocument.getCharsSequence().charAt(start) == '\n') {
                ++start;
            }
            int end = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)changeEnd, (String)" \t\n");
            RangeMarker widerRange = this.myDocument.createRangeMarker(start, end);
            int newlinesBeforeRange = StringUtil.countNewLines((CharSequence)this.myDocument.getCharsSequence().subSequence(start, changeStart));
            int newlinesAfterRange = StringUtil.countNewLines((CharSequence)this.myDocument.getCharsSequence().subSequence(changeEnd, end));
            FormatFixer.doReformat(this.myFile, changeStart, changeEnd);
            RangeMarker rangeMarker = this.myRangeMarker;
            if (!rangeMarker.isValid()) {
                rangeMarker = widerRange;
            }
            if ((newlinesBeforeRange > 0 || newlinesAfterRange > 0) && rangeMarker.isValid()) {
                if (newlinesBeforeRange > 0) {
                    this.myDocument.insertString(rangeMarker.getStartOffset(), (CharSequence)StringUtil.repeatSymbol((char)'\n', (int)newlinesBeforeRange));
                }
                if (newlinesAfterRange > 0) {
                    boolean afterAsBefore = FormatFixer.isTabsAndSpaces(this.myDocument.getText().substring(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
                    this.myDocument.insertString(afterAsBefore ? rangeMarker.getStartOffset() : rangeMarker.getEndOffset(), (CharSequence)StringUtil.repeatSymbol((char)'\n', (int)newlinesAfterRange));
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
            }
        }
    }

    private static boolean isTabsAndSpaces(CharSequence s) {
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) == ' ' || s.charAt(i2) == '\t') continue;
            return false;
        }
        return true;
    }

    public static List<FormatFixer> merge(List<? extends FormatFixer> formatters) {
        MultiMap byFiles = MultiMap.create();
        for (FormatFixer formatFixer : formatters) {
            if (formatFixer == null) continue;
            byFiles.putValue((Object)formatFixer.myFile, (Object)formatFixer);
        }
        ArrayList<FormatFixer> result2 = new ArrayList<FormatFixer>();
        for (PsiFile file2 : byFiles.keySet()) {
            result2.addAll(FormatFixer.mergeSingleFile((List)byFiles.get((Object)file2)));
        }
        return result2;
    }

    public static List<FormatFixer> mergeSingleFile(List<FormatFixer> formatters) {
        if (formatters.size() < 2) {
            return formatters;
        }
        PsiFile file2 = formatters.iterator().next().myFile;
        Document document2 = formatters.iterator().next().myDocument;
        HashMap<TextRange, FormatFixer> fixWhitespace = new HashMap<TextRange, FormatFixer>();
        HashMap<TextRange, FormatFixer> reformats = new HashMap<TextRange, FormatFixer>();
        for (FormatFixer f : formatters) {
            if (!f.myRangeMarker.isValid()) continue;
            LOG.assertTrue(file2 == f.myFile);
            LOG.assertTrue(document2 == f.myDocument);
            if (f.myIsReformat) {
                FormatFixer.addRange(reformats, f);
                continue;
            }
            FormatFixer.addRange(fixWhitespace, f);
        }
        HashMap<TextRange, FormatFixer> reformatsUnited = new HashMap<TextRange, FormatFixer>();
        Iterator i2 = reformats.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry e = i2.next();
            if (!FormatFixer.unionIfIntersects(reformatsUnited, (FormatFixer)e.getValue())) continue;
            i2.remove();
        }
        reformatsUnited.putAll(reformats);
        ArrayList<FormatFixer> result2 = new ArrayList<FormatFixer>();
        result2.addAll(fixWhitespace.values());
        result2.addAll(reformatsUnited.values());
        return result2;
    }

    private static void addRange(Map<TextRange, FormatFixer> ranges, FormatFixer f) {
        TextRange toAdd = TextRange.create((Segment)f.myRangeMarker);
        ArrayList<TextRange> toRemove = new ArrayList<TextRange>();
        for (TextRange existing : ranges.keySet()) {
            if (existing.contains(toAdd)) {
                return;
            }
            if (toAdd.contains(existing)) {
                toRemove.add(existing);
            }
            if (!existing.intersects(toAdd)) continue;
            toRemove.add(existing);
            toAdd = existing.union(toAdd);
        }
        ranges.keySet().removeAll(toRemove);
        ranges.put(toAdd, new FormatFixer(f.myIsReformat, f.myFile, f.myDocument, toAdd.getStartOffset(), toAdd.getEndOffset()));
    }

    private static boolean unionIfIntersects(Map<TextRange, FormatFixer> ranges, FormatFixer f) {
        if (ranges.isEmpty()) {
            return false;
        }
        boolean isReformat = ranges.values().iterator().next().myIsReformat;
        TextRange toAdd = TextRange.create((Segment)f.myRangeMarker);
        ArrayList<TextRange> toRemove = new ArrayList<TextRange>();
        boolean intersects = false;
        for (TextRange existing : ranges.keySet()) {
            if (existing.contains(toAdd)) {
                return true;
            }
            if (!existing.intersects(toAdd)) continue;
            toRemove.add(existing);
            toAdd = existing.union(toAdd);
            intersects = true;
        }
        if (intersects) {
            ranges.keySet().removeAll(toRemove);
            ranges.put(toAdd, new FormatFixer(isReformat, f.myFile, f.myDocument, toAdd.getStartOffset(), toAdd.getEndOffset()));
        }
        return intersects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doReformat(PsiFile file2, int startOffset, int endOffset) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file2.getProject());
        CodeStyleSettings currentSettings = CodeStyle.getSettings((PsiFile)file2);
        Language dialect = JSLanguageUtil.getLanguageDialect((PsiElement)file2, startOffset);
        CommonCodeStyleSettings langSettings = currentSettings.getCommonSettings(dialect);
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)currentSettings.getCustomSettings(XmlCodeStyleSettings.class);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)currentSettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        int blankLinesInCode = langSettings.KEEP_BLANK_LINES_IN_CODE;
        int blankLinesInDeclarations = langSettings.KEEP_BLANK_LINES_IN_DECLARATIONS;
        int blankLinesBeforeRBrace = langSettings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        int blankLinesAroundField = langSettings.BLANK_LINES_AROUND_FIELD;
        int blankLinesAroundFieldInInterface = langSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
        int blankLinesAroundMethod = langSettings.BLANK_LINES_AROUND_METHOD;
        int blankLinesAroundMethodInInterface = langSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
        int blankLinesBeforeImports = langSettings.BLANK_LINES_BEFORE_IMPORTS;
        int blankLinesAfterImports = langSettings.BLANK_LINES_AFTER_IMPORTS;
        int blankLinesAroundFunction = jsSettings.BLANK_LINES_AROUND_FUNCTION;
        int xmlBlankLines = xmlSettings.XML_KEEP_BLANK_LINES;
        boolean xmlKeepWhiteSpacesInsideCdata = xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA;
        try {
            langSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 0;
            langSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 0;
            langSettings.KEEP_BLANK_LINES_IN_CODE = 0;
            langSettings.BLANK_LINES_AROUND_METHOD = 0;
            langSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 0;
            langSettings.BLANK_LINES_AROUND_FIELD = 0;
            langSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
            langSettings.BLANK_LINES_BEFORE_IMPORTS = 0;
            langSettings.BLANK_LINES_AFTER_IMPORTS = 0;
            jsSettings.BLANK_LINES_AROUND_FUNCTION = 0;
            xmlSettings.XML_KEEP_BLANK_LINES = 0;
            xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = false;
            codeStyleManager.reformatText(file2, startOffset, endOffset);
        }
        finally {
            langSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = blankLinesInDeclarations;
            langSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = blankLinesBeforeRBrace;
            langSettings.KEEP_BLANK_LINES_IN_CODE = blankLinesInCode;
            langSettings.BLANK_LINES_AROUND_FIELD = blankLinesAroundField;
            langSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = blankLinesAroundFieldInInterface;
            langSettings.BLANK_LINES_AROUND_METHOD = blankLinesAroundMethod;
            langSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = blankLinesAroundMethodInInterface;
            langSettings.BLANK_LINES_BEFORE_IMPORTS = blankLinesBeforeImports;
            langSettings.BLANK_LINES_AFTER_IMPORTS = blankLinesAfterImports;
            jsSettings.BLANK_LINES_AROUND_FUNCTION = blankLinesAroundFunction;
            xmlSettings.XML_KEEP_BLANK_LINES = xmlBlankLines;
            xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = xmlKeepWhiteSpacesInsideCdata;
        }
    }

    public static void fixAll(List<? extends FormatFixer> inlinedPlacesFormatFixers) {
        for (FormatFixer formatFixer : inlinedPlacesFormatFixers) {
            if (formatFixer == null) continue;
            formatFixer.fixFormat();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "possibleRange";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "mode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/FormatFixer";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Mode {
        FirstLinebreak,
        Reformat,
        ReformatExactRange,
        FollowingWhitespace,
        InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact;

    }
}

