/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGetterSetterRenameUtil {
    private JSGetterSetterRenameUtil() {
    }

    public static boolean isFieldWithAccessors(@Nullable PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        String name = ((JSVariable)element).getName();
        PsiElement parent = JSResolveUtil.findParent(element);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSClass jsClass = (JSClass)parent;
        String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, element);
        return jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.GETTER) != null || jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.SETTER) != null;
    }

    @Nullable
    static JSFunction.FunctionKind getFunctionKindToSearch(JSFunction function2) {
        JSFunction.FunctionKind toFind = null;
        if (function2.isGetProperty()) {
            toFind = JSFunction.FunctionKind.SETTER;
        } else if (function2.isSetProperty()) {
            toFind = JSFunction.FunctionKind.GETTER;
        }
        return toFind;
    }

    @NotNull
    public static Map<PsiElement, String> getRelatedElementsInClass(@NotNull PsiElement element, @NotNull JSClass parent, String newName) {
        String name;
        String expectedPropertyName;
        if (element == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(1);
        }
        HashMap<PsiElement, String> allRenames = new HashMap<PsiElement, String>();
        if (JSGetterSetterRenameUtil.isGetterSetterFunction(element)) {
            JSFunction function2 = (JSFunction)element;
            JSFunction.FunctionKind toFind = JSGetterSetterRenameUtil.getFunctionKindToSearch(function2);
            if (toFind != null) {
                JSField field;
                String expectedFieldName;
                String funName = function2.getName();
                JSFunction oppositePropertyFunction = parent.findFunctionByNameAndKind(funName, toFind);
                if (oppositePropertyFunction != null) {
                    allRenames.put((PsiElement)oppositePropertyFunction, newName);
                }
                if ((expectedFieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(funName, element)) != null && !expectedFieldName.equals(funName) && (field = parent.findFieldByName(expectedFieldName)) != null) {
                    allRenames.put((PsiElement)field, JSRefactoringUtil.transformAccessorNameToPropertyName(newName, (PsiElement)field));
                }
            }
        } else if (element instanceof JSFieldVariable && !StringUtil.equals((CharSequence)(expectedPropertyName = JSRefactoringUtil.transformVarNameToAccessorName(name = ((JSFieldVariable)element).getName(), element)), (CharSequence)name)) {
            JSFunction getter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.GETTER);
            JSFunction setter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.SETTER);
            String accessorNewName = JSRefactoringUtil.transformVarNameToAccessorName(newName, element);
            if (getter != null || setter != null) {
                if (!ApplicationManager.getApplication().isUnitTestMode() && !MessageDialogBuilder.yesNo((String)JavaScriptBundle.message("rename.accessors.dialog.title", new Object[0]), (String)JavaScriptBundle.message("rename.accessors.dialog.text", accessorNewName)).ask(element.getProject())) {
                    HashMap<PsiElement, String> hashMap = allRenames;
                    if (hashMap == null) {
                        JSGetterSetterRenameUtil.$$$reportNull$$$0(2);
                    }
                    return hashMap;
                }
                String fieldPrefix = JSCodeStyleSettings.getSettings((PsiElement)element).FIELD_PREFIX;
                if (!StringUtil.isEmpty((String)fieldPrefix) && !newName.startsWith(fieldPrefix)) {
                    allRenames.put(element, fieldPrefix + newName);
                }
                if (getter != null) {
                    allRenames.put((PsiElement)getter, accessorNewName);
                }
                if (setter != null) {
                    allRenames.put((PsiElement)setter, accessorNewName);
                }
            }
        }
        HashMap<PsiElement, String> hashMap = allRenames;
        if (hashMap == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    public static boolean isGetterSetterFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(4);
        }
        return element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSGetterSetterRenameUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSGetterSetterRenameUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElementsInClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElementsInClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGetterSetterFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

