/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public abstract class JSScopeSelectionPopup<TScope>
implements JSScopeSelectionUI<TScope> {
    private final Editor editor;
    private final short myConstraint;
    private LightweightHint myLastHint;

    public JSScopeSelectionPopup(Editor editor, @HintManager.PositionFlags short constraint) {
        this.editor = editor;
        this.myConstraint = constraint;
    }

    @Override
    public void show(@NotNull TScope defaultSuggestedScope, final @NotNull List<JSScopeSelectionUI.ScopePresentation<TScope>> scopeList, @NotNull Consumer<? super TScope> callback) {
        if (defaultSuggestedScope == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(0);
        }
        if (scopeList == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(2);
        }
        final LogicalPosition initialPos = this.editor.offsetToLogicalPosition(this.editor.getCaretModel().getOffset());
        final JBList list2 = new JBList((Collection)ContainerUtil.map(scopeList, presentation -> presentation.getScope()));
        list2.setSelectedValue(defaultSuggestedScope, true);
        list2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = list2.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                JSScopeSelectionUI.ScopePresentation presentation = (JSScopeSelectionUI.ScopePresentation)scopeList.get(index);
                int hintPosition = presentation.getHintPosition();
                int vShift = presentation.getVShift();
                LogicalPosition logicalPosition = JSScopeSelectionPopup.this.editor.offsetToLogicalPosition(hintPosition);
                LogicalPosition position = vShift == 0 ? logicalPosition : new LogicalPosition(logicalPosition.line + vShift, logicalPosition.column, logicalPosition.leansForward);
                JSScopeSelectionPopup.this.editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
                JSScopeSelectionPopup.this.editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                    LightweightHint hint;
                    JComponent label = HintUtil.createInformationLabel((String)presentation.getSignature());
                    JSScopeSelectionPopup.this.myLastHint = hint = new LightweightHint(label);
                    HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                    Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)JSScopeSelectionPopup.this.editor, (LogicalPosition)position, (short)JSScopeSelectionPopup.this.myConstraint);
                    hintManager.showEditorHint(hint, JSScopeSelectionPopup.this.editor, p, 48, 0, false, HintManagerImpl.createHintHint((Editor)JSScopeSelectionPopup.this.editor, (Point)p, (LightweightHint)hint, (short)JSScopeSelectionPopup.this.myConstraint, (boolean)true).setContentActive(false).setAwtTooltip(true).setShowImmediately(true));
                });
            }
        });
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                JSScopeSelectionPopup.this.doSetText(value, this);
                return rendererComponent;
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(JavaScriptBundle.message("choose.destination.scope", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> callback.accept((Object)list2.getSelectedValue())).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                JSScopeSelectionPopup.this.editor.getScrollingModel().scrollTo(initialPos, ScrollType.CENTER);
                if (JSScopeSelectionPopup.this.myLastHint != null) {
                    JSScopeSelectionPopup.this.myLastHint.hide();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/refactoring/JSScopeSelectionPopup$3", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.editor);
    }

    protected abstract void doSetText(TScope var1, DefaultListCellRenderer var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "defaultSuggestedScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scopeList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/JSScopeSelectionPopup";
        objectArray[2] = "show";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

