/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCommandLineBuilder {
    @NotNull
    private final List<String> myParameters = new ArrayList<String>();
    @NotNull
    private final Map<String, String> myEnvironment = new HashMap<String, String>();
    @Nullable
    private String myExePath;
    @Nullable
    private String myWorkingDirectory;
    @NotNull
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(0);
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(1);
        }
        this.myCharset = charset;
    }

    @NotNull
    public String getExePath() {
        if (this.myExePath == null) {
            throw new IllegalStateException("exe path is not set");
        }
        String string = this.myExePath;
        if (string == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(3);
        }
        this.myExePath = exePath;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(4);
        }
        this.myWorkingDirectory = workingDirectory;
    }

    @NotNull
    public List<String> getParameters() {
        List<String> list2 = this.myParameters;
        if (list2 == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(6);
        }
        this.myParameters.add(parameter);
    }

    public void addParameters(@NotNull List<String> parametersList) {
        if (parametersList == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(7);
        }
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(String ... parametersList) {
        if (parametersList == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(8);
        }
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameterAt(int index, @NotNull String parameter) {
        if (parameter == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(9);
        }
        this.myParameters.add(index, parameter);
    }

    @NotNull
    public GeneralCommandLine toGeneralCommandLine() {
        GeneralCommandLine commandLine = new GeneralCommandLine().withParameters(this.myParameters).withEnvironment(this.myEnvironment).withWorkDirectory(this.myWorkingDirectory).withCharset(this.myCharset);
        if (this.myExePath != null) {
            commandLine.setExePath(this.myExePath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    public String toString() {
        return this.myExePath + " " + StringUtil.join(this.myParameters, (String)" ");
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.myEnvironment;
        if (map == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(11);
        }
        return map;
    }

    public void setEnvironment(@NonNls @NotNull String key, @NonNls @NotNull String value) {
        if (key == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(12);
        }
        if (value == null) {
            JSCommandLineBuilder.$$$reportNull$$$0(13);
        }
        this.myEnvironment.put(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/protocol/JSCommandLineBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSCommandLineBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toGeneralCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParameterAt";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

