/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSCommandLineBuilder;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceNodeStdProtocolBase
implements JSLanguageServiceProtocol {
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    private static final byte[] NEW_LINE = "\n".getBytes(StandardCharsets.UTF_8);
    public static final BaseOutputReader.Options PROCESS_READER_OPTIONS = new BaseOutputReader.Options(){

        public BaseDataReader.SleepingPolicy policy() {
            return BaseOutputReader.Options.BLOCKING.policy();
        }

        public boolean splitToLines() {
            return BaseOutputReader.Options.BLOCKING.splitToLines();
        }

        public boolean sendIncompleteLines() {
            return false;
        }
    };
    @Nullable
    protected final String myServiceName;
    @NotNull
    protected final Project myProject;
    @Nullable
    @Nls
    private volatile String myInitializeError;
    protected final long mySessionId;
    @NotNull
    private final Consumer<JsonObject> myInitialStateConsumer;
    private final AtomicInteger mySeq;
    @Nullable
    private OutputStream myProcessInput;
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;
    @NotNull
    private Gson myGson;

    public JSLanguageServiceNodeStdProtocolBase(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(0);
        }
        if (readyConsumer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(1);
        }
        this(null, project, readyConsumer);
    }

    public JSLanguageServiceNodeStdProtocolBase(@Nullable String serviceName, @NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(2);
        }
        if (readyConsumer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(3);
        }
        this.mySessionId = System.currentTimeMillis();
        this.mySeq = new AtomicInteger();
        this.myCallbacks = new ConcurrentHashMap<Integer, JSLanguageServiceAnswerConsumer>();
        this.myGson = JSLanguageServiceQueue.GSON;
        this.myServiceName = serviceName;
        this.myProject = project;
        this.myInitialStateConsumer = readyConsumer;
    }

    @Override
    @Nullable
    public final String getInitializeError() {
        return this.myInitializeError;
    }

    protected boolean waitingReadyNotification(@NotNull ProcessHandler processHandler, @NotNull ThrowableRunnable<Exception> action, final @NotNull ReadyChecker checker) throws Exception {
        if (processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(4);
        }
        if (action == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(5);
        }
        if (checker == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(6);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result2 = new Ref((Object)false);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                checker.check(event, outputType, (Ref<Boolean>)result2, countDownLatch);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                countDownLatch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)listener2);
        action.run();
        JSLanguageServiceQueue.LOGGER.debug("Start waiting for ready start");
        if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
            countDownLatch.await();
        } else {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        JSLanguageServiceQueue.LOGGER.debug("End waiting for process starting. Result " + result2.get());
        processHandler.removeProcessListener((ProcessListener)listener2);
        return (Boolean)result2.get();
    }

    @NotNull
    private NodeTargetRun createTargetRun() throws ExecutionException {
        NodeJsInterpreter interpreter = this.getInterpreterOrFail();
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, null, NodeTargetRun.createOptions(ThreeState.NO, List.of(), PROCESS_READER_OPTIONS));
        this.myGson = JSLanguageServiceUtil.createGson(targetRun);
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        this.addNodeProcessAdditionalArguments(targetRun);
        File file2 = new File(this.getEntryPointFolder(), JSLanguageServiceNodeStdProtocolBase.getEntryPointFile());
        if (!file2.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file2.getAbsolutePath());
        }
        commandLineBuilder.setWorkingDirectory(targetRun.path(this.getWorkingDirectory()));
        commandLineBuilder.addParameter(targetRun.path(file2.getAbsolutePath()));
        commandLineBuilder.addParameter(this.getSessionIdParam());
        if (this.myServiceName != null) {
            commandLineBuilder.addParameter("-debug-name=" + this.myServiceName);
        }
        NodeTargetRun nodeTargetRun = targetRun;
        if (nodeTargetRun == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(7);
        }
        return nodeTargetRun;
    }

    @NotNull
    private JSCommandLineBuilder createCommandLine() {
        NodeJsInterpreter interpreter = this.getInterpreterOrFail();
        this.myGson = JSLanguageServiceUtil.createGson(interpreter);
        JSCommandLineBuilder commandLine = new JSCommandLineBuilder();
        this.addNodeProcessAdditionalArguments(commandLine);
        File file2 = new File(this.getEntryPointFolder(), JSLanguageServiceNodeStdProtocolBase.getEntryPointFile());
        if (!file2.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file2.getAbsolutePath());
        }
        commandLine.setWorkingDirectory(FileUtil.toSystemDependentName((String)this.getWorkingDirectory()));
        commandLine.addParameter(file2.getAbsolutePath());
        commandLine.addParameter(this.getSessionIdParam());
        if (this.myServiceName != null) {
            commandLine.addParameter("-debug-name=" + this.myServiceName);
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        JSCommandLineBuilder jSCommandLineBuilder = commandLine;
        if (jSCommandLineBuilder == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(8);
        }
        return jSCommandLineBuilder;
    }

    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(9);
        }
        NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.emptyOptions(this.myProject);
        if (options == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(10);
        }
        return options;
    }

    protected String getWorkingDirectory() {
        return this.myProject.getBasePath();
    }

    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
    }

    @NotNull
    protected final NodeJsInterpreter getInterpreterOrFail() {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            this.myInitializeError = JavaScriptBundle.message("javascript.service.node.error", new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter;
        if (nodeJsInterpreter == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(11);
        }
        return nodeJsInterpreter;
    }

    protected void addNodeProcessAdditionalArguments(@NotNull JSCommandLineBuilder commandLine) {
        if (commandLine == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(12);
        }
        if (this.myServiceName != null) {
            String systemProp = System.getProperty("idea.javascript.language.service.debug.options." + this.myServiceName);
            JSLanguageServiceUtil.addNodeProcessArguments(commandLine, this.myServiceName, systemProp);
        }
    }

    protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(13);
        }
        if (this.myServiceName != null) {
            String systemProp = System.getProperty("idea.javascript.language.service.debug.options." + this.myServiceName);
            JSLanguageServiceUtil.addNodeProcessArguments(targetRun.getCommandLineBuilder(), this.myServiceName, systemProp);
        }
    }

    @NotNull
    public static String getEntryPointFile() {
        return "js-language-service.js";
    }

    protected final String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    protected File getEntryPointFolder() {
        return JSLanguageServiceUtil.getPluginStarterDirectory();
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        if (cancellationToken instanceof Collection) {
            ((Collection)cancellationToken).forEach(el -> this.myCallbacks.remove(el));
        } else {
            this.myCallbacks.remove(cancellationToken);
        }
    }

    @NotNull
    protected final String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull JSCommandLineBuilder commandLineBuilder) throws ExecutionException {
        if (commandLineBuilder == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(15);
        }
        if (JSLanguageServiceProcessStarter.EP_NAME.hasAnyExtensions()) {
            NodeCommandLineConfigurator.find(this.getInterpreterOrFail()).configure(commandLineBuilder);
        }
        for (JSLanguageServiceProcessStarter supplier : JSLanguageServiceProcessStarter.EP_NAME.getExtensionList()) {
            ProcessHandler processHandler = supplier.createProcessHandler(commandLineBuilder);
            if (processHandler == null) continue;
            if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.LOGGER.debug("Commandline from " + supplier.getClass().getSimpleName() + ": " + commandLineBuilder);
            }
            ProcessHandler processHandler2 = processHandler;
            if (processHandler2 == null) {
                JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(16);
            }
            return processHandler2;
        }
        GeneralCommandLine line = commandLineBuilder.toGeneralCommandLine();
        try {
            NodeCommandLineConfigurator.find(this.getInterpreterOrFail()).configure(line, this.getNodeCommandLineConfiguratorOptions(this.myProject));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Commandline " + line);
        }
        return new OSProcessHandler(line){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = PROCESS_READER_OPTIONS;
                if (options == null) {
                    3.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$3", "readerOptions"));
            }
        };
    }

    @Override
    @NotNull
    public ProcessHandler connect() throws Exception {
        ProcessHandler processHandler;
        if (NodeTargetRun.shouldEnableRemoteDevelopmentUsingTargetsApi()) {
            NodeTargetRun targetRun = this.createTargetRun();
            processHandler = targetRun.startProcess();
        } else {
            JSCommandLineBuilder commandLineBuilder = this.createCommandLine();
            processHandler = this.createProcessHandler(commandLineBuilder);
        }
        JSLanguageServiceQueue.LOGGER.debug("Language service was started. Start initialization of the plugin");
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(17);
        }
        return processHandler2;
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler processHandler) throws Exception {
        if (processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(18);
        }
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((ProcessHandler)processHandler).startNotify()), this::checkReadyCommand)) {
                processHandler.destroyProcess();
                return false;
            }
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)this::sendInitialState), (event, outputType, result2, countDownLatch) -> {
                block8: {
                    if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                        String text = StringUtil.trim((String)event.getText());
                        if (text.startsWith("{") && text.endsWith("}")) {
                            JsonElement answer = JsonParser.parseString((String)text);
                            JsonObject answerAsJsonObject = answer.getAsJsonObject();
                            try {
                                JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                                JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive(ANSWER_ERROR);
                                if (success.getAsBoolean()) {
                                    result2.set((Object)true);
                                    countDownLatch.countDown();
                                    this.myInitialStateConsumer.consume((Object)answerAsJsonObject);
                                    break block8;
                                }
                                String errorText = StringUtil.notNullize((String)error.getAsString());
                                JsonPrimitive stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                                @NlsSafe String errorWithStack = errorText + "\n" + (stack == null ? "" : stack.getAsString());
                                JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Error initializing " + errorWithStack);
                                this.myInitializeError = errorWithStack;
                                countDownLatch.countDown();
                            }
                            catch (Exception e) {
                                JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Error initializing " + e.getMessage() + "\nCannot parse " + text);
                                this.myInitializeError = JavaScriptBundle.message("cannot.parse.service.initialization.answer.0", text);
                            }
                        } else {
                            JSLanguageServiceQueue.LOGGER.warn(this.getClass().getName() + " Expected json answer: " + event.getText());
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Starting language service output error: " + event.getText());
                    }
                }
            })) {
                processHandler.destroyProcess();
                return false;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText()))) {
                    text = StringUtil.trim((String)text);
                    JSLanguageServiceNodeStdProtocolBase.this.processText(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$4";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    private void processText(String text) {
        if (text.startsWith("{") && text.endsWith("}")) {
            JSLanguageServiceAnswer answer = null;
            try {
                answer = new JSLanguageServiceAnswer(text);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error("Cannot parse answer for protocol: " + this.getClass().getName() + ", text:\n " + JSLanguageServiceNodeStdProtocolBase.truncateText(text), (Throwable)e);
            }
            if (answer == null) {
                return;
            }
            this.processAnswer(answer, text);
        }
    }

    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull String text) {
        Integer seq;
        if (answer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(19);
        }
        if (text == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(20);
        }
        if ((seq = answer.getSeq()) != null) {
            JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(seq);
            if (consumer != null) {
                if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.LOGGER.debug(this.getClass().getSimpleName() + " Pass request " + seq + " to consumer");
                }
                consumer.consume(answer);
            } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.LOGGER.debug(this.getClass().getSimpleName() + " No callback for seq: " + text);
            }
        } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug(this.getClass().getSimpleName() + " No sequence number, skip request: " + text);
        }
    }

    private void sendInitialState() throws Exception {
        JSLanguageServiceInitialState initialState = this.needReadActionToCreateState() ? (JSLanguageServiceInitialState)ReadAction.compute(() -> this.createState()) : this.createState();
        String state2 = this.myGson.toJson((Object)initialState);
        JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Send state to service: " + state2);
        this.writeln(state2);
    }

    protected boolean needReadActionToCreateState() {
        return true;
    }

    protected abstract JSLanguageServiceInitialState createState();

    @Override
    @NotNull
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(21);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(22);
        }
        int value = this.getUniqueCommandId();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        String request = this.getWritableString(command, data, value);
        this.writeln(request);
        Integer n = value;
        if (n == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(23);
        }
        return n;
    }

    @NotNull
    protected String getWritableString(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, int value) {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(24);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(25);
        }
        JSLanguageServiceRequest toSend = new JSLanguageServiceRequest(command, data, this.mySessionId, value);
        String request = this.myGson.toJson((Object)toSend);
        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
            String toPrint = JSLanguageServiceNodeStdProtocolBase.truncateText(request);
            JSLanguageServiceQueue.LOGGER.trace(this.getClass().getSimpleName() + " Request: " + toPrint);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug(this.getClass().getSimpleName() + " Request command: " + command.getCommand());
        }
        String string = request;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String truncateText(String request) {
        Object toPrint = request;
        if (Registry.is((String)"JavaScript.Language.Service.truncate.traced.messages", (boolean)true) && request.length() > 1000) {
            toPrint = request.substring(0, 200) + "\n ................................(truncated)";
        }
        String string = toPrint;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(27);
        }
        return string;
    }

    protected int getUniqueCommandId() {
        return this.mySeq.getAndIncrement();
    }

    protected final void checkReadyCommand(ProcessEvent event, Key outputType, Ref<? super Boolean> result2, CountDownLatch countDownLatch) {
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output: " + event.getText());
            String text = event.getText().trim();
            if (this.toSystemCommand(ANSWER_READY).equals(text)) {
                result2.set((Object)true);
                countDownLatch.countDown();
            }
            if (text.startsWith(prefix = this.toSystemCommand(ANSWER_ERROR))) {
                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + text.substring(prefix.length()));
                this.myInitializeError = text.substring(prefix.length());
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    protected void writeln(@NotNull String data) throws IOException {
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(28);
        }
        if (this.myProcessInput != null) {
            this.myProcessInput.write(data.getBytes(StandardCharsets.UTF_8));
            this.myProcessInput.write(NEW_LINE);
            this.myProcessInput.flush();
        }
    }

    @NotNull
    public Gson getGson() {
        Gson gson = this.myGson;
        if (gson == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(29);
        }
        return gson;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineBuilder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRun";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterOrFail";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemCommand";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sendCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableString";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitingReadyNotification";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getWritableString";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeln";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface JSLanguageServiceProcessStarter {
        public static final ExtensionPointName<JSLanguageServiceProcessStarter> EP_NAME = ExtensionPointName.create((String)"JavaScript.languageServiceProcessStarter");

        @Nullable
        public ProcessHandler createProcessHandler(@NotNull JSCommandLineBuilder var1);
    }

    protected static interface ReadyChecker {
        public void check(@NotNull ProcessEvent var1, @NotNull Key var2, @NotNull Ref<Boolean> var3, @NotNull CountDownLatch var4);
    }
}

