/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;

public class JSWithForSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JavaScriptBundle.message("javascript.surround.with.for", new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "for(i=0; i<1; i++) { }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSForStatement forStatement = (JSForStatement)statementNode.getPsi();
        return forStatement.getBody().getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        for (ASTNode childNode : statementNode.getChildren(null)) {
            if (childNode.getElementType() == JSTokenTypes.SEMICOLON || childNode.getPsi() instanceof PsiWhiteSpace || JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(childNode.getElementType())) {
                statementNode.removeChild(childNode);
                continue;
            }
            if (childNode.getElementType() != JSTokenTypes.RPAR) continue;
            int offset = childNode.getStartOffset();
            return new TextRange(offset, offset);
        }
        return null;
    }
}

