/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptPackageChooserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)ActionScriptPackageChooserDialog.class.getName());
    private Tree myTree;
    private DefaultTreeModel myModel;
    private final Project myProject;
    @NlsContexts.DialogTitle
    private final String myTitle;
    private final DirectoryIndex myIndex;
    private final GlobalSearchScope mySearchScope;

    public ActionScriptPackageChooserDialog(@NlsContexts.DialogTitle String title, Project project, GlobalSearchScope searchScope) {
        super(project, true);
        this.mySearchScope = searchScope;
        this.setTitle(title);
        this.myTitle = title;
        this.myProject = project;
        this.myIndex = DirectoryIndex.getInstance((Project)this.myProject);
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        this.myModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.createTreeModel();
        this.myTree = new Tree((TreeModel)this.myModel);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object object;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(PlatformIcons.PACKAGE_ICON);
                if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof VirtualFile) {
                    String name = ActionScriptPackageChooserDialog.this.myIndex.getPackageName((VirtualFile)object);
                    this.setText(name.length() > 0 ? StringUtil.getShortName((String)name) : IdeBundle.message((String)"node.default", (Object[])new Object[0]));
                }
                return this;
            }
        });
        this.myTree.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        new TreeSpeedSearch(this.myTree, path2 -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            Object object = node.getUserObject();
            if (object instanceof VirtualFile) {
                return ((VirtualFile)object).getName();
            }
            return "";
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                VirtualFile selection = ActionScriptPackageChooserDialog.this.getTreeSelection();
                if (selection != null) {
                    @NlsSafe String name = ActionScriptPackageChooserDialog.this.myIndex.getPackageName(selection);
                    ActionScriptPackageChooserDialog.this.setTitle(ActionScriptPackageChooserDialog.this.myTitle + " - " + ("".equals(name) ? IdeBundle.message((String)"node.default.package", (Object[])new Object[0]) : name));
                } else {
                    ActionScriptPackageChooserDialog.this.setTitle(ActionScriptPackageChooserDialog.this.myTitle);
                }
            }
        });
        panel2.add((Component)scrollPane, "Center");
        DefaultActionGroup group = this.createActionGroup((JComponent)this.myTree);
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("ASPackageChooser", (ActionGroup)group, true);
        panel2.add((Component)toolBar.getComponent(), "North");
        toolBar.getComponent().setAlignmentX(0.0f);
        return panel2;
    }

    private DefaultActionGroup createActionGroup(JComponent component) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup temp = new DefaultActionGroup();
        NewPackageAction newPackageAction = new NewPackageAction();
        newPackageAction.enableInModalConext();
        newPackageAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("NewElement").getShortcutSet(), component);
        temp.add((AnAction)newPackageAction);
        group.add((AnAction)temp);
        return group;
    }

    public String getDimensionServiceKey() {
        return "#com.intellij.ide.util.PackageChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    public String getSelectedPackage() {
        VirtualFile file2 = this.getTreeSelection();
        return file2 != null ? this.myIndex.getPackageName(file2) : null;
    }

    public void selectPackage(String qualifiedName) {
        DefaultMutableTreeNode node = this.findNodeForPackage(qualifiedName);
        if (node != null) {
            TreePath path2 = new TreePath(node.getPath());
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path2);
        }
    }

    @Nullable
    private VirtualFile getTreeSelection() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
        return (VirtualFile)node.getUserObject();
    }

    private void createTreeModel() {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        fileIndex.iterateContent(fileOrDir -> {
            if (fileOrDir.isDirectory() && this.mySearchScope.contains(fileOrDir) && fileIndex.isInSourceContent(fileOrDir)) {
                this.addPackage(fileOrDir);
            }
            return true;
        });
        TreeUtil.sort((DefaultTreeModel)this.myModel, (o1, o2) -> {
            DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)o1;
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)o2;
            VirtualFile element1 = (VirtualFile)n1.getUserObject();
            VirtualFile element2 = (VirtualFile)n2.getUserObject();
            return element1.getName().compareToIgnoreCase(element2.getName());
        });
    }

    @NotNull
    private DefaultMutableTreeNode addPackage(VirtualFile aPackage) {
        String qualifiedPackageName = this.myIndex.getPackageName(aPackage);
        VirtualFile parentPackage = aPackage.getParent();
        if (parentPackage == null || this.myIndex.getPackageName(parentPackage) == null) {
            DefaultMutableTreeNode rootNode2 = (DefaultMutableTreeNode)this.myModel.getRoot();
            if (qualifiedPackageName.length() == 0) {
                rootNode2.setUserObject(aPackage);
                DefaultMutableTreeNode defaultMutableTreeNode = rootNode2;
                if (defaultMutableTreeNode == null) {
                    ActionScriptPackageChooserDialog.$$$reportNull$$$0(0);
                }
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode packageNode = this.findPackageNode(rootNode2, qualifiedPackageName);
            if (packageNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
                if (defaultMutableTreeNode == null) {
                    ActionScriptPackageChooserDialog.$$$reportNull$$$0(1);
                }
                return defaultMutableTreeNode;
            }
            packageNode = new DefaultMutableTreeNode(aPackage);
            rootNode2.add(packageNode);
            DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
            if (defaultMutableTreeNode == null) {
                ActionScriptPackageChooserDialog.$$$reportNull$$$0(2);
            }
            return defaultMutableTreeNode;
        }
        DefaultMutableTreeNode parentNode = this.addPackage(parentPackage);
        DefaultMutableTreeNode packageNode = this.findPackageNode(parentNode, qualifiedPackageName);
        if (packageNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
            if (defaultMutableTreeNode == null) {
                ActionScriptPackageChooserDialog.$$$reportNull$$$0(3);
            }
            return defaultMutableTreeNode;
        }
        packageNode = new DefaultMutableTreeNode(aPackage);
        parentNode.add(packageNode);
        DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
        if (defaultMutableTreeNode == null) {
            ActionScriptPackageChooserDialog.$$$reportNull$$$0(4);
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    private DefaultMutableTreeNode findPackageNode(DefaultMutableTreeNode rootNode2, String qualifiedName) {
        for (int i2 = 0; i2 < rootNode2.getChildCount(); ++i2) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)rootNode2.getChildAt(i2);
            VirtualFile nodePackage = (VirtualFile)child.getUserObject();
            if (nodePackage == null || !Objects.equals(this.myIndex.getPackageName(nodePackage), qualifiedName)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private DefaultMutableTreeNode findNodeForPackage(String qualifiedPackageName) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myModel.getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node;
            VirtualFile nodePackage;
            TreeNode o = enumeration.nextElement();
            if (!(o instanceof DefaultMutableTreeNode) || (nodePackage = (VirtualFile)(node = (DefaultMutableTreeNode)o).getUserObject()) == null || !Objects.equals(this.myIndex.getPackageName(nodePackage), qualifiedPackageName)) continue;
            return node;
        }
        return null;
    }

    private void createNewPackage() {
        final VirtualFile selectedPackage = this.getTreeSelection();
        if (selectedPackage == null) {
            return;
        }
        final String newPackageName = Messages.showInputDialog((Project)this.myProject, (String)IdeBundle.message((String)"prompt.enter.a.new.package.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.package", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newPackageName == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)IdeBundle.message((String)"command.create.new.package", (Object[])new Object[0]), null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Object newQualifiedName = ActionScriptPackageChooserDialog.this.myIndex.getPackageName(selectedPackage);
                    if (!Comparing.strEqual((String)newQualifiedName, (String)"")) {
                        newQualifiedName = (String)newQualifiedName + ".";
                    }
                    newQualifiedName = (String)newQualifiedName + newPackageName;
                    VirtualFile dir = selectedPackage.createChildDirectory((Object)this, newPackageName);
                    if (dir == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)ActionScriptPackageChooserDialog.this.myTree.getSelectionPath().getLastPathComponent();
                    DefaultMutableTreeNode newChild = new DefaultMutableTreeNode();
                    newChild.setUserObject(dir);
                    node.add(newChild);
                    DefaultTreeModel model = (DefaultTreeModel)ActionScriptPackageChooserDialog.this.myTree.getModel();
                    model.nodeStructureChanged(node);
                    TreePath selectionPath = ActionScriptPackageChooserDialog.this.myTree.getSelectionPath();
                    TreePath path2 = selectionPath == null ? new TreePath(newChild.getPath()) : selectionPath.pathByAddingChild(newChild);
                    ActionScriptPackageChooserDialog.this.myTree.setSelectionPath(path2);
                    ActionScriptPackageChooserDialog.this.myTree.scrollPathToVisible(path2);
                    ActionScriptPackageChooserDialog.this.myTree.expandPath(path2);
                }
                catch (IncorrectOperationException | IOException e) {
                    Messages.showMessageDialog((Component)ActionScriptPackageChooserDialog.this.getContentPane(), (String)StringUtil.getMessage((Throwable)e), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    LOG.debug(e);
                }
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/ActionScriptPackageChooserDialog", "addPackage"));
    }

    private class NewPackageAction
    extends AnAction {
        NewPackageAction() {
            super(IdeBundle.messagePointer((String)"action.new.package", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.description.create.new.package", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NewPackageAction.$$$reportNull$$$0(0);
            }
            ActionScriptPackageChooserDialog.this.createNewPackage();
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                NewPackageAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(ActionScriptPackageChooserDialog.this.getTreeSelection() != null);
        }

        public void enableInModalConext() {
            this.setEnabledInModalContext(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/ui/ActionScriptPackageChooserDialog$NewPackageAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

