/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ClassExpression;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicatesCheckUtil {
    private DuplicatesCheckUtil() {
    }

    @Nullable
    public static JSDuplicatesCheckError checkDuplicates(@NotNull JSPsiNamedElementBase node) {
        String name;
        if (node == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(0);
        }
        if ((name = node.getName()) == null) {
            return null;
        }
        return DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)node);
    }

    public static JSDuplicatesCheckError checkDefaultExports(@NotNull ES6ExportDefaultAssignment exportElement) {
        JSElement scope;
        if (exportElement == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(1);
        }
        if ((scope = ES6PsiUtil.getExportScope((PsiElement)exportElement)) == null) {
            return null;
        }
        JSNamedElement element = exportElement.getNamedElement();
        Set overloads = element instanceof TypeScriptFunction ? TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element) : Collections.emptySet();
        List declarations = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)scope, ES6ExportDefaultAssignment.class);
        if (declarations.size() > 1) {
            ES6ExportDefaultAssignment elementToNavigate = (ES6ExportDefaultAssignment)ContainerUtil.find((Iterable)declarations, el -> el != exportElement && !overloads.contains(el.getNamedElement()));
            if (elementToNavigate == null) {
                return null;
            }
            return new JSDuplicatesCheckError(false, JavaScriptBundle.message("javascript.validation.message.duplicate.default.export.declaration", new Object[0]), (PsiElement)elementToNavigate);
        }
        return null;
    }

    @Nullable
    public static JSDuplicatesCheckError checkTypeParameterDuplicates(@NotNull TypeScriptTypeParameter typeParameter) {
        TypeScriptTypeParameter[] typeParameters;
        String typeParameterName;
        if (typeParameter == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(2);
        }
        if ((typeParameterName = typeParameter.getName()) == null) {
            return null;
        }
        TypeScriptTypeParameterListOwner typeParameterListOwner = typeParameter.getOwner();
        if (typeParameterListOwner == null) {
            return null;
        }
        for (TypeScriptTypeParameter otherTypeParameter : typeParameters = typeParameterListOwner.getTypeParameters()) {
            if (otherTypeParameter == typeParameter || !typeParameterName.equals(otherTypeParameter.getName())) continue;
            return new JSDuplicatesCheckError(false, JavaScriptBundle.message("javascript.validation.message.duplicate.declaration", new Object[0]), (PsiElement)otherTypeParameter);
        }
        return null;
    }

    @Nullable
    public static JSDuplicatesCheckError checkExportDuplicates(@NotNull PsiNamedElement exportElement) {
        if (exportElement == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(3);
        }
        if (!(exportElement instanceof ES6ExportSpecifier) && !(exportElement instanceof ES6ExportSpecifierAlias)) {
            return null;
        }
        String myName = exportElement.getName();
        if (myName == null) {
            return null;
        }
        JSElement scope = ES6PsiUtil.getExportScope((PsiElement)exportElement);
        if (scope == null) {
            return null;
        }
        Collection<JSElement> namedElements = JSResolveUtil.findNamedElementsInScope(myName, scope);
        List jsElements = ContainerUtil.filter(namedElements, element -> element != exportElement && !(element instanceof ES6ExportSpecifier) && !(element instanceof ES6ExportSpecifierAlias) && element instanceof JSAttributeListOwner && DuplicatesCheckUtil.isExport((JSAttributeListOwner)element));
        if (!jsElements.isEmpty()) {
            return new JSDuplicatesCheckError(false, JavaScriptBundle.message("javascript.validation.message.duplicate.export.declaration", myName), (PsiElement)jsElements.get(0));
        }
        List declarations = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)scope, ES6ExportDeclaration.class);
        boolean hasDuplicates = false;
        JSPsiNamedElementBase elementToNavigate = null;
        block0: for (ES6ExportDeclaration declaration : declarations) {
            ES6ExportSpecifier[] specifiers;
            for (ES6ExportSpecifier specifier : specifiers = declaration.getExportSpecifiers()) {
                ES6ExportSpecifierAlias alias = specifier.getAlias();
                if (alias != null && myName.equals(alias.getName()) && alias != exportElement) {
                    hasDuplicates = true;
                    elementToNavigate = alias;
                    continue block0;
                }
                String name = specifier.getName();
                if (!myName.equals(name) || exportElement == specifier) continue;
                hasDuplicates = true;
                elementToNavigate = specifier;
                continue block0;
            }
        }
        if (hasDuplicates) {
            return new JSDuplicatesCheckError(false, JavaScriptBundle.message("javascript.validation.message.duplicate.declaration", new Object[0]), (PsiElement)elementToNavigate);
        }
        return null;
    }

    private static boolean isExport(@NotNull JSAttributeListOwner element) {
        JSAttributeList attributeList;
        if (element == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(4);
        }
        return (attributeList = element.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT);
    }

    @Nullable
    public static JSDuplicatesCheckError checkDuplicatesForVariable(@NotNull JSVariable var) {
        PsiElement nameIdentifier;
        if (var == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(5);
        }
        if ((nameIdentifier = var.getNameIdentifier()) == null) {
            return null;
        }
        PsiElement next = nameIdentifier.getNextSibling();
        String name = nameIdentifier.getText();
        if (next == null || next.getNode().getElementType() instanceof JSElementType || next instanceof PsiWhiteSpace) {
            return DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)var);
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isComputedPropName(@Nullable PsiElement result2) {
        if (!(result2 instanceof JSComputedPropertyNameOwner)) {
            return false;
        }
        ES6ComputedName computedName = ((JSComputedPropertyNameOwner)result2).getComputedPropertyName();
        return computedName != null && computedName.getExpressionAsPropertyName() == null;
    }

    @Nullable
    private static JSDuplicatesCheckError checkForDuplicateDeclaration(@NotNull String name, @NotNull PsiElement decl) {
        PsiElement scope;
        if (name == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(6);
        }
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(7);
        }
        if (JSPsiImplUtils.isCatchParameter(decl)) {
            return null;
        }
        JSElement exportScope = ES6PsiUtil.getExportScope(decl);
        if (exportScope == null) {
            return null;
        }
        if (decl instanceof JSFunctionExpression || decl instanceof TypeScriptFunction && ((TypeScriptFunction)decl).isOverloadDeclaration()) {
            return null;
        }
        BlockContext blockContext = BlockContext.createBlockContext(decl);
        if (blockContext != null && blockContext.myIsEmpty) {
            return null;
        }
        PsiElement psiElement = scope = blockContext != null ? blockContext.myBlock : PsiTreeUtil.getParentOfType((PsiElement)decl, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class, JSPackageStatement.class, PsiFile.class, TypeScriptType.class});
        if (scope instanceof JSPackageStatement || scope instanceof JSEmbeddedContent && scope != exportScope) {
            return null;
        }
        if (scope instanceof JSFile && scope.getContext() != null) {
            scope = scope.getContext().getContainingFile();
        }
        PsiElement place = scope instanceof JSClass ? scope : decl;
        MySinkResolveProcessor processor = new MySinkResolveProcessor(name, place, scope, decl);
        processor.setToProcessActionScriptImplicits(false);
        PsiElement parent = JSResolveUtil.findParent(decl);
        if (parent instanceof JSClass) {
            processor.configureClassScope((JSClass)parent);
        }
        PsiElement startFrom = blockContext != null ? blockContext.myLastStatement : decl;
        PsiElement lastParent = null;
        JSClass clazzOfContext = null;
        if (decl instanceof JSFunction && !(decl instanceof JSFunctionProperty) || decl instanceof JSVariable && blockContext == null || decl instanceof JSNamespaceDeclaration) {
            processor.getAccessibilityProcessingHandler().setProcessStatics(JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.STATIC));
            if (!(parent instanceof XmlBackedJSClass)) {
                if (parent instanceof JSClass) {
                    lastParent = parent;
                } else if (parent != null) {
                    lastParent = parent.getFirstChild();
                }
                startFrom = parent;
            }
            if ((clazzOfContext = DuplicatesCheckUtil.getClassForHierarchyCheck(decl)) != null) {
                if (parent != clazzOfContext) {
                    processor.configureClassScope(clazzOfContext);
                }
                processor.setToProcessHierarchy(true);
            }
        }
        processor.setLocalResolve(true);
        if (DialectDetector.isActionScript(decl)) {
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, startFrom, scope);
        } else if (decl instanceof JSProperty && parent instanceof JSObjectLiteralExpression) {
            JSResolveUtil.processDeclarationsInScope((JSObjectLiteralExpression)parent, processor, ResolveState.initial(), lastParent, startFrom);
        } else {
            JSTreeUtil.processDuplicateDeclarations(decl, processor);
        }
        List<PsiElement> results = processor.getResults();
        if (results == null) {
            return null;
        }
        for (PsiElement result2 : results) {
            String message;
            PsiElement resultParent;
            if (!(result2 instanceof JSElement) || result2 == scope || !result2.isValid() || DuplicatesCheckUtil.isComputedPropName(result2)) continue;
            if (result2 instanceof JSAttributeListOwner && result2 instanceof JSQualifiedNamedElement && decl instanceof JSAttributeListOwner && decl instanceof JSQualifiedNamedElement && JSUtils.isPrivateSharpItem(decl)) {
                JSAttributeList.AccessType resultAccessType = JSPsiImplUtils.getAccessType((JSQualifiedNamedElement)result2);
                JSAttributeList.AccessType declAccessType = JSPsiImplUtils.getAccessType((JSQualifiedNamedElement)decl);
                if ((resultAccessType == JSAttributeList.AccessType.PRIVATE || declAccessType == JSAttributeList.AccessType.PRIVATE) && resultAccessType != declAccessType) {
                    return null;
                }
            }
            if ((resultParent = JSResolveUtil.findParent(result2)) instanceof JSQualifiedNamedElement && "Object".equals(((JSQualifiedNamedElement)resultParent).getQualifiedName())) {
                return null;
            }
            if (DialectDetector.isActionScript(decl) && clazzOfContext != null && scope != null) {
                boolean problemWithinScope;
                boolean bl = problemWithinScope = scope instanceof XmlFile && resultParent == JSResolveUtil.findParent(decl) || PsiTreeUtil.findCommonParent((PsiElement)result2, (PsiElement)scope.getFirstChild()) == scope;
                if (!problemWithinScope) {
                    String namespace = DuplicatesCheckUtil.getActionScriptNamespace(result2);
                    if (decl instanceof JSFunction && result2 instanceof JSFunction && DuplicatesCheckUtil.getActionScriptNamespace(decl).equals(DuplicatesCheckUtil.getActionScriptNamespace(result2))) {
                        return null;
                    }
                    if (resultParent instanceof JSClass) {
                        String qualifiedName = ((JSClass)resultParent).getQualifiedName();
                        String message2 = JavaScriptBundle.message("javascript.validation.message.conflicting.definition.was.found.with.the.same.name", qualifiedName + "." + name, namespace);
                        return new JSDuplicatesCheckError(DuplicatesCheckUtil.isUnconditionalErrorForDuplicate(result2, decl), message2, result2);
                    }
                }
            }
            if (decl instanceof JSVariable && DuplicatesCheckUtil.hasBlockScope((JSVariable)decl)) {
                message = result2 instanceof JSVariable && DuplicatesCheckUtil.hasBlockScope((JSVariable)result2) ? JavaScriptBundle.message("javascript.validation.message.redeclaration.of.block.scope", new Object[0]) : (result2 instanceof JSVariable ? JavaScriptBundle.message("javascript.validation.message.redeclaration.of.block.scope.in.scope.of.var", new Object[0]) : JavaScriptBundle.message("javascript.validation.message.duplicate.declaration", new Object[0]));
                return new JSDuplicatesCheckError(true, message, result2);
            }
            if (result2 instanceof JSVariable && DuplicatesCheckUtil.hasBlockScope((JSVariable)result2)) {
                message = decl instanceof JSVariable ? JavaScriptBundle.message("javascript.validation.message.redeclaration.of.var.in.scope.of.block.scope", new Object[0]) : JavaScriptBundle.message("javascript.validation.message.duplicate.declaration", new Object[0]);
                return new JSDuplicatesCheckError(true, message, result2);
            }
            if (DialectDetector.isES6(decl)) {
                JSFunction function2;
                JSFunction jSFunction = decl instanceof JSFunction ? (JSFunction)decl : (function2 = result2 instanceof JSFunction ? (JSFunction)result2 : null);
                if (function2 != null && (function2.isGetProperty() || function2.isSetProperty())) {
                    JSField other;
                    JSField jSField = other = decl instanceof JSFunction ? (JSField)ObjectUtils.tryCast((Object)result2, JSField.class) : (JSField)ObjectUtils.tryCast((Object)decl, JSField.class);
                    if (other != null) {
                        return null;
                    }
                }
            }
            return new JSDuplicatesCheckError(DuplicatesCheckUtil.isUnconditionalErrorForDuplicate(result2, decl), JavaScriptBundle.message("javascript.validation.message.duplicate.declaration", new Object[0]), result2);
        }
        return null;
    }

    private static boolean isMergeDeclaration(@NotNull PsiElement decl, @NotNull PsiElement result2) {
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(9);
        }
        return DuplicatesCheckUtil.isLeftMergeDeclaration(decl, result2) || DuplicatesCheckUtil.isLeftMergeDeclaration(result2, decl);
    }

    private static boolean isLeftMergeDeclaration(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(10);
        }
        if (right == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(11);
        }
        if (left instanceof ES6ImportSpecifier) {
            return !(right instanceof ES6ImportSpecifier) && !(right instanceof ES6ImportedBinding) && !(right instanceof ES6ImportSpecifierAlias);
        }
        if (left instanceof ES6ImportedBinding) {
            return !(right instanceof ES6ImportSpecifier) && !(right instanceof ES6ImportedBinding) && !(right instanceof ES6ImportSpecifierAlias);
        }
        if (DialectDetector.isTypeScript(left) && (left instanceof TypeScriptModule || left instanceof ES6ImportExportDeclarationPart || left instanceof ES6ExportSpecifierAlias || left instanceof TypeScriptImportStatement)) {
            return true;
        }
        if (left instanceof ES6ClassExpression) {
            return true;
        }
        if (left instanceof TypeScriptClass && TypeScriptPsiUtil.isAmbientDeclaration(left)) {
            return right instanceof TypeScriptFunction && TypeScriptPsiUtil.isAmbientDeclaration(right);
        }
        if (left instanceof TypeScriptClass) {
            return right instanceof TypeScriptInterface;
        }
        if (left instanceof TypeScriptFunctionSignature) {
            return !(right instanceof TypeScriptPropertySignature);
        }
        if (left instanceof TypeScriptPropertySignature) {
            return !(right instanceof TypeScriptTypeMember);
        }
        if (left instanceof TypeScriptFunction) {
            return right instanceof TypeScriptCompileTimeType;
        }
        if (left instanceof TypeScriptEnum) {
            return right instanceof TypeScriptEnum;
        }
        if (left instanceof TypeScriptVariable) {
            return right instanceof TypeScriptCompileTimeType;
        }
        if (left instanceof TypeScriptTypeAlias) {
            return right instanceof TypeScriptVariable || right instanceof TypeScriptFunction;
        }
        if (left instanceof TypeScriptInterface) {
            return !(right instanceof TypeScriptTypeAlias) && !(right instanceof TypeScriptEnum);
        }
        return false;
    }

    private static JSClass getClassForHierarchyCheck(@NotNull PsiElement decl) {
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(12);
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.OVERRIDE)) {
            return null;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.STATIC)) {
            return null;
        }
        if (JSClassUtils.isES6ClassImplementation(decl)) {
            return null;
        }
        return JSResolveUtil.getClassOfContext(decl);
    }

    private static boolean isInLetScope(@NotNull JSVariable let2, @NotNull PsiElement element) {
        PsiElement parent;
        if (let2 == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(13);
        }
        if (element == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(14);
        }
        if ((parent = let2.getParent()) instanceof JSVarStatement) {
            PsiElement commonParent;
            PsiElement blockStatement;
            PsiElement anotherPossibleCommonParent = blockStatement = parent.getParent();
            if (blockStatement instanceof JSBlockStatement && blockStatement.getParent() instanceof JSFunction) {
                anotherPossibleCommonParent = blockStatement.getParent();
            }
            return (commonParent = PsiTreeUtil.findCommonParent((PsiElement)let2, (PsiElement)element)) == blockStatement || commonParent == anotherPossibleCommonParent;
        }
        return false;
    }

    private static boolean hasBlockScope(@NotNull JSVariable decl) {
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(15);
        }
        if (decl.hasBlockScope()) {
            return true;
        }
        JSVarStatement varStatement = decl.getStatement();
        return varStatement != null && DialectDetector.isTypeScript((PsiElement)varStatement) && (varStatement.getVarKeyword() == JSVarStatement.VarKeyword.LET || varStatement.getVarKeyword() == JSVarStatement.VarKeyword.CONST);
    }

    private static boolean checkClassScopes(@NotNull PsiElement decl, @NotNull PsiElement result2) {
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(17);
        }
        if (!(decl instanceof JSClass) || !(result2 instanceof JSClass)) {
            return true;
        }
        if (!ES6PsiUtil.isLocalClass((JSClass)decl) || !ES6PsiUtil.isLocalClass((JSClass)result2)) {
            return true;
        }
        BlockContext declContext = BlockContext.createBlockContextForClass((JSClass)decl);
        BlockContext elementContext = BlockContext.createBlockContextForClass((JSClass)result2);
        if (declContext != null && elementContext != null) {
            return !declContext.myIsEmpty && !elementContext.myIsEmpty && declContext.myBlock == elementContext.myBlock;
        }
        return false;
    }

    private static boolean checkVariableScopes(PsiElement decl, PsiElement result2) {
        boolean declIsLet;
        boolean resultIsLet = result2 instanceof JSVariable && DuplicatesCheckUtil.hasBlockScope((JSVariable)result2);
        boolean bl = declIsLet = decl instanceof JSVariable && DuplicatesCheckUtil.hasBlockScope((JSVariable)decl);
        if (!declIsLet && !resultIsLet) {
            return true;
        }
        BlockContext declContext = BlockContext.createBlockContext(decl);
        BlockContext elementContext = BlockContext.createBlockContext(result2);
        if (declIsLet && resultIsLet && declContext != null && elementContext != null) {
            return !declContext.myIsEmpty && !elementContext.myIsEmpty && declContext.myBlock == elementContext.myBlock;
        }
        if (resultIsLet && DuplicatesCheckUtil.isInLetScope((JSVariable)result2, decl)) {
            return true;
        }
        return declIsLet && DuplicatesCheckUtil.isInLetScope((JSVariable)decl, result2);
    }

    @NotNull
    private static String getActionScriptNamespace(PsiElement result2) {
        JSAttributeList attributeList;
        String namespace = "internal";
        if (result2 instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)result2).getAttributeList()) != null) {
            String ns;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PUBLIC) {
                namespace = "public";
            } else if (accessType == JSAttributeList.AccessType.PROTECTED || accessType == JSAttributeList.AccessType.PRIVATE) {
                namespace = "protected";
            } else if (accessType == JSAttributeList.AccessType.PACKAGE_LOCAL && (ns = ActionScriptPsiImplUtil.getNamespaceValue(attributeList)) != null) {
                namespace = ns;
            }
        }
        String string = namespace;
        if (string == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static boolean isUnconditionalErrorForDuplicate(PsiElement result2, PsiElement decl) {
        boolean unconditionalError;
        boolean bl = unconditionalError = decl.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (unconditionalError) {
            PsiElement declParent = JSResolveUtil.findParent(decl);
            PsiElement resultParent = JSResolveUtil.findParent(result2);
            if (result2 instanceof JSParameter && !(decl instanceof JSParameter) || decl instanceof JSParameter && !(result2 instanceof JSParameter) || decl instanceof JSVariable && !(decl instanceof JSParameter) && result2 instanceof JSVariable && DuplicatesCheckUtil.isLocalVar(declParent) && DuplicatesCheckUtil.isLocalVar(resultParent)) {
                unconditionalError = false;
            }
        } else if ((result2 instanceof JSParameter && decl instanceof JSParameter || result2 instanceof JSProperty && decl instanceof JSProperty) && JSResolveUtil.isEcmaScript5(decl)) {
            unconditionalError = true;
        }
        return unconditionalError;
    }

    private static boolean isLocalVar(PsiElement declParent) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)declParent, (Class[])new Class[]{JSFunction.class}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "let";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionScriptNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicates";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkDefaultExports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeParameterDuplicates";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkExportDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicatesForVariable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkForDuplicateDeclaration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMergeDeclaration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLeftMergeDeclaration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassForHierarchyCheck";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInLetScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkClassScopes";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSDuplicatesCheckError {
        private final boolean myHasErrorSeverity;
        @NotNull
        private final @InspectionMessage String myMessage;
        @Nullable
        private final PsiElement myDuplicatedElement;

        private JSDuplicatesCheckError(boolean hasErrorSeverity, @NotNull @InspectionMessage String message, @Nullable PsiElement duplicatedElement) {
            if (message == null) {
                JSDuplicatesCheckError.$$$reportNull$$$0(0);
            }
            this.myHasErrorSeverity = hasErrorSeverity;
            this.myMessage = message;
            this.myDuplicatedElement = duplicatedElement;
        }

        public boolean hasErrorSeverity() {
            return this.myHasErrorSeverity;
        }

        @NotNull
        @InspectionMessage
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                JSDuplicatesCheckError.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiElement getDuplicatedElement() {
            return this.myDuplicatedElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$JSDuplicatesCheckError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$JSDuplicatesCheckError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySinkResolveProcessor
    extends SinkResolveProcessor<ResolveResultSink> {
        private final PsiElement myDecl;

        MySinkResolveProcessor(String name, PsiElement place, PsiElement scope, PsiElement decl) {
            super(name, place, new ResolveResultSink(scope, name){

                @Override
                public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
                }
            });
            this.myDecl = decl;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
            if (element == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(0);
            }
            if (state2 == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(1);
            }
            if (element == this.myDecl) {
                return true;
            }
            if (DuplicatesCheckUtil.isMergeDeclaration(this.myDecl, element)) {
                return true;
            }
            if (element instanceof TypeScriptFunction && this.myDecl instanceof TypeScriptFunction && (((TypeScriptFunction)this.myDecl).isOverloadImplementation() || ((TypeScriptFunction)element).isOverloadDeclaration() || TypeScriptPsiUtil.isAmbientDeclaration(element))) {
                return true;
            }
            if (!DuplicatesCheckUtil.checkVariableScopes(this.myDecl, element)) {
                return true;
            }
            if (!DuplicatesCheckUtil.checkClassScopes(this.myDecl, element)) {
                return true;
            }
            if (element instanceof JSFunction && this.myDecl instanceof JSFunction) {
                JSFunction declFunction = (JSFunction)this.myDecl;
                JSFunction elementFunction = (JSFunction)element;
                if (declFunction.isGetProperty() && elementFunction.isSetProperty() || declFunction.isSetProperty() && elementFunction.isGetProperty()) {
                    return true;
                }
            } else if (element instanceof JSProperty && this.myDecl instanceof JSProperty) {
                JSProperty elementProperty = (JSProperty)element;
                JSProperty declProperty = (JSProperty)this.myDecl;
                if (declProperty.isGetProperty() && elementProperty.isSetProperty() || declProperty.isSetProperty() && elementProperty.isGetProperty()) {
                    return true;
                }
            }
            if (element instanceof JSFunction && this.myDecl instanceof JSClass && element.getParent() == this.myDecl) {
                return true;
            }
            if (MySinkResolveProcessor.isScopeNamedElement(element) && MySinkResolveProcessor.isScopeNamedElement(this.myDecl)) {
                boolean notStatic;
                JSAttributeList attrList2;
                JSAttributeList attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
                JSAttributeList jSAttributeList = attrList2 = this.myDecl instanceof JSAttributeListOwner ? ((JSAttributeListOwner)this.myDecl).getAttributeList() : null;
                if (attrList != null && attrList2 != null) {
                    String ns = ActionScriptPsiImplUtil.getNamespaceValue(attrList);
                    String ns2 = ActionScriptPsiImplUtil.getNamespaceValue(attrList2);
                    if (ns != null && !ns.equals(ns2) || ns2 != null && !ns2.equals(ns)) {
                        return true;
                    }
                    JSConditionalCompileVariableReference conditionalCompileVar = ActionScriptPsiImplUtil.getConditionalCompileVariableReference(attrList);
                    JSConditionalCompileVariableReference conditionalCompileVar2 = ActionScriptPsiImplUtil.getConditionalCompileVariableReference(attrList2);
                    if (conditionalCompileVar != null && conditionalCompileVar2 != null) {
                        JSReferenceExpression expression = conditionalCompileVar.getExpression();
                        JSReferenceExpression expression2 = conditionalCompileVar2.getExpression();
                        if (expression != null && expression2 != null && !expression.getText().equals(expression2.getText())) {
                            return true;
                        }
                    }
                } else if (attrList != null && ActionScriptPsiImplUtil.getNamespace(attrList) != null || attrList2 != null && ActionScriptPsiImplUtil.getNamespace(attrList2) != null) {
                    return true;
                }
                boolean notStatic2 = attrList2 == null || !attrList2.hasModifier(JSAttributeList.ModifierType.STATIC);
                boolean bl = notStatic = attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
                if (notStatic2 && !notStatic || notStatic && !notStatic2) {
                    return true;
                }
            }
            if (element instanceof ImplicitJSVariableImpl || element instanceof JSImplicitElement) {
                return true;
            }
            if (element instanceof JSDefinitionExpression) {
                return true;
            }
            return super.execute(element, state2);
        }

        private static boolean isScopeNamedElement(@NotNull PsiElement element) {
            if (element == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(2);
            }
            return element instanceof JSAttributeListOwner || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$MySinkResolveProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isScopeNamedElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BlockContext {
        private static final BlockContext EMPTY = new BlockContext(true, null, null);
        private final boolean myIsEmpty;
        private final PsiElement myBlock;
        private final PsiElement myLastStatement;

        private BlockContext(boolean empty, PsiElement block, PsiElement lastStatement) {
            this.myIsEmpty = empty;
            this.myBlock = block;
            this.myLastStatement = lastStatement;
        }

        @Nullable
        public static BlockContext createBlockContext(@NotNull PsiElement decl) {
            if (decl == null) {
                BlockContext.$$$reportNull$$$0(0);
            }
            if (!(decl instanceof JSVariable) || decl instanceof JSParameter || !DuplicatesCheckUtil.hasBlockScope((JSVariable)decl)) {
                return null;
            }
            JSVarStatement parent = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)decl, JSVarStatement.class);
            return BlockContext.getContext((PsiElement)parent);
        }

        @Nullable
        public static BlockContext createBlockContextForClass(@NotNull JSClass decl) {
            if (decl == null) {
                BlockContext.$$$reportNull$$$0(1);
            }
            return BlockContext.getContext(decl);
        }

        private static BlockContext getContext(@Nullable PsiElement statement) {
            if (statement != null) {
                BlockContext prev;
                PsiElement switchStatement;
                BlockContext prev2;
                PsiElement grand = statement.getParent();
                if (grand instanceof JSCaseClause && grand.getParent() instanceof JSSwitchStatement && (prev2 = BlockContext.createBlockContextForBlockHolder(switchStatement = grand.getParent())) != null) {
                    return prev2;
                }
                if (grand instanceof JSBlockStatement && grand.getParent() instanceof JSFunction && (prev = BlockContext.createBlockContextForBlockHolder(grand.getParent())) != null) {
                    return prev;
                }
                if ((grand instanceof JSBlockStatement || grand instanceof PsiFile || grand instanceof JSEmbeddedContent) && (prev = BlockContext.createBlockContextForBlockHolder(grand)) != null) {
                    return prev;
                }
            }
            return EMPTY;
        }

        @Nullable
        private static BlockContext createBlockContextForBlockHolder(PsiElement grand) {
            JSElement last;
            JSElement prev = last = BlockContext.getLastChild(grand);
            boolean hadBlock = grand instanceof JSBlockStatement;
            while (last != null) {
                prev = last;
                boolean isBlock = last instanceof JSBlockStatement;
                JSElement jSElement = last = hadBlock && isBlock ? null : BlockContext.getLastChild((PsiElement)last);
                if (!isBlock) continue;
                hadBlock = true;
            }
            if (prev != null) {
                return new BlockContext(false, grand, (PsiElement)prev);
            }
            return null;
        }

        @Nullable
        private static JSElement getLastChild(PsiElement grand) {
            JSElement last = null;
            for (JSElement next : SyntaxTraverser.psiTraverser().children((Object)grand).filter(JSElement.class)) {
                if (!(next instanceof JSCaseClause) && !(next instanceof JSSourceElement)) continue;
                last = next;
            }
            return last;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "decl";
            objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$BlockContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBlockContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBlockContextForClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

