/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSSyntaxHighlighterFactory;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSSemanticKeywordHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final HighlightInfoHolder myHolder;

    public JSSemanticKeywordHighlighter(@NotNull PsiFile file2, @NotNull Document document2) {
        if (file2 == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), document2);
        this.myFile = file2;
        this.myHolder = new HighlightInfoHolder(file2, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(2);
        }
        this.myHolder.clear();
        if (this.myFile instanceof JSFile) {
            JSAnalysisHandlersFactory factory = JSAnalysisHandlersFactory.forElement((PsiElement)this.myFile);
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myFile);
            if (holder == null) {
                holder = JSSyntaxHighlighterFactory.DEFAULT_HIGHLIGHTER_DIALECT;
            }
            this.myFile.acceptChildren((PsiElementVisitor)factory.createKeywordHighlighterVisitor(this.myHolder, holder));
        } else {
            JSIndexContent.acceptChildren(this.myFile, new JSRecursiveWalkingElementVisitor(){

                @Override
                public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                    JSAnalysisHandlersFactory factory = JSAnalysisHandlersFactory.forElement((PsiElement)embeddedContent);
                    DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)embeddedContent);
                    if (holder == null) {
                        holder = JSSyntaxHighlighterFactory.DEFAULT_HIGHLIGHTER_DIALECT;
                    }
                    embeddedContent.acceptChildren(factory.createKeywordHighlighterVisitor(JSSemanticKeywordHighlighter.this.myHolder, holder));
                }
            });
        }
    }

    public void doApplyInformationToEditor() {
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        for (int i2 = 0; i2 < this.myHolder.size(); ++i2) {
            highlights.add(this.myHolder.get(i2));
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSSemanticKeywordHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

