/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementJSDocMethodsFix
extends BaseCreateMembersFix<JSElement>
implements LocalQuickFix {
    final String myClassName;
    final Map<JSMethodToImplement.MethodKey, JSMethodToImplement> myNonImplemented;

    public ImplementJSDocMethodsFix(@NotNull String className2, Map<JSMethodToImplement.MethodKey, JSMethodToImplement> nonImplemented) {
        if (className2 == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(0);
        }
        super(null);
        this.myClassName = className2;
        this.myNonImplemented = nonImplemented;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.implement.methods", new Object[0]);
        if (string == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(2);
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiElement declarationOwner = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSSourceElement.class, JSObjectLiteralExpression.class});
        if (declarationOwner == null) {
            return;
        }
        this.doImplement(project, declarationOwner, true);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSSourceElement declarationOwner;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(4);
        }
        if ((declarationOwner = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSSourceElement.class, (boolean)false)) == null) {
            return;
        }
        this.doImplement(project, (PsiElement)declarationOwner, false);
    }

    private static String getPrefix(JSMethodToImplement methodToImplement) {
        if (methodToImplement.isGetAccessor()) {
            return "get ";
        }
        if (methodToImplement.isSetAccessor()) {
            return "set ";
        }
        Object prefix = "";
        if (methodToImplement.isAsync()) {
            prefix = (String)prefix + "async ";
        }
        if (methodToImplement.isGenerator()) {
            prefix = (String)prefix + "*";
        }
        return prefix;
    }

    private void doImplement(@NotNull Project project, @NotNull PsiElement declarationOwner, boolean filterElements) {
        JSClass classOfContext;
        JSExpression initializerOrStub;
        JSVariable[] variables;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(5);
        }
        if (declarationOwner == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(6);
        }
        if (declarationOwner instanceof JSVarStatement && (variables = ((JSVarStatement)declarationOwner).getVariables()).length == 1 && (initializerOrStub = variables[0].getInitializerOrStub()) instanceof JSClassExpression) {
            declarationOwner = initializerOrStub;
        }
        if (declarationOwner instanceof JSFunction && ((JSFunction)declarationOwner).isConstructor() && (classOfContext = JSResolveUtil.getClassOfContext(declarationOwner)) != null) {
            declarationOwner = classOfContext;
        }
        Set elementsToProcess = filterElements ? this.getElementsToProcess() : null;
        Set names = elementsToProcess == null ? null : elementsToProcess.stream().map(e -> JSMethodToImplement.MethodKey.create(e)).collect(Collectors.toSet());
        Set<Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement>> entries = this.myNonImplemented.entrySet();
        ArrayList<Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement>> sortedEntries = new ArrayList<Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement>>(entries);
        sortedEntries.sort(Comparator.comparing(e -> ((JSMethodToImplement.MethodKey)e.getKey()).getName()));
        ArrayList<FormatFixer> formatFixers = new ArrayList<FormatFixer>();
        if (declarationOwner instanceof JSClass || declarationOwner instanceof JSObjectLiteralExpression) {
            for (Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement> method : sortedEntries) {
                if (names != null && !names.contains(method.getKey())) continue;
                PsiElement element = ImplementJSDocMethodsFix.implementSingleMethodForClassOrLiteral(project, declarationOwner, method.getValue());
                if (element == null) {
                    return;
                }
                formatFixers.add(FormatFixer.create(element, FormatFixer.Mode.Reformat));
            }
            FormatFixer.fixAll(formatFixers);
        } else {
            Collections.reverse(sortedEntries);
            for (Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement> method : sortedEntries) {
                JSMethodToImplement value;
                if (names != null && !names.contains(method.getKey()) || !(value = method.getValue()).isFunction() || ImplementJSDocMethodsFix.implementSingleMethodViaPrototype(project, this.myClassName, declarationOwner, value)) continue;
                return;
            }
        }
    }

    private static boolean implementSingleMethodViaPrototype(@NotNull Project project, String className2, @NotNull PsiElement declarationOwner, @NotNull JSMethodToImplement value) {
        String builder;
        ASTNode createdMethod;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(7);
        }
        if (declarationOwner == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(8);
        }
        if (value == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(9);
        }
        if ((createdMethod = JSChangeUtil.createJSTreeFromTextWithContext(builder = String.format("%s.prototype.%s = function%s{%s};", className2, value.getName(), value.getParameterList(), CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(false, project, false, value.getReturnType(), value.getName())), declarationOwner)) == null) {
            return false;
        }
        PsiElement methodImplementation = createdMethod.getPsi();
        declarationOwner.getParent().addAfter(methodImplementation, declarationOwner);
        return true;
    }

    @Nullable
    private static PsiElement implementSingleMethodForClassOrLiteral(@NotNull Project project, @NotNull PsiElement declarationOwner, @NotNull JSMethodToImplement value) {
        String declaration;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(10);
        }
        if (declarationOwner == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(11);
        }
        if (value == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(12);
        }
        String string = declaration = value.isFunction() ? ImplementJSDocMethodsFix.formatFunction(declarationOwner, project, value) : ImplementJSDocMethodsFix.formatProperty(declarationOwner, value);
        if (declarationOwner instanceof JSClass) {
            JSSourceElement methodImplementation = JSChangeUtil.createClassMemberPsiFromTextWithContext(declaration, declarationOwner, JSSourceElement.class);
            if (methodImplementation == null) {
                return null;
            }
            return JSRefactoringUtil.addMemberToTargetClass((JSClass)declarationOwner, (PsiElement)methodImplementation);
        }
        PsiElement property = JSChangeUtil.createObjectLiteralPropertyFromText(declaration, declarationOwner);
        if (property == null) {
            return null;
        }
        return JSRefactoringUtil.addMemberToMemberHolder(declarationOwner, property, declarationOwner);
    }

    @NotNull
    private static String formatProperty(@NotNull PsiElement declarationOwner, @NotNull JSMethodToImplement value) {
        if (declarationOwner == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(13);
        }
        if (value == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(14);
        }
        String string = String.format("%s%s", value.getName(), declarationOwner instanceof JSClass ? "" : ": " + JSRefactoringUtil.defaultValueOfType(value.getReturnType()));
        if (string == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String formatFunction(@NotNull PsiElement declarationOwner, @NotNull Project project, @NotNull JSMethodToImplement value) {
        if (declarationOwner == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(16);
        }
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(17);
        }
        if (value == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(18);
        }
        String prefix = ImplementJSDocMethodsFix.getPrefix(value);
        String name = value.getName();
        String parameterList = value.getParameterList();
        String bodyText = CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(false, project, false, value.getReturnType(), name);
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(declarationOwner);
        String string = declarationOwner instanceof JSClass || dialect != null && (dialect.isTypeScript || dialect.isFlow || dialect.isECMA6) ? String.format("%s%s %s \n{\n  %s}", prefix, name, parameterList, bodyText) : String.format("%s: %s function %s \n{\n  %s}", name, prefix, parameterList, bodyText);
        if (string == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOwner";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatProperty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doImplement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "implementSingleMethodViaPrototype";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "implementSingleMethodForClassOrLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatProperty";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

