/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListWrapper {
    public static final JSAttributeList.ModifierType[] MODIFIERS = new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.EXPORT, JSAttributeList.ModifierType.DECLARE, JSAttributeList.ModifierType.CONST, JSAttributeList.ModifierType.OVERRIDE, JSAttributeList.ModifierType.VIRTUAL, JSAttributeList.ModifierType.STATIC, JSAttributeList.ModifierType.ABSTRACT, JSAttributeList.ModifierType.READONLY, JSAttributeList.ModifierType.FINAL, JSAttributeList.ModifierType.NATIVE, JSAttributeList.ModifierType.DYNAMIC, JSAttributeList.ModifierType.ASYNC};
    @Nullable
    private final JSAttributeList myAttributeList;
    @Nullable
    private JSAttributeList.AccessType myAccessTypeOverride;
    private final Map<JSAttributeList.ModifierType, Boolean> myModifiers;
    @Nullable
    private String myNamespace;
    private final List<Attribute> myAdditionalAttributes;
    private boolean myRemoveOriginalAttributes;
    private boolean myNullAccessModifier;
    private boolean myForcePrivateSharp;
    private static final Function<JSAttributeNameValuePair, Pair<String, String>> VALUE_MAPPER = pair -> Pair.create((Object)pair.getName(), (Object)pair.getSimpleValue());
    private static final Function<JSAttribute, Attribute> ATTRIBUTE_MAPPER = jsAttribute -> new Attribute(jsAttribute.getName(), ContainerUtil.map((Object[])jsAttribute.getValues(), VALUE_MAPPER));

    public void setForcePrivateSharp(boolean forcePrivateSharp) {
        this.myForcePrivateSharp = forcePrivateSharp;
    }

    @Nullable
    private String getConditionalCompileVariableReference() {
        if (this.myAttributeList == null) {
            return null;
        }
        JSConditionalCompileVariableReference ref = ActionScriptPsiImplUtil.getConditionalCompileVariableReference(this.myAttributeList);
        return ref != null ? ref.getText() : null;
    }

    public JSAttributeListWrapper(@NotNull JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(0);
        }
        this(attributeListOwner.getAttributeList());
    }

    public JSAttributeListWrapper(@Nullable JSAttributeList attributeList) {
        this.myModifiers = new HashMap<JSAttributeList.ModifierType, Boolean>();
        this.myAdditionalAttributes = new ArrayList<Attribute>();
        this.myAttributeList = attributeList;
    }

    public void overrideAccessType(@NotNull JSAttributeList.AccessType accessTypeOverride) {
        if (accessTypeOverride == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(1);
        }
        this.myAccessTypeOverride = accessTypeOverride;
        this.myNamespace = null;
        this.myNullAccessModifier = false;
    }

    public void overrideNamespace(@NotNull String namespace) {
        if (namespace == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(2);
        }
        this.myNamespace = namespace;
        this.myAccessTypeOverride = null;
        this.myNullAccessModifier = false;
    }

    public void removeAccessModifier() {
        this.myNullAccessModifier = true;
    }

    @Nullable
    private JSAttributeList.AccessType getAccessType() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myAccessTypeOverride != null) {
            return this.myAccessTypeOverride;
        }
        if (this.myNamespace != null) {
            return null;
        }
        return this.myAttributeList != null ? this.myAttributeList.getExplicitAccessType() : null;
    }

    @Nullable
    private String getNamespace() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myNamespace != null) {
            return this.myNamespace;
        }
        if (this.myAccessTypeOverride != null) {
            return null;
        }
        return ActionScriptPsiImplUtil.getNamespace(this.myAttributeList);
    }

    private boolean hasModifier(JSAttributeList.ModifierType modifierType) {
        Boolean flag = this.myModifiers.get((Object)modifierType);
        if (flag != null) {
            return flag;
        }
        if (this.myAttributeList == null) {
            return false;
        }
        JSAttributeListStub stub = (JSAttributeListStub)this.myAttributeList.getStub();
        return stub != null ? stub.hasModifier(modifierType) : this.myAttributeList.hasExplicitModifier(modifierType);
    }

    public void overrideModifier(JSAttributeList.ModifierType modifierType, boolean exists) {
        this.myModifiers.put(modifierType, exists);
    }

    public void addAttribute(String name, String valueName, String value) {
        this.myAdditionalAttributes.add(new Attribute(name, Collections.singletonList(Pair.create((Object)valueName, (Object)value))));
    }

    private List<Attribute> getAttributes() {
        ArrayList<Attribute> result2 = new ArrayList<Attribute>();
        if (this.myAttributeList != null && !this.myRemoveOriginalAttributes) {
            result2.addAll(ContainerUtil.map((Object[])this.myAttributeList.getAttributes(), ATTRIBUTE_MAPPER));
        }
        result2.addAll(this.myAdditionalAttributes);
        return result2;
    }

    public String computeText(@NotNull JSAttributeListOwner targetElement, @Nullable DialectOptionHolder dialectOptionHolder, boolean isForNewClassMember) {
        JSAttributeList.AccessType accessType;
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(3);
        }
        StringBuilder result2 = new StringBuilder();
        for (Attribute attribute : this.getAttributes()) {
            JSAttributeListWrapper.appendWithSpace(result2, "[");
            result2.append(attribute.name);
            if (attribute.getSimpleValue() != null) {
                result2.append("(\"").append(attribute.getSimpleValue()).append("\")");
            } else if (!attribute.nameValuePairs.isEmpty()) {
                result2.append("(");
                for (int i2 = 0; i2 < attribute.nameValuePairs.size(); ++i2) {
                    if (i2 > 0) {
                        result2.append(",");
                    }
                    Pair<String, String> value = attribute.nameValuePairs.get(i2);
                    result2.append((String)value.first).append("=\"").append((String)value.second).append("\"");
                }
                result2.append(")");
            }
            result2.append("]");
        }
        String compileVariableReference = this.getConditionalCompileVariableReference();
        if (compileVariableReference != null) {
            JSAttributeListWrapper.appendWithSpace(result2, compileVariableReference);
        }
        if (this.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && dialectOptionHolder != null && dialectOptionHolder.isECMA4) {
            JSAttributeListWrapper.appendWithSpace(result2, JSAttributeList.ModifierType.OVERRIDE.keyword);
        }
        if ((accessType = this.getAccessType()) == null && dialectOptionHolder != null && dialectOptionHolder.isTypeScript) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        }
        boolean appendPrivateSharp = false;
        if (accessType != null) {
            String keyword;
            if (accessType == JSAttributeList.AccessType.PRIVATE && dialectOptionHolder != null && dialectOptionHolder.hasFeature(JSLanguageFeature.PRIVATE_SHARP_SYNTAX) && (this.myForcePrivateSharp || (!dialectOptionHolder.isTypeScript || this.myAttributeList != null && JSUtils.isPrivateSharpItem(this.myAttributeList.getParent())) && this.myAttributeList != null && this.myAttributeList.getExplicitAccessType() == accessType)) {
                appendPrivateSharp = true;
            } else if (this.needClassAccessKeyword(accessType, targetElement, dialectOptionHolder, isForNewClassMember) && !StringUtil.isEmpty((String)(keyword = JSVisibilityUtil.getVisibilityKeyword(accessType)))) {
                JSAttributeListWrapper.appendWithSpace(result2, keyword);
            }
        } else {
            String namespace = this.getNamespace();
            if (namespace != null) {
                JSAttributeListWrapper.appendWithSpace(result2, namespace);
            }
        }
        for (JSAttributeList.ModifierType modifier : MODIFIERS) {
            if (modifier == JSAttributeList.ModifierType.OVERRIDE && (dialectOptionHolder == null || dialectOptionHolder.isECMA4) || !this.hasModifier(modifier)) continue;
            JSAttributeListWrapper.appendWithSpace(result2, modifier.keyword);
        }
        if (appendPrivateSharp) {
            result2.append("#");
        }
        return result2.toString();
    }

    private boolean needClassAccessKeyword(@NotNull JSAttributeList.AccessType accessType, @NotNull JSAttributeListOwner targetElement, @Nullable DialectOptionHolder dialectOptionHolder, boolean isForNewClassMember) {
        if (accessType == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(4);
        }
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(5);
        }
        if (!DialectDetector.hasFeature(dialectOptionHolder, JSLanguageFeature.VISIBILITY_MODIFIERS)) {
            return false;
        }
        return dialectOptionHolder.isECMA4 || accessType != JSAttributeList.AccessType.PUBLIC || this.shouldAddPublicModifier(dialectOptionHolder, targetElement, isForNewClassMember);
    }

    private boolean shouldAddPublicModifier(@Nullable DialectOptionHolder dialectOptionHolder, @NotNull JSAttributeListOwner targetElement, boolean isForNewClassMember) {
        PsiElement accessTypeElement;
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(6);
        }
        if (dialectOptionHolder == null || !dialectOptionHolder.isTypeScript || this.myNullAccessModifier) {
            return false;
        }
        if (targetElement instanceof JSParameter) {
            return this.myAttributeList == null || this.myRemoveOriginalAttributes || !this.myAttributeList.hasModifier(JSAttributeList.ModifierType.READONLY) && !this.myAttributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
        }
        if (isForNewClassMember) {
            return TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)targetElement).USE_PUBLIC_MODIFIER;
        }
        return this.myAttributeList != null && (accessTypeElement = this.myAttributeList.findAccessTypeElement()) != null && accessTypeElement.getNode().getElementType() == JSTokenTypes.PUBLIC_KEYWORD;
    }

    public void removeOriginalAttributes() {
        this.myRemoveOriginalAttributes = true;
    }

    public void applyTo(@NotNull JSAttributeListOwner targetElement) {
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(7);
        }
        this.applyTo(targetElement, false);
    }

    public void applyTo(@NotNull JSAttributeListOwner targetElement, boolean isForNewClassMember) {
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(8);
        }
        JSAttributeList attributeList = targetElement.getAttributeList();
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)targetElement);
        DialectOptionHolder dialectOptionHolder = languageDialect != null ? languageDialect.getOptionHolder() : null;
        String text = this.computeText(targetElement, dialectOptionHolder, isForNewClassMember);
        if (targetElement instanceof JSVariable && targetElement.getParent() instanceof JSAttributeListOwner) {
            targetElement = (JSAttributeListOwner)targetElement.getParent();
        }
        if (text.length() > 0) {
            PsiElement nextSibling;
            PsiElement insertBefore;
            Object functionStr = languageDialect != null && languageDialect.getOptionHolder().isECMA4 ? " function " : " ";
            String sharp = "";
            if (text.endsWith("#")) {
                text = text.substring(0, text.length() - 1).trim();
                sharp = "#";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.GET)) {
                functionStr = (String)functionStr + "get ";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.SET)) {
                functionStr = (String)functionStr + "set ";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.GENERATOR)) {
                functionStr = (String)functionStr + " *";
            }
            JSAttributeList newAttributeList = this.createAttributeList(targetElement, text, (String)functionStr, sharp);
            JSRefactoringUtil.copyDecorators(attributeList, newAttributeList);
            if (attributeList == null) {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)targetElement, JSDocComment.class);
                insertBefore = docComment != null ? docComment.getNextSibling() : targetElement.getFirstChild();
            } else if (attributeList.getFirstChild() == null) {
                insertBefore = attributeList.getNextSibling();
                attributeList.delete();
            } else {
                nextSibling = attributeList.getNextSibling();
                while (nextSibling instanceof PsiWhiteSpace) {
                    nextSibling = nextSibling.getNextSibling();
                }
                insertBefore = nextSibling;
                targetElement.deleteChildRange((PsiElement)attributeList, insertBefore.getPrevSibling());
            }
            nextSibling = newAttributeList.getNextSibling();
            targetElement.addRangeBefore((PsiElement)newAttributeList, (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : newAttributeList), insertBefore);
        } else if (attributeList != null) {
            if (attributeList.getNode().getChildren(null).length == 0) {
                return;
            }
            PsiElement firstChild = attributeList.getFirstChild();
            PsiElement lastChild = attributeList.getLastChild();
            boolean hasGet = attributeList.hasModifier(JSAttributeList.ModifierType.GET);
            boolean hasSet = attributeList.hasModifier(JSAttributeList.ModifierType.SET);
            boolean hasGenerator = attributeList.hasModifier(JSAttributeList.ModifierType.GENERATOR);
            JSAttributeList newAttributeList = null;
            if (hasGet || hasSet || hasGenerator) {
                StringJoiner str = new StringJoiner(" ", "", " ");
                if (hasGet) {
                    str.add("get");
                }
                if (hasSet) {
                    str.add("set");
                }
                if (hasGenerator) {
                    str.add("*");
                }
                newAttributeList = this.createAttributeList(targetElement, str.toString(), "", "");
            }
            if (newAttributeList == null) {
                newAttributeList = (JSAttributeList)JSChangeUtil.createCompositeElementWithDummyHolder((PsiElement)attributeList, JSStubElementTypes.ATTRIBUTE_LIST).getPsi();
            }
            if (newAttributeList != null) {
                JSRefactoringUtil.copyDecorators(attributeList, newAttributeList);
            }
            if (newAttributeList != null) {
                PsiElement nextSibling = newAttributeList.getNextSibling();
                targetElement.addRangeBefore((PsiElement)newAttributeList, (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : newAttributeList), (PsiElement)attributeList);
            }
            if (firstChild != null) {
                if (lastChild instanceof LeafPsiElement && ((LeafPsiElement)lastChild).getElementType() == JSTokenTypes.SHARP) {
                    targetElement.deleteChildRange((PsiElement)attributeList, (PsiElement)attributeList);
                } else {
                    targetElement.deleteChildRange((PsiElement)attributeList, attributeList.getNextSibling());
                    if (targetElement.getAttributeList() != null && targetElement.getAttributeList().getChildren().length == 0 && targetElement instanceof TypeScriptPropertySignature) {
                        targetElement.getAttributeList().delete();
                    }
                }
            }
        }
    }

    @NotNull
    private JSAttributeList createAttributeList(@NotNull JSAttributeListOwner targetElement, String text, String classFunctionPrefix, String sharp) {
        boolean isModuleMember;
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(9);
        }
        boolean bl = isModuleMember = this.hasModifier(JSAttributeList.ModifierType.EXPORT) || this.hasModifier(JSAttributeList.ModifierType.DECLARE);
        JSAttributeListOwner dummyDeclaration = targetElement instanceof JSClass ? JSPsiElementFactory.createJSClass(text + " class dummy {}", (PsiElement)targetElement) : (isModuleMember ? (JSAttributeListOwner)JSPsiElementFactory.createJSSourceElement(text + " function dummy(){}", (PsiElement)targetElement, JSFunction.class) : (JSAttributeListOwner)JSChangeUtil.createClassMemberPsiFromTextWithContext(text + classFunctionPrefix + sharp + "dummy(){ }", (PsiElement)targetElement, JSFunction.class));
        JSAttributeList jSAttributeList = Objects.requireNonNull(((JSAttributeListOwner)Objects.requireNonNull(dummyDeclaration)).getAttributeList());
        if (jSAttributeList == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(10);
        }
        return jSAttributeList;
    }

    private static void appendWithSpace(StringBuilder s, String text) {
        if (s.length() > 0) {
            s.append(" ");
        }
        s.append(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeListOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessTypeOverride";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "overrideAccessType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "overrideNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "needClassAccessKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddPublicModifier";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeList";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Attribute {
        public final String name;
        public final List<Pair<String, String>> nameValuePairs;

        @Nullable
        public String getSimpleValue() {
            return this.nameValuePairs.size() == 1 && this.nameValuePairs.get((int)0).first == null ? (String)this.nameValuePairs.get((int)0).second : null;
        }

        Attribute(String name, List<Pair<String, String>> nameValuePairs) {
            this.name = name;
            this.nameValuePairs = Collections.unmodifiableList(nameValuePairs);
        }
    }
}

