/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInsertTypeGuardFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myName;
    private final TypeGuardSurroundKind mySurroundKind;
    private final String myDiscriminatedPropertyName;
    private final boolean myIsNegative;
    private final boolean myAllowSimplifyForNullable;
    private static final String myTypeOfTemplate = "typeof %s === %s";
    private static final String myTypeOfNegativeTemplate = "typeof %s !== %s";
    private static final String myInstanceOfTemplate = "%s instanceof %s";
    private final JSType myType;
    private final String myPropertyNameForInGuard;
    private boolean myShowInGuard;

    public TypeScriptInsertTypeGuardFix(@Nullable PsiElement element, @NotNull JSType type, @NotNull TypeScriptTypeGuardFixHelper.JSTypeGuardFixData data) {
        if (type == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myShowInGuard = false;
        this.myType = type;
        this.myName = type.getTypeText(JSType.TypeTextFormat.CODE);
        this.mySurroundKind = data.getSurroundKind();
        this.myDiscriminatedPropertyName = data.getDiscriminatedPropertyName();
        this.myIsNegative = data.isNegative();
        this.myAllowSimplifyForNullable = data.isAllowSimplifyForNullable();
        this.myPropertyNameForInGuard = data.getPropertyNameForInGuard();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(5);
        }
        PsiElement parent = this.computeParent(startElement);
        if (this.mySurroundKind.isChainingOp()) {
            if (!(parent instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof JSElvisOwner)) {
                return false;
            }
            if (this.mySurroundKind == TypeGuardSurroundKind.OptionalChaining) {
                return !(grandParent instanceof JSReferenceExpression) || grandParent.getNode().findChildByType(JSTokenTypes.DOT) != null;
            }
            return true;
        }
        if (!(this.myDiscriminatedPropertyName != null || this.isTypeOfMember(this.myName) || this.myType instanceof JSNullType || this.myType instanceof JSUndefinedType || this.myType instanceof JSResolvableType)) {
            return false;
        }
        if (this.myDiscriminatedPropertyName == null && !this.isTypeOfMember(this.myName) && this.myType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)this.myType).resolveType();
            JSClass clazz = info.getDeclarationOfType(JSClass.class);
            if (clazz == null) {
                return false;
            }
            if (clazz.isInterface() || clazz instanceof TypeScriptTypeAlias) {
                this.myShowInGuard = true;
                return this.myPropertyNameForInGuard != null && this.mySurroundKind != TypeGuardSurroundKind.SwitchStatement;
            }
        }
        if (this.myDiscriminatedPropertyName == null && TypeScriptUtil.hasAmbientExternalModuleInQName(this.myName) && TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement))) {
            return false;
        }
        Object qualifier = startElement;
        while (qualifier != null && !(qualifier instanceof JSThisExpression)) {
            if (!(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            qualifier = ((JSReferenceExpression)qualifier).getQualifier();
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return false;
        }
        if (variable.getJSType() instanceof JSPrimitiveType && (!(variable instanceof JSParameter) || !((JSParameter)variable).isOptional()) && this.isTypeOfMember(this.myName)) {
            return false;
        }
        String name = variable.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if ((this.mySurroundKind == TypeGuardSurroundKind.IfStatement || this.mySurroundKind == TypeGuardSurroundKind.SwitchStatement) && (parent instanceof JSExpressionStatement || parent instanceof JSVarStatement)) {
            return true;
        }
        return (this.mySurroundKind == TypeGuardSurroundKind.Ternary || this.mySurroundKind == TypeGuardSurroundKind.And || this.mySurroundKind == TypeGuardSurroundKind.Or) && parent instanceof JSExpression;
    }

    @Nullable
    private static JSFieldVariable getResolvedVariable(@Nullable PsiElement startElement) {
        PsiElement resolve;
        if (startElement instanceof JSVariable) {
            return (JSVariable)startElement;
        }
        if (startElement instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)startElement).resolve()) instanceof JSFieldVariable) {
            return (JSFieldVariable)resolve;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            return;
        }
        PsiElement parent = this.computeParent(startElement);
        if (parent == null) {
            return;
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.OptionalChaining) {
            JSChangeUtil.setElvisAfter(startElement);
            return;
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.NullishCoalescing) {
            JSExpression qualifier;
            PsiElement grandParent = startElement.getParent();
            JSExpression jSExpression = qualifier = grandParent instanceof JSReferenceExpression ? ((JSReferenceExpression)grandParent).getQualifier() : (JSExpression)startElement;
            assert (qualifier != null);
            JSParenthesizedExpression newQualifier = (JSParenthesizedExpression)qualifier.replace(JSPsiElementFactory.createJSExpression("(" + qualifier.getText() + "?? x)", (PsiElement)qualifier));
            int offset = ((JSBinaryExpression)newQualifier.getInnerExpression()).getROperand().getTextRange().getEndOffset();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getDocument().replaceString(offset, offset + 1, (CharSequence)"");
            editor.getCaretModel().moveToOffset(offset);
            return;
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return;
        }
        String shortenedType = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        boolean isTypeOf = this.isTypeOfMember(shortenedType);
        String name = startElement instanceof JSVariable ? variable.getName() : startElement.getText();
        Template template = templateManager.createTemplate("", "", String.format(this.getTemplate(shortenedType), name, isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(shortenedType) : shortenedType));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = parent.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + parent.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, parent.getText(), template);
    }

    @Nullable
    private PsiElement computeParent(@NotNull PsiElement startElement) {
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(10);
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.IfStatement || this.mySurroundKind == TypeGuardSurroundKind.SwitchStatement) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        }
        return this.getOwnerExpression(startElement);
    }

    @Nullable
    private JSExpression getOwnerExpression(@Nullable PsiElement expression) {
        if (!(expression instanceof JSExpression)) {
            return null;
        }
        if (this.mySurroundKind.isChainingOp()) {
            return (JSExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        }
        PsiElement parentExpression = expression.getParent();
        if (parentExpression instanceof JSCallExpression) {
            return this.getOwnerExpression(parentExpression);
        }
        if (parentExpression instanceof JSReferenceExpression) {
            return this.getOwnerExpression(parentExpression);
        }
        if (parentExpression instanceof JSBinaryExpression) {
            if (((JSBinaryExpression)parentExpression).getROperand() == expression) {
                IElementType sign = ((JSBinaryExpression)parentExpression).getOperationSign();
                if (!(this.mySurroundKind != TypeGuardSurroundKind.And && this.mySurroundKind != TypeGuardSurroundKind.Or || sign != JSTokenTypes.ANDAND && sign != JSTokenTypes.OROR)) {
                    return (JSExpression)expression;
                }
            }
            return (JSExpression)parentExpression;
        }
        return (JSExpression)expression;
    }

    public boolean isTypeOfMember(@NotNull String typeofWrapType) {
        if (typeofWrapType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(11);
        }
        return ArrayUtil.contains((String)typeofWrapType, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    private static String wrapWithQuotes(@NotNull String shortenedType) {
        if (shortenedType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(12);
        }
        String string = "\"" + shortenedType + "\"";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getText() {
        return this.getActionText();
    }

    private boolean isSurround() {
        switch (this.mySurroundKind) {
            case IfStatement: 
            case SwitchStatement: {
                return true;
            }
            case Ternary: 
            case And: 
            case Or: 
            case OptionalChaining: 
            case NullishCoalescing: {
                return false;
            }
        }
        return true;
    }

    @NotNull
    @IntentionName
    private String getActionText() {
        String string = JavaScriptBundle.message(this.mySurroundKind == TypeGuardSurroundKind.NullishCoalescing ? (this.getStartElement().getParent() instanceof JSReferenceExpression ? "typescript.insert.type.guard.nc" : "typescript.insert.type.guard.nc.self") : (this.isSurround() ? "typescript.insert.type.guard.surround" : (this.mySurroundKind == TypeGuardSurroundKind.OptionalChaining && !(this.getStartElement().getParent() instanceof JSReferenceExpression) ? "typescript.insert.type.guard.postfix" : "typescript.insert.type.guard.prefix")), this.createGuardTextDescription());
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String getTemplate(String typeName) {
        String template = this.myShowInGuard ? this.getInGuardTemplate() : (this.myDiscriminatedPropertyName != null ? this.computeTemplateForDiscriminator() : (this.myType instanceof JSNullType || this.myType instanceof JSUndefinedType ? this.computeTemplateForNullable() : this.computeTypeOfOrInstanceOfTemplate(typeName)));
        switch (this.mySurroundKind) {
            case IfStatement: {
                String string = "if (" + template + ") {$SELECTION$}";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(15);
                }
                return string;
            }
            case Ternary: {
                String string = template + " ? $SELECTION$ : $END$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(16);
                }
                return string;
            }
            case And: {
                String string = template + " && $SELECTION$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(17);
                }
                return string;
            }
            case Or: {
                String string = template + " || $SELECTION$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(18);
                }
                return string;
            }
            case SwitchStatement: {
                assert (this.myDiscriminatedPropertyName != null);
                String string = "switch (%s." + this.myDiscriminatedPropertyName + ") { case %s: $SELECTION$ }";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(19);
                }
                return string;
            }
            case OptionalChaining: {
                return "?.";
            }
            case NullishCoalescing: {
                return "(%s ?? $SELECTION$)";
            }
        }
        throw new NotImplementedError("Unknown surround kind: " + ((Object)((Object)this.mySurroundKind)).getClass());
    }

    @NotNull
    private String getInGuardTemplate() {
        String quote = JSCodeStyleSettings.getQuote(this.getStartElement());
        StringBuilder builder = new StringBuilder(quote);
        JSStringUtil.escapeSimpleStringChars(this.myPropertyNameForInGuard, quote.charAt(0), true, false, false, builder);
        builder.append(quote);
        String string = builder + " in %s";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private String computeTemplateForDiscriminator() {
        boolean shouldNegateCondition = this.shouldNegateCondition();
        if (this.myType instanceof JSBooleanLiteralTypeImpl) {
            boolean literal = ((JSBooleanLiteralTypeImpl)this.myType).getLiteral();
            boolean negate = literal == shouldNegateCondition;
            String template = "%s." + this.myDiscriminatedPropertyName;
            String string = negate ? "!(" + template + ")" : template;
            if (string == null) {
                TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = "%s." + this.myDiscriminatedPropertyName + (shouldNegateCondition ? " !==" : " ===") + " %s";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean shouldNegateCondition() {
        return this.myIsNegative && this.mySurroundKind != TypeGuardSurroundKind.Or || !this.myIsNegative && this.mySurroundKind == TypeGuardSurroundKind.Or;
    }

    @NotNull
    private String computeTemplateForNullable() {
        if (!this.myAllowSimplifyForNullable) {
            return this.shouldNegateCondition() ? "%s != null" : "%s == null";
        }
        return this.shouldNegateCondition() ? "%s" : "!(%s)";
    }

    @NotNull
    private String computeTypeOfOrInstanceOfTemplate(String typeName) {
        return this.shouldNegateCondition() ? (this.isTypeOfMember(typeName) ? myTypeOfNegativeTemplate : "!(%s instanceof %s)") : (this.isTypeOfMember(typeName) ? myTypeOfTemplate : myInstanceOfTemplate);
    }

    @NotNull
    private String createGuardTextDescription() {
        PsiElement element = this.myStartElement.getElement();
        if (element == null) {
            return "";
        }
        boolean isTypeOf = this.isTypeOfMember(this.myName);
        String string = String.format(StringUtil.replace((String)StringUtil.replace((String)this.getTemplate(this.myName), (String)"$SELECTION$", (String)"..."), (String)"$END$", (String)""), element.getText(), isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(this.myName) : this.myName);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.insert.type.guard.fix.family", new Object[0]);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeofWrapType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortenedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplate";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInGuardTemplate";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateForDiscriminator";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardTextDescription";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOfMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

