/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.JSResolvableModuleReference;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPathMappingCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiReference refStart;
        boolean isTypeScriptModule;
        if (parameters == null) {
            TypeScriptPathMappingCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            TypeScriptPathMappingCompletionContributor.$$$reportNull$$$0(1);
        }
        boolean bl = isTypeScriptModule = (refStart = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) instanceof PsiMultiReference ? TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReferences(((PsiMultiReference)refStart).getReferences()) : TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReference(refStart);
        if (isTypeScriptModule) {
            TypeScriptPathMappingCompletionContributor.addAdditionalPathMappings(parameters, result2);
        }
    }

    private static boolean isTypeScriptModuleReferences(PsiReference @NotNull [] refs) {
        if (refs == null) {
            TypeScriptPathMappingCompletionContributor.$$$reportNull$$$0(2);
        }
        for (PsiReference ref : refs) {
            if (!TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReference(ref)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeScriptModuleReference(@Nullable PsiReference ref) {
        if (ref == null) {
            return false;
        }
        PsiElement element = ref.getElement();
        return (element instanceof ES6FromClause || element.getParent() instanceof TypeScriptImportStatement) && (ref instanceof JSFileReference || ref instanceof TypeScriptNodeReference && !ref.getCanonicalText().contains("/") || ref instanceof JSResolvableModuleReference);
    }

    private static void addAdditionalPathMappings(CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        TypeScriptConfig config2;
        PsiElement position;
        if (result2 == null) {
            TypeScriptPathMappingCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((position = parameters.getPosition()).getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
            return;
        }
        String text = position.getText();
        String literalValue = StringUtil.unquoteString((String)text);
        if (literalValue.contains("\\") || literalValue.contains("/")) {
            return;
        }
        VirtualFile file2 = position.getContainingFile().getOriginalFile().getVirtualFile();
        if (file2 != null && (config2 = TypeScriptConfigUtil.getConfigForFile(position.getProject(), file2)) != null) {
            for (JSModulePathSubstitution substitution : config2.getPaths()) {
                String pattern2 = substitution.getPattern();
                boolean hasStar = pattern2.contains("*");
                if (hasStar && !JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern2)) continue;
                String variant = hasStar ? pattern2.substring(0, pattern2.length() - 1) : pattern2;
                LookupElementBuilder newBuilder = LookupElementBuilder.create((String)variant);
                result2.addElement((LookupElement)newBuilder.withIcon(AllIcons.Nodes.Folder));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptPathMappingCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeScriptModuleReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalPathMappings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

