/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddExplicitEnumValuesIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.add.enum.values", new Object[0]);
        if (string == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.add.enum.values", new Object[0]);
        if (string == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(3);
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        assert (anEnum != null);
        NumberFormat format = NumberFormat.Dec;
        for (JSField field : anEnum.getFields()) {
            assert (field instanceof TypeScriptEnumField);
            JSExpression initializer = field.getInitializer();
            if (initializer != null) {
                format = TypeScriptAddExplicitEnumValuesIntention.getNumberFormat(initializer);
                continue;
            }
            EnumConstantValue value = ((TypeScriptEnumField)field).getConstantValue();
            Double numericValue = value.getNumericValue();
            assert (numericValue != null);
            int i2 = (int)numericValue.doubleValue();
            String text = TypeScriptAddExplicitEnumValuesIntention.formatNumber(i2, format);
            TypeScriptAddExplicitEnumValuesIntention.appendEnumValue(field, text);
        }
    }

    public static void appendEnumValue(@NotNull JSField field, @NotNull String text) {
        if (field == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(4);
        }
        if (text == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(5);
        }
        field.addBefore(JSChangeUtil.createTokenElement((PsiElement)field, JSTokenTypes.EQ, "="), null);
        field.addBefore((PsiElement)JSPsiElementFactory.createJSExpression(text, (PsiElement)field), null);
    }

    @NotNull
    public static NumberFormat getNumberFormat(JSExpression initializer) {
        JSLiteralExpression expression = (JSLiteralExpression)ObjectUtils.tryCast((Object)initializer, JSLiteralExpression.class);
        if (expression != null) {
            JSLiteralExpressionKind kind = expression.getExpressionKind(true);
            switch (kind) {
                case HEX: {
                    NumberFormat numberFormat = NumberFormat.Hex;
                    if (numberFormat == null) {
                        TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(6);
                    }
                    return numberFormat;
                }
                case OCT: 
                case OBSOLETE_OCT: {
                    NumberFormat numberFormat = NumberFormat.Oct;
                    if (numberFormat == null) {
                        TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(7);
                    }
                    return numberFormat;
                }
                case BIN: {
                    NumberFormat numberFormat = NumberFormat.Bin;
                    if (numberFormat == null) {
                        TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(8);
                    }
                    return numberFormat;
                }
            }
        }
        NumberFormat numberFormat = NumberFormat.Dec;
        if (numberFormat == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(9);
        }
        return numberFormat;
    }

    @NotNull
    public static String formatNumber(int i2, NumberFormat format) {
        switch (format) {
            case Hex: {
                String string = "0x" + Integer.toHexString(i2);
                if (string == null) {
                    TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(10);
                }
                return string;
            }
            case Bin: {
                String string = "0b" + Integer.toBinaryString(i2);
                if (string == null) {
                    TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(11);
                }
                return string;
            }
            case Oct: {
                String string = "0o" + Integer.toOctalString(i2);
                if (string == null) {
                    TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        String string = String.valueOf(i2);
        if (string == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(14);
        }
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(15);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        if (anEnum == null) {
            return false;
        }
        boolean hasNonInitialized = false;
        for (JSField field : anEnum.getFields()) {
            JSExpression initializer = field.getInitializer();
            hasNonInitialized |= initializer == null;
            if (!(field instanceof TypeScriptEnumField)) {
                return false;
            }
            EnumConstantValue constantValue = ((TypeScriptEnumField)field).getConstantValue();
            if (constantValue.getStringValue() == null && constantValue.getNumericValue() != null) continue;
            return false;
        }
        return hasNonInitialized;
    }

    @Nullable
    static TypeScriptEnum findEnum(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(16);
        }
        return (TypeScriptEnum)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptEnum.class, (boolean)false, (Class[])new Class[]{JSBlockStatement.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddExplicitEnumValuesIntention";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddExplicitEnumValuesIntention";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNumber";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendEnumValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findEnum";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NumberFormat {
        Dec,
        Hex,
        Bin,
        Oct;

    }
}

