/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLibraries {
    public static final String BUNDLED_LIB_VERSION = "4.3.5";
    @NotNull
    private final Set<VirtualFile> myAllLibsIncludeInvalid;
    @NotNull
    private final IntSet myAllIds;
    @NotNull
    private final Map<String, VirtualFile> myAllLibs;
    @NotNull
    private final Set<VirtualFile> myDefaultLibs;
    private final MultiMap<String, VirtualFile> myLibraryMappingsCache = MultiMap.createConcurrent();
    private final long myModificationId;
    private final boolean myBundled;
    @Nullable
    private final File myLibFolder;
    @Nullable
    private final VirtualFile myLibVirtualFile;

    public TypeScriptLibraries() {
        this(TypeScriptUtil.getTypeScriptExternalFolderFile(), null, true);
    }

    public TypeScriptLibraries(@Nullable File libFolder, @Nullable VirtualFile libVirtualFile, boolean isBundled) {
        assert (libFolder != null || libVirtualFile != null);
        this.myLibVirtualFile = libVirtualFile;
        this.myBundled = isBundled;
        this.myLibFolder = libFolder;
        VirtualFile defaultLib = this.getTypeScriptPredefinedLibDTsFile();
        HashSet<VirtualFile> libsIncludeInvalid = new HashSet<VirtualFile>(this.buildAllLibs());
        this.myDefaultLibs = TypeScriptLibraries.createLibSetIfValid(defaultLib);
        this.myAllLibsIncludeInvalid = Collections.unmodifiableSet(libsIncludeInvalid);
        this.myAllIds = new IntOpenHashSet(libsIncludeInvalid.stream().mapToInt(this::getVirtualFileId).toArray());
        this.myAllLibs = new HashMap<String, VirtualFile>(this.myAllLibsIncludeInvalid.size());
        for (VirtualFile file2 : this.myAllLibsIncludeInvalid) {
            if (!file2.isValid()) continue;
            this.myAllLibs.put(TypeScriptUtil.getLibraryName(file2.getName()), file2);
        }
        int topLevelLibStamp = this.myLibFolder == null ? this.myLibVirtualFile.getPath().hashCode() : this.myLibFolder.getPath().hashCode();
        this.myModificationId = this.myAllLibs.values().stream().mapToLong(el -> el.getModificationStamp()).reduce((el, res) -> el + 23L * res).orElse(0L) + 31L * (long)topLevelLibStamp;
    }

    public int getVirtualFileId(@NotNull VirtualFile el) {
        if (el == null) {
            TypeScriptLibraries.$$$reportNull$$$0(0);
        }
        return el instanceof VirtualFileWithId ? ((VirtualFileWithId)el).getId() : el.hashCode();
    }

    @NotNull
    public Set<VirtualFile> getLibraries(@NotNull Project project, @NotNull String libraryName) {
        Set files;
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(2);
        }
        boolean hasValue = this.myLibraryMappingsCache.containsKey((Object)libraryName);
        Collection raw = this.myLibraryMappingsCache.get((Object)libraryName);
        Set set = files = raw instanceof Set ? (Set)raw : new HashSet(raw);
        if (hasValue) {
            Set set2 = files;
            if (set2 == null) {
                TypeScriptLibraries.$$$reportNull$$$0(3);
            }
            return set2;
        }
        Set<VirtualFile> toCache = this.getLibrariesNoCache(project, libraryName);
        this.myLibraryMappingsCache.put((Object)libraryName, toCache);
        Set<VirtualFile> set3 = toCache;
        if (set3 == null) {
            TypeScriptLibraries.$$$reportNull$$$0(4);
        }
        return set3;
    }

    private Set<VirtualFile> getLibrariesNoCache(@NotNull Project project, @NotNull String libraryName) {
        VirtualFile startLibraryFile;
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(5);
        }
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(6);
        }
        if ((startLibraryFile = this.getLibraryByName(libraryName)) == null) {
            this.myLibraryMappingsCache.put((Object)libraryName, (Collection)ContainerUtil.emptyList());
            return Collections.emptySet();
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        return service.getIncludedFiles(startLibraryFile);
    }

    @Nullable
    public VirtualFile getLibraryByName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(7);
        }
        return this.myAllLibs.get(libraryName);
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean includeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLibraries.$$$reportNull$$$0(8);
        }
        return this.myAllLibsIncludeInvalid.contains(file2);
    }

    @NotNull
    public IntSet getAllIds() {
        IntSet intSet = this.myAllIds;
        if (intSet == null) {
            TypeScriptLibraries.$$$reportNull$$$0(9);
        }
        return intSet;
    }

    public boolean includeFileWithName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(10);
        }
        if (!fileName.startsWith("lib") || !fileName.endsWith(".d.ts")) {
            return false;
        }
        return this.myAllLibs.containsKey(TypeScriptUtil.getLibraryName(fileName));
    }

    @NotNull
    public Collection<VirtualFile> getAllLibs() {
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static boolean isValid(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid();
    }

    public Set<VirtualFile> getLibsForTarget(@NotNull Project project, @Nullable TypeScriptConfig.LanguageTarget target) {
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(12);
        }
        if (target == null) {
            return Collections.emptySet();
        }
        Set<VirtualFile> libraries = this.getLibraries(project, target.libName);
        if (!libraries.isEmpty()) {
            return libraries;
        }
        return this.myDefaultLibs;
    }

    @NotNull
    private static Set<VirtualFile> createLibSetIfValid(@Nullable VirtualFile file2) {
        Set set = TypeScriptLibraries.isValid(file2) ? ContainerUtil.immutableSet((Object[])new VirtualFile[]{file2}) : Collections.emptySet();
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> buildAllLibs() {
        if (this.myLibFolder != null) {
            return new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getLibFilesByIO(this.myLibFolder, (Condition<? super String>)Conditions.alwaysTrue(), true));
        }
        assert (this.myLibVirtualFile != null);
        HashSet hashSet = ContainerUtil.newHashSet((Object[])this.myLibVirtualFile.getChildren());
        if (hashSet == null) {
            TypeScriptLibraries.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    private VirtualFile getTypeScriptPredefinedLibDTsFile() {
        if (this.myLibVirtualFile != null) {
            return this.myLibVirtualFile.findChild("lib.d.ts");
        }
        assert (this.myLibFolder != null);
        LocalFileSystem localFileSystem = TypeScriptLibraries.getFileSystem();
        if (localFileSystem == null) {
            return null;
        }
        File ioFile = new File(this.myLibFolder, "lib.d.ts");
        return JSLibraryUtil.findFileByIoFile(localFileSystem, ioFile);
    }

    @Nullable
    private static LocalFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    @NotNull
    public Collection<VirtualFile> getFilesToRefresh() {
        LocalFileSystem system;
        VirtualFile parent;
        VirtualFile defaultLib = (VirtualFile)ContainerUtil.getFirstItem(this.myDefaultLibs);
        if (defaultLib != null && (parent = defaultLib.getParent()) != null && parent.isValid()) {
            List<VirtualFile> list2 = Collections.singletonList(parent);
            if (list2 == null) {
                TypeScriptLibraries.$$$reportNull$$$0(15);
            }
            return list2;
        }
        if (this.myLibFolder != null && (system = TypeScriptLibraries.getFileSystem()) != null) {
            VirtualFile file2 = JSLibraryUtil.findFileByIoFile(system, this.myLibFolder);
            List<VirtualFile> list3 = Collections.singletonList(file2);
            if (list3 == null) {
                TypeScriptLibraries.$$$reportNull$$$0(16);
            }
            return list3;
        }
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(17);
        }
        return set;
    }

    public long getModificationId() {
        return this.myModificationId;
    }

    @NotNull
    public TypeScriptLibraries copy() {
        return new TypeScriptLibraries(this.myLibFolder, this.myLibVirtualFile, this.myBundled);
    }

    public boolean isValid() {
        return this.myAllLibsIncludeInvalid.size() > 0 && this.myAllLibsIncludeInvalid.stream().allMatch(VirtualFile::isValid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibSetIfValid";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllLibs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibrariesNoCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "includeFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeFileWithName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLibsForTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

