/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryKt;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLibraryProviderImpl
implements TypeScriptLibraryProvider {
    public static final Logger LOG = Logger.getInstance(TypeScriptLibraryProviderImpl.class);
    private static final String TS_LIB_VERSION_KEY = "ts.lib.d.ts.version";
    @NotNull
    private final Project myProject;
    private volatile boolean myBundledRefreshed;
    @NotNull
    private volatile TypeScriptLibraries myCurrentLibrary;
    @NotNull
    private volatile TypeScriptLibraries myBundledLibrary;

    private static void asyncRefreshBundledVersion(@NotNull Runnable completeCallback, @NotNull TypeScriptLibraries bundled, boolean force) {
        if (completeCallback == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(0);
        }
        if (bundled == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(1);
        }
        String key = PropertiesComponent.getInstance().getValue(TS_LIB_VERSION_KEY);
        if (!force && "4.3.5".equals(key)) {
            return;
        }
        PropertiesComponent.getInstance().setValue(TS_LIB_VERSION_KEY, "4.3.5");
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!force && testMode && key == null) {
            return;
        }
        LOG.info("Start refreshing typescript libraries");
        List list2 = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray(bundled.getFilesToRefresh()));
        LocalFileSystem.getInstance().refreshFiles((Iterable)list2, !testMode, true, () -> {
            LOG.info("End refreshing typescript libraries");
            completeCallback.run();
        });
    }

    public TypeScriptLibraryProviderImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(2);
        }
        this.myBundledRefreshed = false;
        this.myProject = project;
        this.myBundledLibrary = new TypeScriptLibraries();
        this.myCurrentLibrary = TypeScriptLibraryKt.getLibraryCandidate(project, this.myBundledLibrary);
        TypeScriptServiceDirectoryWatcher.getService(project).addListener(this::reloadLibraries);
        TypeScriptLibraryProviderImpl.asyncRefreshBundledVersion(this::reloadBundledLibraries, this.myBundledLibrary, false);
    }

    private void reloadBundledLibraries() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myBundledRefreshed) {
            TypeScriptLibraries oldLibrary = this.myBundledLibrary;
            TypeScriptLibraries copy = oldLibrary.copy();
            WriteAction.run(() -> {
                this.myBundledLibrary = copy;
                if (oldLibrary == this.myCurrentLibrary) {
                    this.myCurrentLibrary = this.myBundledLibrary;
                }
                if (this.myBundledLibrary.getModificationId() != oldLibrary.getModificationId() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.info("Refresh roots after updating typescript libraries");
                    this.refreshRoots();
                }
                this.myBundledRefreshed = true;
            });
        }
    }

    private void refreshRoots() {
        Logger.getInstance(TypeScriptLibraryProviderImpl.class).info("Root changed for updating the ts library");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllBundledLibraries() {
        Collection<VirtualFile> libs = this.myBundledLibrary.getAllLibs();
        return TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequiredBundled(libs));
    }

    @Override
    @NotNull
    public IntSet getEffectiveLibrariesIds() {
        TypeScriptLibraries library = this.getEffectiveLibrary();
        IntSet intSet = library.getAllIds();
        if (intSet == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(3);
        }
        return intSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllCustomLibraries() {
        TypeScriptLibraries library = this.myCurrentLibrary;
        return library.isBundled() ? Collections.emptySet() : TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequired(library.getAllLibs(), library));
    }

    @Override
    @NotNull
    public IntSet getLibrariesIds(boolean bundled) {
        IntSet intSet = bundled ? this.myBundledLibrary.getAllIds() : this.myCurrentLibrary.getAllIds();
        if (intSet == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(4);
        }
        return intSet;
    }

    @Override
    public Collection<VirtualFile> getCurrentLibraries() {
        TypeScriptLibraries library = this.getEffectiveLibrary();
        return this.filterAndRefreshIfRequired(library.getAllLibs(), library);
    }

    @Override
    @NotNull
    public GlobalSearchScope getFileTypeRestrictedScope(@NotNull GlobalSearchScope moduleAndLibraryScope, @NotNull VirtualFile file2) {
        if (moduleAndLibraryScope == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(6);
        }
        TypeScriptConfig includes = this.getIncludeConfig(file2);
        TypeScriptLibraries library = this.getEffectiveLibrary();
        Collection<VirtualFile> tsLibs = this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file2, includes, library), library);
        GlobalSearchScope resultScope = moduleAndLibraryScope.uniteWith(GlobalSearchScope.filesScope((Project)this.myProject, tsLibs));
        TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(this.myProject);
        final Condition<VirtualFile> accessScope = configService.getAccessScope(file2);
        return new DelegatingGlobalSearchScope(resultScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                if (accessScope.value((Object)file2)) {
                    return true;
                }
                return TypeScriptUtil.isTypeScriptFile(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl$1", "contains"));
            }
        };
    }

    @Override
    public boolean isLibraryFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return this.myCurrentLibrary.includeFile(file2);
    }

    @Override
    public boolean isLibraryOrBundledLibraryFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return this.myCurrentLibrary.includeFile(file2) || this.myBundledLibrary != this.myCurrentLibrary && this.myBundledLibrary.includeFile(file2);
    }

    @Override
    public boolean isLibraryFileName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(7);
        }
        return this.myCurrentLibrary.includeFileWithName(fileName);
    }

    private void reloadLibraries() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptLibraries newLibraries = TypeScriptLibraryKt.getLibraryCandidate(this.myProject, this.myBundledLibrary);
        if (newLibraries.getModificationId() != this.myCurrentLibrary.getModificationId()) {
            WriteAction.run(() -> {
                this.myCurrentLibrary = newLibraries;
                this.refreshRoots();
            });
        }
    }

    @Override
    @Nullable
    public VirtualFile findLibraryByShortName(@NotNull String shortLibraryName) {
        if (shortLibraryName == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(8);
        }
        return this.getEffectiveLibrary().getLibraryByName(shortLibraryName);
    }

    @NotNull
    private Collection<VirtualFile> filterAndRefreshIfRequiredBundled(@NotNull Collection<VirtualFile> libs) {
        boolean hasInvalidFiles;
        if (libs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(9);
        }
        if (hasInvalidFiles = VfsUtilCore.hasInvalidFiles(libs)) {
            if (!this.myBundledRefreshed) {
                TypeScriptLibraryProviderImpl.asyncRefreshBundledVersion(this::reloadBundledLibraries, this.myBundledLibrary, true);
            } else {
                LOG.warn("Some of the typescript library files are invalidated after refresh");
            }
        }
        Collection collection = hasInvalidFiles ? (Collection)libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet()) : libs;
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> filterAndRefreshIfRequired(@NotNull Collection<VirtualFile> libs, @NotNull TypeScriptLibraries library) {
        if (libs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(11);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(12);
        }
        if (library.isBundled()) {
            return this.filterAndRefreshIfRequiredBundled(libs);
        }
        if (!VfsUtilCore.hasInvalidFiles(libs)) {
            Collection<VirtualFile> collection = libs;
            if (collection == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Collection collection = libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet());
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(15);
        }
        TypeScriptLibraries library = this.getEffectiveLibrary();
        return TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file2, this.getIncludeConfig(file2), library), library));
    }

    @Nullable
    private TypeScriptConfig getIncludeConfig(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(16);
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        return service.getPreferableConfig(file2);
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibrariesImpl(@NotNull VirtualFile file2, @Nullable TypeScriptConfig config2, @NotNull TypeScriptLibraries library) {
        Collection<String> names;
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(17);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(18);
        }
        if (config2 == null) {
            JSLanguageLevel configuredJSLevel = DialectDetector.getConfiguredJSLevel(file2, this.myProject);
            return this.getLibraries(TypeScriptConfig.LanguageTarget.fromLanguageLevel(configuredJSLevel), Collections.emptyList(), library);
        }
        SmartList additionalLibs = null;
        TypeScriptConfig.LanguageTarget target = null;
        ThreeState noLib = ThreeState.UNSURE;
        noLib = TypeScriptLibraryProviderImpl.mergeFlags(noLib, config2.noLib());
        boolean hasNoLibOption = config2.noLib();
        if (!hasNoLibOption && config2.getRawCompilerOption("lib") == null) {
            target = TypeScriptLibraryProviderImpl.getDefaultLibraryTarget(config2);
        }
        if (!(names = config2.getLibNames()).isEmpty()) {
            additionalLibs = new SmartList();
            additionalLibs.addAll(names);
        }
        if (noLib == ThreeState.YES) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(19);
            }
            return set;
        }
        return this.getLibraries(target, (List<String>)(additionalLibs == null ? Collections.emptyList() : additionalLibs), library);
    }

    private static ThreeState mergeFlags(@NotNull ThreeState state2, boolean newValue) {
        if (state2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(20);
        }
        return ThreeState.fromBoolean((boolean)(state2 == ThreeState.UNSURE ? newValue : state2.toBoolean() && newValue));
    }

    @NotNull
    private static TypeScriptConfig.LanguageTarget getDefaultLibraryTarget(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(21);
        }
        TypeScriptConfig.LanguageTarget languageTarget = config2.getLanguageTarget();
        if (languageTarget == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(22);
        }
        return languageTarget;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getLibsForTarget(@NotNull Project project, @Nullable TypeScriptConfig.LanguageTarget target) {
        if (project == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(23);
        }
        TypeScriptLibraries library = this.getEffectiveLibrary();
        Set<VirtualFile> set = library.getLibsForTarget(project, target);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(24);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> getLibraries(@Nullable TypeScriptConfig.LanguageTarget target, @NotNull List<String> additionalLibs, @NotNull TypeScriptLibraries library) {
        if (additionalLibs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(25);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(26);
        }
        Set<VirtualFile> mainLibs = library.getLibsForTarget(this.myProject, target);
        if (additionalLibs.isEmpty()) {
            Set<VirtualFile> set = mainLibs;
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(27);
            }
            return set;
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(mainLibs);
        for (String lib : additionalLibs) {
            result2.addAll(library.getLibraries(this.myProject, lib));
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    @NotNull
    private TypeScriptLibraries getEffectiveLibrary() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLibraries library = this.myCurrentLibrary;
        if (!library.isBundled() && !library.isValid()) {
            library = this.myBundledLibrary;
            this.myCurrentLibrary = this.myBundledLibrary;
            ApplicationManager.getApplication().invokeLater(() -> this.reloadLibraries(), this.myProject.getDisposed());
        }
        TypeScriptLibraries typeScriptLibraries = library;
        if (typeScriptLibraries == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(29);
        }
        return typeScriptLibraries;
    }

    @NotNull
    private static Set<VirtualFile> asSet(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(30);
        }
        return files instanceof Set ? (Set)files : new THashSet(files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundled";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortLibraryName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 12: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLibs";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLibrariesIds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesIds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndRefreshIfRequiredBundled";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndRefreshIfRequired";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrariesImpl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLibraryTarget";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibsForTarget";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asyncRefreshBundledVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeRestrictedScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryByShortName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterAndRefreshIfRequiredBundled";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterAndRefreshIfRequired";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeConfig";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrariesImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeFlags";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLibraryTarget";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLibsForTarget";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

