/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableUtil {
    @NonNls
    static final String TD = "td";
    @NonNls
    static final String TH = "th";
    @NonNls
    static final String TR = "tr";
    @NonNls
    static final String TABLE = "table";
    @NonNls
    static final String COLSPAN = "colspan";
    @NonNls
    static final String ROWSPAN = "rowspan";
    @NonNls
    static final String THEAD = "thead";

    @Nullable
    static PsiElement getParentWithName(PsiElement element, String[] tagNames) {
        while (element != null) {
            if (element instanceof XmlTag) {
                if (tagNames != null) {
                    String name = StringUtil.toLowerCase((String)((XmlTag)element).getName());
                    for (String tag : tagNames) {
                        if (!name.equals(tag)) continue;
                        return element;
                    }
                } else {
                    return element;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    static boolean isInsideTag(Editor editor, PsiFile file, String[] tagNames) {
        if (TableUtil.isHtmlTagContainingFile(editor, file)) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = TableUtil.getParentWithName(file.findElementAt(offset), tagNames);
            return element != null;
        }
        return false;
    }

    static int getColumnsNumber(XmlTag tag) {
        XmlAttribute[] attributes;
        for (XmlAttribute attribute : attributes = tag.getAttributes()) {
            if (!COLSPAN.equals(attribute.getLocalName())) continue;
            try {
                return Integer.parseInt(attribute.getValue());
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        return 1;
    }

    static int getRowsNumber(XmlTag tag) {
        XmlAttribute[] attributes;
        for (XmlAttribute attribute : attributes = tag.getAttributes()) {
            if (!ROWSPAN.equals(attribute.getLocalName())) continue;
            try {
                return Integer.parseInt(attribute.getValue());
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        return 1;
    }

    static void generateTableList(PsiElement element, boolean isInsideHeader, List<? super Pair<Boolean, List<Integer>>> list, List<? super XmlTag> tags) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String name = StringUtil.toLowerCase((String)tag.getLocalName());
            if (THEAD.equals(name)) {
                isInsideHeader = true;
            }
            if (TD.equals(name) || TH.equals(name) || TR.equals(name) || TABLE.equals(name)) {
                list.add((Pair<Boolean, List<Integer>>)new Pair((Object)isInsideHeader, null));
                tags.add((XmlTag)tag);
            }
        }
        for (PsiElement psiElement : element.getChildren()) {
            TableUtil.generateTableList(psiElement, isInsideHeader, list, tags);
        }
    }

    static Pair<List<Pair<Boolean, List<Integer>>>, List<XmlTag>> generateTableTree(PsiElement root) {
        ArrayList list = new ArrayList();
        ArrayList tags = new ArrayList();
        TableUtil.generateTableList(root, false, list, tags);
        ArrayList<Pair> tree = new ArrayList<Pair>();
        int tr = 0;
        for (int i = 0; i < list.size(); ++i) {
            tree.add(new Pair((Object)((Boolean)((Pair)list.get((int)i)).first), new ArrayList()));
            String name = StringUtil.toLowerCase((String)((XmlTag)tags.get(i)).getLocalName());
            if (TR.equals(name)) {
                ((List)((Pair)tree.get((int)0)).second).add(i);
                tr = i;
                continue;
            }
            if (!TD.equals(name) && !TH.equals(name)) continue;
            ((List)((Pair)tree.get((int)tr)).second).add(i);
        }
        return Pair.create(tree, tags);
    }

    private static Pair<Integer, TableCell> getTableCell(List<Pair<Boolean, List<Integer>>> tree, List<XmlTag> tags, int index, XmlTag tag, int currentColumn, int currentRow, TableRow current, TableRow previous) {
        int add = 0;
        TableCell answer = null;
        XmlTag element = tags.get(index);
        if (TD.equals(StringUtil.toLowerCase((String)element.getLocalName())) || TH.equals(StringUtil.toLowerCase((String)element.getLocalName()))) {
            int cols = TableUtil.getColumnsNumber(element);
            int rows = TableUtil.getRowsNumber(element);
            for (int i = currentColumn; i < previous.size() && previous.get(i).getRemainingRowsNumber(currentRow) > 0; ++i) {
                current.add(previous.get(i));
                ++add;
            }
            TableCell cell = new TableCell(element, currentRow, currentColumn + add, rows, cols);
            if (tag == element) {
                answer = cell;
            }
            for (int i = 0; i < cols; ++i) {
                current.add(cell);
            }
            add += cols;
        }
        Iterator iterator = ((List)tree.get((int)index).second).iterator();
        while (iterator.hasNext()) {
            int child = (Integer)iterator.next();
            Pair<Integer, TableCell> tmp = TableUtil.getTableCell(tree, tags, child, tag, currentColumn + add, currentRow, current, previous);
            if (tmp.second != null) {
                answer = (TableCell)tmp.second;
            }
            add += ((Integer)tmp.first).intValue();
        }
        return new Pair((Object)add, answer);
    }

    private static Pair<TableCell, TableRow> getTableCell(List<Pair<Boolean, List<Integer>>> tree, List<XmlTag> tags, int index, XmlTag tag, TableRow lastLevel, List<TableRow> table) {
        TableCell answer = null;
        XmlTag element = tags.get(index);
        if (TR.equals(StringUtil.toLowerCase((String)element.getLocalName()))) {
            TableRow currentLevel = new TableRow(element, (Boolean)tree.get((int)index).first);
            Pair<Integer, TableCell> tmp = TableUtil.getTableCell(tree, tags, index, tag, 0, table.size(), currentLevel, lastLevel);
            table.add(currentLevel);
            if (tmp.second != null) {
                answer = (TableCell)tmp.second;
            }
            for (int i = currentLevel.size(); i < lastLevel.size(); ++i) {
                currentLevel.add(lastLevel.get(i));
            }
            lastLevel = currentLevel;
        }
        Iterator iterator = ((List)tree.get((int)index).second).iterator();
        while (iterator.hasNext()) {
            int child = (Integer)iterator.next();
            Pair<TableCell, TableRow> tmp = TableUtil.getTableCell(tree, tags, child, tag, lastLevel, table);
            if (tmp.first != null) {
                answer = (TableCell)tmp.first;
            }
            lastLevel = (TableRow)tmp.second;
        }
        return Pair.create(answer, (Object)lastLevel);
    }

    static Pair<List<TableRow>, TableCell> getTableAndPosition(PsiElement root, PsiElement element) {
        Pair<List<Pair<Boolean, List<Integer>>>, List<XmlTag>> pair = TableUtil.generateTableTree(root);
        List tree = (List)pair.first;
        List tags = (List)pair.second;
        ArrayList<TableRow> table = new ArrayList<TableRow>();
        TableCell cell = (TableCell)TableUtil.getTableCell((List<Pair<Boolean, List<Integer>>>)tree, (List<XmlTag>)tags, (int)0, (XmlTag)((XmlTag)element), (TableRow)new TableRow(null, (boolean)false), table).first;
        return Pair.create(table, (Object)cell);
    }

    @Nullable
    static PsiElement getCurrentPsiElement(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
    }

    @Nullable
    static PsiElement getTablePsiElement(PsiElement root) {
        while (!(root == null || root instanceof XmlTag && TABLE.equals(StringUtil.toLowerCase((String)((XmlTag)root).getName())))) {
            root = root.getParent();
        }
        return root;
    }

    @Nullable
    static PsiElement findClosingToken(XmlTag tag) {
        PsiElement[] children = tag.getChildren();
        for (int i = 0; i < children.length; ++i) {
            XmlToken token;
            IElementType type;
            PsiElement element = children[i];
            if (!(element instanceof XmlToken) || !(type = (token = (XmlToken)element).getTokenType()).equals(XmlTokenType.XML_TAG_END)) continue;
            return children[i + 1];
        }
        return null;
    }

    static void moveCaretTo(@NotNull Editor editor, PsiElement element) {
        if (editor == null) {
            TableUtil.$$$reportNull$$$0(0);
        }
        editor.getCaretModel().moveToOffset(element.getTextOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static boolean isHtmlTagContainingFile(Editor editor, PsiFile file) {
        if (editor == null || !(file instanceof XmlFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return HtmlUtil.isHtmlTagContainingFile((PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/htmltools/html/actions/TableUtil", "moveCaretTo"));
    }

    static class TableRow {
        final XmlTag rowTag;
        final List<TableCell> list;
        final boolean insideHeader;

        TableRow(XmlTag rowTag, boolean insideHeader) {
            this.rowTag = rowTag;
            this.list = new ArrayList<TableCell>();
            this.insideHeader = insideHeader;
        }

        public void add(TableCell cell) {
            this.list.add(cell);
        }

        public TableCell get(int index) {
            return this.list.get(index);
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    static class TableCell {
        final int startColumn;
        final int startRow;
        final int cols;
        final int rows;
        final XmlTag tag;

        TableCell(XmlTag tag, int startRow, int startColumn, int rows, int cols) {
            this.tag = tag;
            this.startColumn = startColumn;
            this.startRow = startRow;
            this.rows = rows;
            this.cols = cols;
        }

        public int getRemainingColumnsNumber(int currentColumn) {
            return this.cols + this.startColumn - currentColumn;
        }

        public int getRemainingRowsNumber(int currentRow) {
            return this.rows + this.startRow - currentRow;
        }
    }
}

