/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.iar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.iar.IarCompilerKind;
import com.jetbrains.cidr.cpp.embedded.iar.IarMessagesConsoleFilter;
import com.jetbrains.cidr.cpp.embedded.iar.IarSwitchBuilder;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.FeatureParseUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilteringCapable;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IarCompiler
extends OCCompilerBase
implements OCCompiler,
OCOptionsFilteringCapable {
    public IarCompiler(@NotNull File executable, @NotNull File directory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        if (executable == null) {
            IarCompiler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            IarCompiler.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            IarCompiler.$$$reportNull$$$0(2);
        }
        if (tempFilesPool == null) {
            IarCompiler.$$$reportNull$$$0(3);
        }
        super(executable, directory, environment, tempFilesPool);
    }

    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        CompilerInfo result;
        if (languageKind == null) {
            IarCompiler.$$$reportNull$$$0(4);
        }
        if (switches == null) {
            IarCompiler.$$$reportNull$$$0(5);
        }
        try {
            List args = new IarSwitchBuilder(new CidrSwitchBuilder()).withSyntaxOnly().withLanguageKind(languageKind).withSwitches(switches).withSwitch("--predef_macros").withSwitch("-").withSwitch("--no_wrap_diagnostics").withSwitch("--silent").buildRaw();
            GeneralCommandLine cmdLine = new GeneralCommandLine().withExePath(this.myExecutable.getPath()).withParameters(args).withWorkDirectory(this.myWorkingDirectory);
            Path emptyFile = this.myTempFilesPool.writeToTempFile(this.myEnvironment.getHostMachine(), "", this.myEnvironment.getHostMachine().getTempDirectory(), "empty", ".c");
            cmdLine.addParameter(this.myEnvironment.toEnvPath(emptyFile.toString()));
            this.myEnvironment.prepare(cmdLine, CidrToolEnvironment.PrepareFor.BUILD);
            ProcessOutput output = new OCCompilerBase.CompilerRunner().run(cmdLine, this.myEnvironment);
            if (output.isTimeout() || output.getExitCode() != 0) {
                throw new ExecutionException(EmbeddedBundle.message("compiler.run.failed", output.getStderr(), output.getStdout()));
            }
            String defines = output.getStdout();
            SmartList warnings = new SmartList();
            List<HeadersSearchPath> headersSearchPaths = IarCompiler.searchPaths(languageKind, cmdLine, (List<String>)warnings);
            List<File> implicitIncludes = IarCompiler.collectImplicitIncludes(cmdLine, headersSearchPaths, File::exists, (List<String>)warnings);
            Map<OCCompilerFeatures.Type<?>, Object> features = IarCompiler.collectFeatures(defines);
            IarMessagesConsoleFilter.collectWarnings(output.getStderr(), (List<String>)warnings);
            result = new CompilerInfo(switches, StringUtil.split((String)defines, (String)"\n"), features, headersSearchPaths, implicitIncludes, Collections.emptyList(), (List)warnings);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        CompilerInfo info = result;
        CompilerInfo compilerInfo = Objects.requireNonNull(info);
        if (compilerInfo == null) {
            IarCompiler.$$$reportNull$$$0(6);
        }
        return compilerInfo;
    }

    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        if (switches == null) {
            IarCompiler.$$$reportNull$$$0(7);
        }
        if (skipOptions == null) {
            IarCompiler.$$$reportNull$$$0(8);
        }
        List switchesRaw = switches.getList(CidrCompilerSwitches.Format.RAW);
        List<String> filteredRaw = IarCompilerKind.INSTANCE.skipLanguageNotRelatedSwitches(switchesRaw);
        return new CidrCompilerSwitches(filteredRaw);
    }

    @NotNull
    static Map<OCCompilerFeatures.Type<?>, Object> collectFeatures(@NotNull String allDefinesText) throws ExecutionException {
        if (allDefinesText == null) {
            IarCompiler.$$$reportNull$$$0(9);
        }
        LinkedHashMap result = new LinkedHashMap();
        HashMap<String, String> defines = new HashMap<String, String>();
        for (String line : StringUtil.splitByLines((String)allDefinesText)) {
            char c;
            int idx;
            if (!line.startsWith("#define")) continue;
            String defineText = line.substring("#define".length()).trim();
            StringBuilder key = new StringBuilder();
            for (idx = 0; idx < defineText.length() && !Character.isWhitespace(c = defineText.charAt(idx)); ++idx) {
                key.append(c);
            }
            defines.put(key.toString(), defineText.substring(idx).trim());
        }
        IarCompiler.collectSizes(result, defines);
        FeatureParseUtil.collectStandardFeatures(defines, result::put);
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            IarCompiler.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    private static void collectSizes(Map<OCCompilerFeatures.Type<?>, Object> result, Map<String, String> defines) {
        for (OCCompilerFeatures.TypeSize typeSize : OCCompilerFeatures.TypeSize.values()) {
            String length = defines.get("__" + typeSize.name() + "_SIZE__");
            if (length == null || length.isEmpty()) continue;
            result.put((OCCompilerFeatures.Type<?>)typeSize, Short.parseShort(length));
        }
    }

    @NotNull
    static List<File> collectImplicitIncludes(@NotNull GeneralCommandLine cmdLine, @NotNull List<HeadersSearchPath> searchPaths, @NotNull Predicate<File> fileExists, @NotNull List<String> warnings) throws ExecutionException {
        if (cmdLine == null) {
            IarCompiler.$$$reportNull$$$0(11);
        }
        if (searchPaths == null) {
            IarCompiler.$$$reportNull$$$0(12);
        }
        if (fileExists == null) {
            IarCompiler.$$$reportNull$$$0(13);
        }
        if (warnings == null) {
            IarCompiler.$$$reportNull$$$0(14);
        }
        List<String> preIncludes = IarCompiler.extractKeyValues(cmdLine, "--preinclude");
        ArrayList<File> files = new ArrayList<File>();
        for (String preInclude : preIncludes) {
            boolean found = false;
            preInclude = preInclude.trim();
            try {
                for (HeadersSearchPath path : searchPaths) {
                    File file = Paths.get(path.getPath(), new String[0]).resolve(preInclude).toFile();
                    found = fileExists.test(file);
                    if (!found) continue;
                    files.add(file);
                    break;
                }
            }
            catch (InvalidPathException e) {
                warnings.add(e.getMessage());
            }
            if (found) continue;
            warnings.add(EmbeddedBundle.message("compiler.implicit.include.not.found", preInclude));
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            IarCompiler.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> extractKeyValues(@NotNull GeneralCommandLine commandLine, @NotNull String key) {
        if (commandLine == null) {
            IarCompiler.$$$reportNull$$$0(16);
        }
        if (key == null) {
            IarCompiler.$$$reportNull$$$0(17);
        }
        SmartList result = new SmartList();
        List args = commandLine.getParametersList().getParameters();
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.get(i);
            if (!arg.startsWith(key)) continue;
            if (arg.equals(key)) {
                if (++i < args.size()) {
                    result.add((Object)((String)args.get(i)));
                    continue;
                }
                result.add((Object)"");
                continue;
            }
            result.add((Object)arg.substring(key.length()));
        }
        SmartList smartList = result;
        if (smartList == null) {
            IarCompiler.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @NotNull
    static List<HeadersSearchPath> searchPaths(@NotNull OCLanguageKind languageKind, @NotNull GeneralCommandLine commandLine, List<String> warnings) {
        if (languageKind == null) {
            IarCompiler.$$$reportNull$$$0(19);
        }
        if (commandLine == null) {
            IarCompiler.$$$reportNull$$$0(20);
        }
        ArrayList<HeadersSearchPath> result = new ArrayList<HeadersSearchPath>();
        String workDirectory = commandLine.getWorkDirectory().getPath();
        for (String string : IarCompiler.extractKeyValues(commandLine, "-I")) {
            IarCompiler.calcPath(workDirectory, string.trim(), HeadersSearchPath.Kind.USER, result::add, warnings::add);
        }
        String envIncludes = (String)commandLine.getEffectiveEnvironment().get("C_INCLUDE");
        if (envIncludes != null) {
            for (String envInclude : envIncludes.split(";")) {
                if (envInclude.isEmpty()) continue;
                IarCompiler.calcPath(workDirectory, envInclude, HeadersSearchPath.Kind.USER, result::add, warnings::add);
            }
        }
        if (!commandLine.getParametersList().hasParameter("--no_system_include")) {
            ArrayList arrayList = new ArrayList();
            IarCompiler.extractKeyValues(commandLine, "--system_include_dir").forEach(s -> IarCompiler.calcPath(workDirectory, s.trim(), systemIncludes::add, warnings::add));
            if (arrayList.isEmpty()) {
                IarCompiler.calcPath(Paths.get(commandLine.getExePath(), new String[0]).getParent().getParent().toString(), "inc", arrayList::add, warnings::add);
            }
            for (String systemInclude : arrayList) {
                result.add(new HeadersSearchPath(systemInclude, false, HeadersSearchPath.Kind.SYSTEM));
                IarCompiler.calcPath(systemInclude, "c", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                if (!languageKind.isCpp()) continue;
                IarCompiler.calcPath(systemInclude, "cpp", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
            }
        }
        ArrayList<HeadersSearchPath> arrayList = result;
        if (arrayList == null) {
            IarCompiler.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static void calcPath(String baseDirectory, String subPath, Consumer<String> result, Consumer<String> warnings) {
        try {
            String s = Paths.get(baseDirectory, new String[0]).resolve(subPath).toString();
            result.accept(s);
        }
        catch (InvalidPathException e) {
            warnings.accept(e.getMessage());
        }
    }

    private static void calcPath(String baseDirectory, String subPath, HeadersSearchPath.Kind kind, Consumer<HeadersSearchPath> result, Consumer<String> warnings) {
        IarCompiler.calcPath(baseDirectory, subPath, s -> result.accept(new HeadersSearchPath(s.trim(), false, kind)), warnings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/iar/IarCompiler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDefinesText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPaths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExists";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/iar/IarCompiler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFeatures";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImplicitIncludes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractKeyValues";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectFeatures";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectImplicitIncludes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractKeyValues";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "searchPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

