/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdPeripheral;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdShowHideDialog {
    private final SvdRoot mySvdRoot;
    private final Project myProject;
    private CheckboxTree myTree;
    private CheckedTreeNode myCheckedTreeRoot;
    private JComponent myToolbarComponent;
    @Nullable
    private VirtualFile mySvdDefaultLocation;

    public SvdShowHideDialog(@NotNull SvdRoot SvdRoot2, Project project) {
        if (SvdRoot2 == null) {
            SvdShowHideDialog.$$$reportNull$$$0(0);
        }
        this.mySvdDefaultLocation = null;
        this.mySvdRoot = SvdRoot2;
        this.myProject = project;
    }

    public void setSvdDefaultLocation(@Nullable VirtualFile svdDefaultLocation) {
        this.mySvdDefaultLocation = svdDefaultLocation;
    }

    private void addCheckedFolder(CheckedTreeNode checkedParent, SvdNode<?> parent) {
        if (parent instanceof SvdRegister) {
            return;
        }
        List<?> children = parent.getChildren();
        for (SvdNode svdNode : children) {
            CheckedTreeNode checkedTreeNode = new CheckedTreeNode((Object)svdNode);
            checkedTreeNode.setChecked(this.mySvdRoot.isActive(svdNode));
            checkedParent.add((MutableTreeNode)checkedTreeNode);
            this.addCheckedFolder(checkedTreeNode, svdNode);
        }
    }

    public void showHideNodes() {
        this.myCheckedTreeRoot = new CheckedTreeNode((Object)this.mySvdRoot);
        this.addCheckedFolder(this.myCheckedTreeRoot, this.mySvdRoot);
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.customizeRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                this.getTextRenderer().append(this.nodeText(value));
            }

            @NlsSafe
            private String nodeText(Object value) {
                return ((CheckedTreeNode)value).getUserObject().toString();
            }
        }, this.myCheckedTreeRoot){

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, treePath -> treePath.getLastPathComponent().toString(), true);
            }
        };
        this.myTree.setSelectionRow(0);
        ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)this.myTree).filter(path -> !(((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdPeripheral))).forEach(arg_0 -> this.myTree.expandPath(arg_0));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        Rectangle bounds = ScreenUtil.getMainScreenBounds();
        scrollPane.setPreferredSize(new Dimension(bounds.width / 2, bounds.height * 3 / 4));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DumbAwareAction loadAction = new DumbAwareAction(EmbeddedBundle.message("svd.load.file", new Object[0]), EmbeddedBundle.message("svd.load.hardware.definitions.description", new Object[0]), AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SvdShowHideDialog.this.loadFile();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdShowHideDialog$3", "actionPerformed"));
            }
        };
        ActionManager actionManager = ActionManager.getInstance();
        actionGroup.add((AnAction)loadAction);
        actionGroup.add((AnAction)new UnloadAction());
        StatusText emptyText = this.myTree.getEmptyText();
        emptyText.setText(EmbeddedBundle.message("svd.no.registers.loaded", new Object[0]));
        emptyText.appendSecondaryText(EmbeddedBundle.message("svd.load.file", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.loadFile());
        DialogBuilder builder = new DialogBuilder();
        builder.addCloseButton();
        builder.setCenterPanel((JComponent)scrollPane);
        builder.setTitle(EmbeddedBundle.message("svd.select.peripherals.to.show", new Object[0]));
        builder.setPreferredFocusComponent((JComponent)this.myTree);
        ActionToolbar toolbar = actionManager.createActionToolbar("toolbar", (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        this.myToolbarComponent = toolbar.getComponent();
        builder.setNorthPanel(this.myToolbarComponent);
        builder.setHelpId("toolwindows.peripheralview");
        if (this.mySvdRoot.getChildren().isEmpty()) {
            SwingUtilities.invokeLater(this::loadFile);
        }
        builder.show();
        HashSet nodes = new HashSet();
        SvdShowHideDialog.findActive(nodes, this.myCheckedTreeRoot);
        this.mySvdRoot.setActive(nodes);
    }

    private void loadFile() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"svd");
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)this.mySvdDefaultLocation);
        if (file != null) {
            try {
                String filePathName = file.getPath();
                CheckedTreeNode foundFile = null;
                for (int i = 0; i < this.myCheckedTreeRoot.getChildCount() && foundFile == null; ++i) {
                    CheckedTreeNode fileCheckedNode = (CheckedTreeNode)this.myCheckedTreeRoot.getChildAt(i);
                    SvdFile svdFile = (SvdFile)fileCheckedNode.getUserObject();
                    if (!VfsUtilCore.pathEqualsTo((VirtualFile)file, (String)svdFile.getLocation())) continue;
                    foundFile = fileCheckedNode;
                }
                if (foundFile != null) {
                    this.myTree.setSelectionPath(new TreePath(new Object[]{this.myCheckedTreeRoot, foundFile}));
                    PopupUtil.showBalloonForComponent((Component)this.myToolbarComponent, (String)EmbeddedBundle.message("the.file.s.is.already.loaded", filePathName), (MessageType)MessageType.INFO, (boolean)false, null);
                    return;
                }
                SvdFile svdFile = this.mySvdRoot.addFile(file.getInputStream(), file.getName(), filePathName);
                CheckedTreeNode checkedFile = new CheckedTreeNode((Object)svdFile);
                this.addCheckedFolder(checkedFile, svdFile);
                this.myCheckedTreeRoot.add((MutableTreeNode)checkedFile);
                ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myCheckedTreeRoot, new int[]{this.myCheckedTreeRoot.getChildCount() - 1});
                TreePath filePath = new TreePath(new Object[]{this.myCheckedTreeRoot, checkedFile});
                ((JBTreeTraverser)((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)this.myTree).filter(filePath::isDescendant)).filter(path -> !(((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdPeripheral))).forEach(arg_0 -> this.myTree.expandPath(arg_0));
                this.myTree.setSelectionPath(filePath);
            }
            catch (IOException e) {
                Logger.getInstance(SvdShowHideDialog.class).error("Unexpected exception while reading " + file.getCanonicalPath(), (Throwable)e);
            }
        }
    }

    private static boolean findActive(@NotNull HashSet<SvdNode<?>> nodes, @NotNull CheckedTreeNode parent) {
        if (nodes == null) {
            SvdShowHideDialog.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            SvdShowHideDialog.$$$reportNull$$$0(2);
        }
        SvdNode svdNode = (SvdNode)parent.getUserObject();
        boolean active = false;
        if (svdNode instanceof SvdRegister) {
            active = parent.isChecked();
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                active |= SvdShowHideDialog.findActive(nodes, (CheckedTreeNode)parent.getChildAt(i));
            }
        }
        if (active) {
            nodes.add(svdNode);
        }
        return active;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "SvdRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdShowHideDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findActive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UnloadAction
    extends AnAction
    implements DumbAware {
        private UnloadAction() {
            super(EmbeddedBundle.messagePointer("svd.unload.action", new Object[0]), EmbeddedBundle.messagePointer("svd.unload.action.description", new Object[0]), AllIcons.General.Remove);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CheckedTreeNode checkedTreeNode;
            Object selected;
            TreePath path;
            if (e == null) {
                UnloadAction.$$$reportNull$$$0(0);
            }
            if ((path = SvdShowHideDialog.this.myTree.getSelectionPath()) != null && (selected = (checkedTreeNode = (CheckedTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SvdFile) {
                int index = SvdShowHideDialog.this.myCheckedTreeRoot.getIndex((TreeNode)checkedTreeNode);
                SvdShowHideDialog.this.myCheckedTreeRoot.remove((MutableTreeNode)checkedTreeNode);
                SvdShowHideDialog.this.myTree.removeSelectionPath(path);
                ((DefaultTreeModel)SvdShowHideDialog.this.myTree.getModel()).nodesWereRemoved((TreeNode)SvdShowHideDialog.this.myCheckedTreeRoot, new int[]{index}, new Object[]{checkedTreeNode});
                SvdShowHideDialog.this.mySvdRoot.unloadFile((SvdFile)selected);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                UnloadAction.$$$reportNull$$$0(1);
            }
            boolean fileSelected = (path = SvdShowHideDialog.this.myTree.getSelectionPath()) != null && ((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdFile;
            e.getPresentation().setEnabled(fileSelected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdShowHideDialog$UnloadAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

