/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.Format;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNodeBase;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SvdValue<T extends SvdNodeBase<?>>
extends SvdNodeBase<T> {
    private static final Map<Character, Format> ourFormatBySign = Stream.of(Format.values()).collect(Collectors.toMap(Format::getSign, t -> t));
    private final RegisterAccess myAccess;
    private final RegisterReadAction myReadAction;
    private final int myBitSize;
    protected volatile boolean changed;
    private Format myFormat;

    protected SvdValue(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction, int bitSize, Format format) {
        if (id == null) {
            SvdValue.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SvdValue.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdValue.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdValue.$$$reportNull$$$0(3);
        }
        super(id, name, description);
        this.myAccess = access;
        this.myReadAction = readAction;
        this.myBitSize = bitSize;
        this.myFormat = format;
    }

    @Nullable
    protected RegisterReadAction getReadAction() {
        return this.myReadAction;
    }

    @NotNull
    protected RegisterAccess getAccess() {
        RegisterAccess registerAccess = this.myAccess;
        if (registerAccess == null) {
            SvdValue.$$$reportNull$$$0(4);
        }
        return registerAccess;
    }

    @NotNull
    protected Format getFormat() {
        Format format = this.myFormat;
        if (format == null) {
            SvdValue.$$$reportNull$$$0(5);
        }
        return format;
    }

    protected void setFormat(@NotNull Format format) {
        if (format == null) {
            SvdValue.$$$reportNull$$$0(6);
        }
        this.myFormat = format;
    }

    protected int getBitSize() {
        return this.myBitSize;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    @NotNull
    public abstract Format getDefaultFormat();

    @Override
    public void setFormatFromSign(char sign) {
        this.setFormat(ourFormatBySign.get(Character.valueOf(sign)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

