/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class MatrixControlBuilder {
    private final DefaultTableModel myModel;
    private final JBTable myTable;
    private final JComponent myResult;
    private final int[] myColumnWidths;
    private final FontMetrics myFontMetrics;

    public MatrixControlBuilder(String ... columns) {
        if (columns == null) {
            MatrixControlBuilder.$$$reportNull$$$0(0);
        }
        this.myModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.myModel.addColumn("");
        for (String string2 : columns) {
            this.myModel.addColumn(string2);
        }
        this.myTable = new JBTable(this.myModel){

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.myTable.setShowGrid(false);
        this.myTable.setFocusable(false);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        int max = this.myTable.getColumnCount();
        for (int i2 = 0; i2 < max; ++i2) {
            TableCellRenderer headerRenderer;
            TableColumn tableColumn = this.myTable.getColumnModel().getColumn(i2);
            if (i2 > 0) {
                tableColumn.setCellRenderer(renderer);
            }
            if (!((headerRenderer = tableColumn.getHeaderRenderer()) instanceof JLabel)) continue;
            ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(0);
        }
        this.myResult = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        this.myColumnWidths = new int[columns.length + 1];
        this.myFontMetrics = this.myTable.getFontMetrics(this.myTable.getFont());
        for (int i2 = 0; i2 < columns.length; ++i2) {
            this.myColumnWidths[i2 + 1] = this.myFontMetrics.stringWidth(columns[i2]);
        }
    }

    public void addRow(@NotNull String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            MatrixControlBuilder.$$$reportNull$$$0(1);
        }
        if (values == null) {
            MatrixControlBuilder.$$$reportNull$$$0(2);
        }
        if (values.length != this.myModel.getColumnCount() - 1) {
            StringBuilder columns = new StringBuilder();
            int max = this.myModel.getColumnCount();
            for (int i2 = 1; i2 < max; ++i2) {
                columns.append(this.myModel.getColumnName(i2)).append(", ");
            }
            if (columns.length() > 2) {
                columns.setLength(columns.length() - 2);
            }
            throw new IllegalArgumentException(String.format("Can't add row '%s' to the matrix control. Reason: the row specifies incorrect number of values (%d, expected %d). Registered columns: %s. Given values: %s", name, values.length, this.myModel.getColumnCount() - 1, columns, Arrays.toString(values)));
        }
        Object[] rowData = new Object[values.length + 1];
        rowData[0] = name;
        System.arraycopy(values, 0, rowData, 1, values.length);
        this.myModel.addRow(rowData);
        for (int i3 = 0; i3 < rowData.length; ++i3) {
            this.myColumnWidths[i3] = Math.max(this.myFontMetrics.stringWidth(rowData[i3].toString()), this.myColumnWidths[i3]);
        }
    }

    @NotNull
    public JComponent build() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i2 = 0; i2 < this.myColumnWidths.length; ++i2) {
            columnModel.getColumn(i2).setMinWidth(this.myColumnWidths[i2] + 4);
        }
        JComponent jComponent = this.myResult;
        if (jComponent == null) {
            MatrixControlBuilder.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/ui/MatrixControlBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/ui/MatrixControlBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

