/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrLineGutterIconRenderer;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecutionStack
extends XExecutionStack {
    @NotNull
    protected final CidrDebugProcess myProcess;
    @NotNull
    protected final LLThread myThread;
    @Nullable
    private volatile CidrStackFrame myTopFrame;
    @Nullable
    protected final CidrSuspensionCause mySuspensionCause;
    @NotNull
    private final CidrStackFramesCache myStackFramesCache;
    private boolean myBatchRequests;

    public CidrExecutionStack(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause suspensionCause) {
        if (process == null) {
            CidrExecutionStack.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrExecutionStack.$$$reportNull$$$0(1);
        }
        super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
        this.myStackFramesCache = new CidrStackFramesCache();
        this.myBatchRequests = true;
        this.myProcess = process;
        this.myThread = thread;
        this.mySuspensionCause = suspensionCause;
        this.myTopFrame = frame == null ? null : this.newFrame(frame);
    }

    public XStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    public void renewTopFrame() {
        CidrStackFrame topFrame = this.myTopFrame;
        if (topFrame != null) {
            this.myTopFrame = this.newFrame(topFrame.getFrame());
        }
    }

    public void computeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
            return;
        }
        if (this.myBatchRequests) {
            this.doComputeStackFramesWithBatching(originalFrom, container);
        } else {
            this.doComputeStackFrames(originalFrom, container);
        }
    }

    private void addStackFramesToContainer(@NotNull XExecutionStack.XStackFrameContainer container, @NotNull List<CidrStackFrame> frames, @Nullable XStackFrame toSelect, boolean hasMore) {
        if (container == null) {
            CidrExecutionStack.$$$reportNull$$$0(2);
        }
        if (frames == null) {
            CidrExecutionStack.$$$reportNull$$$0(3);
        }
        if (container instanceof XStackFrameContainerEx) {
            ((XStackFrameContainerEx)container).addStackFrames(frames, toSelect, !hasMore);
        } else {
            CidrDebuggerLog.LOG.error("Expected instanceof XStackFrameContainerEx, got" + container.getClass());
            container.addStackFrames(frames, !hasMore);
        }
    }

    private void doComputeStackFramesWithBatching(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                boolean repeat;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result2 = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                int currentBatchSize = 100;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    repeat = false;
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, currentBatchSize, currentFrom == 0);
                    CidrStackFrame top = this.myTopFrame;
                    result2.ensureCapacity(result2.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top != null) {
                                frame = top;
                            } else {
                                top = this.myTopFrame = this.newFrame((LLFrame)framesResult.list.get(i));
                                frame = this.myTopFrame;
                            }
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result2.add(frame);
                    }
                    hasMore = framesResult.hasMore;
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || (toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result2, CidrStackFrame::hasSourceFile)))) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                    currentFrom = framesResult.list.size();
                    currentBatchSize -= currentFrom;
                    repeat = true;
                } while (repeat);
                this.addStackFramesToContainer(container, result2, toSelect, hasMore);
                if (hasMore && !container.isObsolete()) {
                    this.doComputeStackFramesWithBatching(currentFrom + result2.size(), container);
                }
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result2 = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, 100, false);
                    CidrStackFrame top = this.myTopFrame;
                    result2.ensureCapacity(result2.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top == null) {
                                this.myTopFrame = top = this.newFrame((LLFrame)framesResult.list.get(i));
                            }
                            frame = top;
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result2.add(frame);
                    }
                    hasMore = framesResult.hasMore;
                    currentFrom = framesResult.list.size();
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame()) continue;
                    toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result2, CidrStackFrame::hasSourceFile)));
                } while (hasMore);
                this.addStackFramesToContainer(container, result2, toSelect, false);
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private boolean shouldSelectDisasmFrame() {
        if (!this.myProcess.driverSupportsDisasm()) {
            return false;
        }
        return this.mySuspensionCause == null;
    }

    @NotNull
    protected CidrStackFrame newFrame(@NotNull LLFrame frame) {
        if (frame == null) {
            CidrExecutionStack.$$$reportNull$$$0(4);
        }
        return new CidrStackFrame(this.myProcess, this.myThread, frame, this.mySuspensionCause);
    }

    @Nullable
    public GutterIconRenderer getExecutionLineIconRenderer() {
        return this.myProcess.supportsJumpToLine() ? new CidrLineGutterIconRenderer(this.myProcess, this.myThread) : super.getExecutionLineIconRenderer();
    }

    public String toString() {
        return this.myThread.toString();
    }

    public void setRequestsBatching(boolean enable) {
        this.myBatchRequests = enable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addStackFramesToContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "newFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CidrStackFramesCache {
        @NotNull
        private final List<LLFrame> myFrames = new ArrayList<LLFrame>();
        private boolean myHasMore = true;

        private CidrStackFramesCache() {
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull DebuggerDriver driver, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (driver == null) {
                CidrStackFramesCache.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"cidr.debugger.cache.callstacks", (boolean)true)) {
                DebuggerDriver.ResultList<LLFrame> resultList = driver.getFrames(CidrExecutionStack.this.myThread, from, count, untilFirstLineWithCode);
                if (resultList == null) {
                    CidrStackFramesCache.$$$reportNull$$$0(1);
                }
                return resultList;
            }
            if (untilFirstLineWithCode) {
                this.cacheUntil(driver, from, false);
                if (this.myFrames.size() < from + count) {
                    for (int i = from; i < this.myFrames.size(); ++i) {
                        if (!this.myFrames.get(i).hasDebugInfo()) continue;
                        return this.createResult(from, this.myFrames.size());
                    }
                }
            }
            this.cacheUntil(driver, from + count, untilFirstLineWithCode);
            return this.createResult(from, Integer.min(from + count, this.myFrames.size()));
        }

        private void cacheUntil(@NotNull DebuggerDriver driver, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (driver == null) {
                CidrStackFramesCache.$$$reportNull$$$0(2);
            }
            if (!this.myHasMore) {
                return;
            }
            if (this.myFrames.size() >= count) {
                return;
            }
            DebuggerDriver.ResultList<LLFrame> result2 = driver.getFrames(CidrExecutionStack.this.myThread, this.myFrames.size(), count - this.myFrames.size(), untilFirstLineWithCode);
            this.myFrames.addAll(result2.list);
            this.myHasMore = result2.hasMore;
        }

        @NotNull
        private DebuggerDriver.ResultList<LLFrame> createResult(int from, int to) {
            return new DebuggerDriver.ResultList<LLFrame>(this.myFrames.subList(from, to), this.myHasMore || this.myFrames.size() > to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack$CidrStackFramesCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack$CidrStackFramesCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrames";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheUntil";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

