/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryViewPanel
implements ComponentContainer {
    @NotNull
    protected final JPanel myComponent;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final FileEditor myFileEditor;
    @NotNull
    protected final GotoAddressPanel myGotoAddressPanel;

    private MemoryViewPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull GotoAddressPanel gotoAddressPanel) {
        if (project == null) {
            MemoryViewPanel.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            MemoryViewPanel.$$$reportNull$$$0(1);
        }
        if (gotoAddressPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(2);
        }
        this.myComponent = new JPanel(new BorderLayout());
        this.myProject = project;
        this.myFileEditor = fileEditor;
        this.myGotoAddressPanel = gotoAddressPanel;
        this.myComponent.add((Component)((Object)this.myGotoAddressPanel), "First");
        this.myComponent.add(fileEditor.getComponent());
    }

    @Nullable
    public static MemoryViewPanel create(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorProvider[] providers;
        if (project == null) {
            MemoryViewPanel.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MemoryViewPanel.$$$reportNull$$$0(4);
        }
        if ((providers = FileEditorProviderManager.getInstance().getProviders(project, file)).length == 0) {
            return null;
        }
        FileEditorProvider provider = providers[0];
        FileEditor fileEditor = provider.createEditor(project, file);
        GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor));
        if (gotoAddressPanel == null) {
            Disposer.dispose((Disposable)fileEditor);
            return null;
        }
        MemoryViewPanel memoryViewPanel = new MemoryViewPanel(project, fileEditor, gotoAddressPanel);
        Disposer.register((Disposable)memoryViewPanel, (Disposable)fileEditor);
        return memoryViewPanel;
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myGotoAddressPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public FileEditor getFileEditor() {
        FileEditor fileEditor = this.myFileEditor;
        if (fileEditor == null) {
            MemoryViewPanel.$$$reportNull$$$0(6);
        }
        return fileEditor;
    }

    @NotNull
    public GotoAddressPanel getGotoAddressPanel() {
        GotoAddressPanel gotoAddressPanel = this.myGotoAddressPanel;
        if (gotoAddressPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(7);
        }
        return gotoAddressPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoAddressPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/MemoryViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/MemoryViewPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoAddressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

