/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.util.ByteList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JC\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\b\u0010'\u001a\u00020\bH\u0016R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "hexOpcodes", "", "", "instruction", "", "comment", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;)V", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getComment", "()Ljava/lang/String;", "disassembly", "getDisassembly", "getFunctionOffset", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "getHexOpcodes", "()Ljava/util/List;", "getInstruction", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.cidr.debugger.backend"})
public final class LLInstruction {
    @NotNull
    private final String disassembly;
    @NotNull
    private final AddressRange range;
    @NotNull
    private final List<Byte> hexOpcodes;
    @NotNull
    private final String instruction;
    @NotNull
    private final String comment;
    @Nullable
    private final LLSymbolOffset functionOffset;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Address getAddress() {
        return this.range.getStart();
    }

    @NotNull
    public final String getDisassembly() {
        return this.disassembly;
    }

    @NotNull
    public String toString() {
        return this.disassembly;
    }

    @NotNull
    public final AddressRange getRange() {
        return this.range;
    }

    @NotNull
    public final List<Byte> getHexOpcodes() {
        return this.hexOpcodes;
    }

    @NotNull
    public final String getInstruction() {
        return this.instruction;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    @Nullable
    public final LLSymbolOffset getFunctionOffset() {
        return this.functionOffset;
    }

    private LLInstruction(AddressRange range, List<Byte> hexOpcodes, String instruction, String comment, LLSymbolOffset functionOffset) {
        this.range = range;
        this.hexOpcodes = hexOpcodes;
        this.instruction = instruction;
        this.comment = comment;
        this.functionOffset = functionOffset;
        String string = !StringsKt.isBlank((CharSequence)this.comment) ? StringsKt.padEnd$default((String)this.instruction, (int)33, (char)'\u0000', (int)2, null) + " ; " + this.comment : this.instruction;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        this.disassembly = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        AddressUtil.requireNotEmpty((ClosedRange)this.range);
        boolean bl2 = this.range.getSize() == (long)this.hexOpcodes.size();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string3 = "Range " + this.range + " of size " + this.range.getSize() + "; hexOpcodes.size=" + this.hexOpcodes.size();
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
    }

    public /* synthetic */ LLInstruction(AddressRange range, List hexOpcodes, String instruction, String comment, LLSymbolOffset functionOffset, DefaultConstructorMarker $constructor_marker) {
        this(range, hexOpcodes, instruction, comment, functionOffset);
    }

    @NotNull
    public final AddressRange component1() {
        return this.range;
    }

    @NotNull
    public final List<Byte> component2() {
        return this.hexOpcodes;
    }

    @NotNull
    public final String component3() {
        return this.instruction;
    }

    @NotNull
    public final String component4() {
        return this.comment;
    }

    @Nullable
    public final LLSymbolOffset component5() {
        return this.functionOffset;
    }

    @NotNull
    public final LLInstruction copy(@NotNull AddressRange range, @NotNull List<Byte> hexOpcodes, @NotNull String instruction, @NotNull String comment, @Nullable LLSymbolOffset functionOffset) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(hexOpcodes, (String)"hexOpcodes");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return new LLInstruction(range, hexOpcodes, instruction, comment, functionOffset);
    }

    public static /* synthetic */ LLInstruction copy$default(LLInstruction lLInstruction, AddressRange addressRange, List list, String string, String string2, LLSymbolOffset lLSymbolOffset, int n, Object object) {
        if ((n & 1) != 0) {
            addressRange = lLInstruction.range;
        }
        if ((n & 2) != 0) {
            list = lLInstruction.hexOpcodes;
        }
        if ((n & 4) != 0) {
            string = lLInstruction.instruction;
        }
        if ((n & 8) != 0) {
            string2 = lLInstruction.comment;
        }
        if ((n & 0x10) != 0) {
            lLSymbolOffset = lLInstruction.functionOffset;
        }
        return lLInstruction.copy(addressRange, list, string, string2, lLSymbolOffset);
    }

    public int hashCode() {
        AddressRange addressRange = this.range;
        List<Byte> list = this.hexOpcodes;
        String string = this.instruction;
        String string2 = this.comment;
        LLSymbolOffset lLSymbolOffset = this.functionOffset;
        return ((((addressRange != null ? ((Object)addressRange).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (lLSymbolOffset != null ? ((Object)lLSymbolOffset).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LLInstruction)) break block3;
                LLInstruction lLInstruction = (LLInstruction)object;
                if (!Intrinsics.areEqual((Object)this.range, (Object)lLInstruction.range) || !Intrinsics.areEqual(this.hexOpcodes, lLInstruction.hexOpcodes) || !Intrinsics.areEqual((Object)this.instruction, (Object)lLInstruction.instruction) || !Intrinsics.areEqual((Object)this.comment, (Object)lLInstruction.comment) || !Intrinsics.areEqual((Object)this.functionOffset, (Object)lLInstruction.functionOffset)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final LLInstruction create(@NotNull Address address, @NotNull String opcodesStr, @Nullable String disassembly, @Nullable String comment, @Nullable LLSymbolOffset functionOffset) {
        return Companion.create(address, opcodesStr, disassembly, comment, functionOffset);
    }

    @JvmStatic
    @NotNull
    public static final LLInstruction create(@NotNull Address address, @NotNull Iterable<Byte> opcodesBytes, @NotNull String mnemonic, @NotNull String operands, @Nullable String comment, @Nullable LLSymbolOffset functionOffset) {
        return Companion.create(address, opcodesBytes, mnemonic, operands, comment, functionOffset);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction$Companion;", "", "()V", "create", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "opcodesStr", "", "disassembly", "comment", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "opcodesBytes", "", "", "mnemonic", "operands", "opcodes", "", "intellij.cidr.debugger.backend"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LLInstruction create(@NotNull Address address, @NotNull String opcodesStr, @Nullable String disassembly, @Nullable String comment, @Nullable LLSymbolOffset functionOffset) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)opcodesStr, (String)"opcodesStr");
            List list = (List)ByteList.Companion.parseSpaceSeparatedHex(opcodesStr);
            String string = disassembly;
            if (string == null) {
                string = "/* BAD: " + opcodesStr + " */";
            }
            return this.create(address, list, string, comment, functionOffset);
        }

        @JvmStatic
        @NotNull
        public final LLInstruction create(@NotNull Address address, @NotNull Iterable<Byte> opcodesBytes, @NotNull String mnemonic, @NotNull String operands, @Nullable String comment, @Nullable LLSymbolOffset functionOffset) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter(opcodesBytes, (String)"opcodesBytes");
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            Intrinsics.checkNotNullParameter((Object)operands, (String)"operands");
            List list = (List)ByteList.Companion.fromIterable(opcodesBytes);
            String string = "%1$-6s %2$s";
            Object[] objectArray = new Object[]{mnemonic, operands};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            return this.create(address, list, string2, comment, functionOffset);
        }

        @NotNull
        public final LLInstruction create(@NotNull Address address, @NotNull List<Byte> opcodes, @NotNull String disassembly, @Nullable String comment, @Nullable LLSymbolOffset functionOffset) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter(opcodes, (String)"opcodes");
            Intrinsics.checkNotNullParameter((Object)disassembly, (String)"disassembly");
            AddressRange addressRange = AddressUtil.addressRangeExclusive(address, address.plus(opcodes.size()));
            String string = comment;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            return new LLInstruction(addressRange, opcodes, disassembly, string2, functionOffset, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

