/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValueData {
    private static final Pattern HEX_VALUE_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)\\b");
    private static final Pattern INTEGER_WITH_DATA_PATTERN = Pattern.compile("^(-?(?:0x\\p{XDigit}+|\\d+))\\b(?!\\.)\\s*(.*?)\\s*$");
    private static final String NIL_PATTERN_STRING = "0x0+";
    private static final Pattern NULL_POINTER_PATTERN = Pattern.compile("0x0+");
    @NotNull
    private final String myValue;
    @Nullable
    private final String myDescription;
    private final boolean myHasLongerDescription;
    private final boolean myMayHaveChildren;
    private final boolean myIsSynthetic;

    public LLValueData(@NotNull String value, @Nullable String description, boolean hasLongerDescription, boolean mayHaveChildren, boolean isSynthetic) {
        if (value == null) {
            LLValueData.$$$reportNull$$$0(0);
        }
        this.myValue = value;
        this.myDescription = description;
        this.myHasLongerDescription = hasLongerDescription;
        this.myMayHaveChildren = mayHaveChildren;
        this.myIsSynthetic = isSynthetic;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    public boolean hasLongerDescription() {
        return this.myHasLongerDescription;
    }

    @NotNull
    public String getPresentableValue() {
        String string = this.myDescription != null ? this.myDescription : this.myValue;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean mayHaveChildren() {
        return this.myMayHaveChildren;
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isPointer() {
        return this.getPointerOrNull() != null;
    }

    public boolean isValidPointer() {
        String pointer = this.getPointerOrNull();
        return pointer != null && !NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    public boolean isNullPointer() {
        return LLValueData.isNullPointer(this.getPointerOrNull());
    }

    private static boolean isNullPointer(@Nullable String pointer) {
        return pointer != null && NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    @NotNull
    public String getPointer() throws DebuggerCommandException {
        String result2 = this.getPointerOrNull();
        if (result2 == null) {
            throw new DebuggerCommandException("Value is not a valid pointer: " + this.myValue);
        }
        String string = result2;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getPointerOrNull() {
        return LLValueData.getPointer(this.myValue);
    }

    @Nullable
    public static String getPointer(@Nullable String value) {
        if (value == null) {
            return null;
        }
        List matches = StringUtil.findMatches((String)value, (Pattern)HEX_VALUE_PATTERN);
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return null;
    }

    @Nullable
    public String getPresentablePointer() {
        int i;
        Object pointer = this.getPointerOrNull();
        if (pointer == null) {
            return null;
        }
        if (LLValueData.isNullPointer((String)pointer)) {
            return "0x0";
        }
        for (i = 2; i < ((String)pointer).length() && ((String)pointer).charAt(i) == '0'; ++i) {
        }
        if (i > 2) {
            pointer = "0x" + ((String)pointer).substring(i);
        }
        return pointer;
    }

    @Nullable
    public Address getPointerAddress() {
        String pointer = this.getPointerOrNull();
        if (pointer == null) {
            return null;
        }
        if (LLValueData.isNullPointer(pointer)) {
            return Address.NULL;
        }
        try {
            return Address.parseHexString(pointer);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public Pair<String, String> splitNumberAndData() {
        String description = this.myDescription != null ? this.myDescription : this.myValue;
        Matcher matcher = INTEGER_WITH_DATA_PATTERN.matcher(description);
        if (!matcher.matches()) {
            Pair pair = Pair.create(null, (Object)description);
            if (pair == null) {
                LLValueData.$$$reportNull$$$0(4);
            }
            return pair;
        }
        try {
            Long.decode(matcher.group(1));
        }
        catch (NumberFormatException e) {
            Pair pair = Pair.create(null, (Object)description);
            if (pair == null) {
                LLValueData.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)matcher.group(1), (Object)matcher.group(2));
        if (pair == null) {
            LLValueData.$$$reportNull$$$0(6);
        }
        return pair;
    }

    public boolean isTrue() {
        return !this.isFalse();
    }

    public boolean isFalse() {
        String[] s;
        for (String s1 : s = new String[]{NIL_PATTERN_STRING, "0+", "false", "NO", "'\\\\0'", "0 [LUu]?'.*'"}) {
            if (!Pattern.compile(s1).matcher(this.myValue).matches()) continue;
            return true;
        }
        return false;
    }

    public long intValue() throws DebuggerCommandException {
        try {
            String pointer = this.getPointerOrNull();
            if (pointer != null) {
                return DebuggerDriver.parseAddressSafe(pointer).unsignedLongValue();
            }
            return new BigInteger(this.myValue).longValue();
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException("Value is not a valid integer: " + this.myValue);
        }
    }

    public String toString() {
        return (this.myIsSynthetic ? "[synthetic]" : "") + this.myValue + "(" + this.myDescription + ")" + (this.myMayHaveChildren ? ",has children" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLValueData valueData = (LLValueData)o;
        if (this.myMayHaveChildren != valueData.myMayHaveChildren) {
            return false;
        }
        if (this.myIsSynthetic != valueData.myIsSynthetic) {
            return false;
        }
        if (!this.myValue.equals(valueData.myValue)) {
            return false;
        }
        return !(this.myDescription != null ? !this.myDescription.equals(valueData.myDescription) : valueData.myDescription != null);
    }

    public int hashCode() {
        int result2 = this.myValue.hashCode();
        result2 = 31 * result2 + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result2 = 31 * result2 + (this.myMayHaveChildren ? 1 : 0);
        result2 = 31 * result2 + (this.myIsSynthetic ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLValueData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLValueData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNumberAndData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

